/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;

public class WeekTransformMapFunction
extends MapFunction {
    private RowMeta rowMeta;
    private int transformFieldIndex;
    private String dayofweek;

    public WeekTransformMapFunction(RowMeta rowMeta, String transformField, String dayofweek) {
        this.rowMeta = rowMeta;
        this.transformFieldIndex = rowMeta.getFieldIndex(transformField);
        this.dayofweek = dayofweek;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX row) {
        RowX newRow = new RowX(this.rowMeta.getFieldCount());
        for (int i = 0; i < this.rowMeta.getFieldCount(); ++i) {
            if (this.transformFieldIndex == i) {
                Date d = row.getDate(i);
                Date monday = WeekTransformMapFunction.getTheWeekStart(d, 2);
                monday = WeekTransformMapFunction.getMondayOffset(monday, this.dayofweek);
                newRow.set(i, (Object)monday);
                continue;
            }
            newRow.set(i, row.get(i));
        }
        return newRow;
    }

    public static Date getTheWeekStart(Date baseDate, int firstDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.setFirstDayOfWeek(firstDay);
        cal.set(7, 2);
        return cal.getTime();
    }

    public static Date getMondayOffset(Date monday, String dayOfWeek) {
        long offsetMillis = 0L;
        long time = 0L;
        if ("Mon".equalsIgnoreCase(dayOfWeek)) {
            offsetMillis = 0L;
        } else if ("Tue".equalsIgnoreCase(dayOfWeek)) {
            offsetMillis += 86400000L;
        } else if ("Wed".equalsIgnoreCase(dayOfWeek)) {
            offsetMillis += 172800000L;
        } else if ("Thu".equalsIgnoreCase(dayOfWeek)) {
            offsetMillis += 259200000L;
        } else if ("Fri".equalsIgnoreCase(dayOfWeek)) {
            offsetMillis += 345600000L;
        } else if ("Sat".equalsIgnoreCase(dayOfWeek)) {
            offsetMillis += 432000000L;
        } else if ("Sun".equalsIgnoreCase(dayOfWeek)) {
            offsetMillis = 518400000L;
        }
        if (monday != null) {
            time = monday.getTime();
        }
        return new Date(time + offsetMillis);
    }
}

