/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.algorithm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.mmc.mds.common.algorithm.db.AlgorithmDBHelper;
import kd.mmc.mds.common.algorithm.db.DataSetSaver;
import kd.mmc.mds.common.algorithm.handle.AbstractFieldHandler;
import kd.mmc.mds.common.algorithm.handle.impl.StandardGroupFieldHandler;
import kd.mmc.mds.common.algorithm.model.AlgorithmDef;
import kd.mmc.mds.common.algorithm.model.FieldConfig;
import kd.mmc.mds.common.algorithm.reader.AlgorithmDefReader;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;

public class Algorithm {
    private Long algorithmDefId;
    private AlgorithmDef algorithmDef;
    private String srcBillNumber;
    private String[] commonGroup;
    private Set<String> finishField;
    private String[] maxDimension;
    private List<FieldConfig> srcFieldConfList;
    private List<FieldConfig> destFieldConfList;
    private String destBillNumber;

    public String getDestBillNumber() {
        return this.destBillNumber;
    }

    public Algorithm(Long algorithmDefId, String[] commonGroup) {
        this.algorithmDefId = algorithmDefId;
        this.commonGroup = commonGroup;
    }

    public void init() {
        this.algorithmDef = AlgorithmDefReader.read(this.algorithmDefId);
        this.finishField = new HashSet<String>(16);
        this.srcBillNumber = this.algorithmDef.getSrcDef().getBillNumber();
        HashSet<String> maxDimensionSet = new HashSet<String>(16);
        maxDimensionSet.addAll(Arrays.asList(this.commonGroup));
        maxDimensionSet.addAll(this.algorithmDef.getSrcDef().getMaxDimension());
        this.maxDimension = maxDimensionSet.toArray(new String[0]);
        this.srcFieldConfList = this.algorithmDef.getSrcDef().getFieldConfList();
        this.destFieldConfList = this.algorithmDef.getDestDef().getFieldConfList();
        this.destBillNumber = this.algorithmDef.getDestDef().getBillNumber();
    }

    public DataSet process() throws Exception {
        return this.process(new QFilter[0], null, -1);
    }

    public DataSet process(QFilter[] qFilters, String orderBys, int top) throws Exception {
        this.init();
        String selectField = AlgorithmDBHelper.buildSelectField(this.algorithmDef);
        DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)Algorithm.class.getName(), (String)this.srcBillNumber, (String)selectField, (QFilter[])qFilters, (String)orderBys, (int)top);
        for (String field : this.commonGroup) {
            if (MdsAlgoUtils.existField(mainDataSet.getRowMeta(), field)) continue;
            mainDataSet = mainDataSet.addNullField(field);
        }
        DataSet head = mainDataSet.groupBy(this.maxDimension).finish();
        this.finishField.addAll(Arrays.asList(this.maxDimension));
        for (FieldConfig config : this.srcFieldConfList) {
            head = this.calcGroup(head, mainDataSet, config);
        }
        for (FieldConfig config : this.destFieldConfList) {
            String[] dimension = config.getDimension();
            if (dimension != null && dimension.length > 0) {
                head = this.calcGroup(head, head, config);
                continue;
            }
            if (config.isCustomFieldHandler()) {
                head = this.calcGroup(head, head, config);
                continue;
            }
            head = this.calc(head, config);
        }
        return head;
    }

    private DataSet calc(DataSet head, FieldConfig config) {
        String fieldId = config.getFieldId();
        String calculate = config.getCalculate();
        String exprStr = this.buildExprStr(new String[]{fieldId}, new String[]{calculate});
        HashSet<String> curFiled = new HashSet<String>();
        curFiled.addAll(this.finishField);
        if (this.finishField.contains(fieldId)) {
            curFiled.remove(fieldId);
        }
        curFiled.add(exprStr);
        this.finishField.add(fieldId);
        return head.select(curFiled.toArray(new String[0]));
    }

    private DataSet calcGroup(DataSet head, DataSet mainDataSet, FieldConfig config) throws Exception {
        AbstractFieldHandler handler = this.getFieldHandler(config);
        DataSet childDataSet = handler.process(mainDataSet);
        String[] joinField = handler.getJoinField();
        String[] calcField = handler.getCalcField();
        boolean joinCommon = handler.isJoinCommon();
        JoinDataSet join = head.leftJoin(childDataSet);
        if (joinCommon) {
            for (String field : this.commonGroup) {
                join = join.on(field, field);
            }
        }
        for (String field : joinField) {
            join = join.on(field, field);
        }
        HashSet<String> calc = new HashSet<String>(16);
        calc.addAll(Arrays.asList(calcField));
        Set<String> curFinishField = this.finishField.stream().filter(o -> !calc.contains(o)).collect(Collectors.toSet());
        this.finishField.addAll(Arrays.asList(calcField));
        return join.select(curFinishField.toArray(new String[0]), calcField).finish();
    }

    public void toDB(DataSet dataSet) {
        DataSetSaver saver = new DataSetSaver(this.destBillNumber);
        saver.init();
        saver.saveByDynamicObject(dataSet);
    }

    private AbstractFieldHandler getFieldHandler(FieldConfig config) throws Exception {
        AbstractFieldHandler handler;
        String[] dimension = config.getDimension();
        String[] expr = new String[]{config.getCalculate()};
        String[] fieldId = new String[]{config.getFieldId()};
        if (config.isCustomFieldHandler()) {
            String pluginName = config.getCalculate();
            Class<?> clazz = Class.forName(pluginName);
            Object task = clazz.newInstance();
            if (!(task instanceof AbstractFieldHandler)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u63d2\u4ef6\u7c7b\u578b\u9519\u8bef\u3002", (String)"Algorithm_0", (String)"mmc-mds-common", (Object[])new Object[0]));
            }
            handler = (AbstractFieldHandler)task;
        } else {
            handler = new StandardGroupFieldHandler();
        }
        handler.setCommonGroup(this.commonGroup);
        handler.setDimension(dimension);
        handler.setFieldId(fieldId);
        handler.setExpr(expr);
        return handler;
    }

    private String buildExprStr(String[] fieldId, String[] expr) {
        int length = Math.min(fieldId.length, expr.length);
        CharSequence[] exprArr = new String[length];
        for (int i = 0; i < length; ++i) {
            StringBuilder sb = new StringBuilder(" ");
            sb.append(expr[i]);
            sb.append(" as ");
            sb.append(fieldId[i]);
            sb.append(" ");
            exprArr[i] = sb.toString();
        }
        return String.join((CharSequence)",", exprArr);
    }

    public boolean validation(StringBuilder errMsg) {
        boolean flag = true;
        this.init();
        try {
            this.process(new QFilter[0], null, 1);
        }
        catch (Exception e) {
            errMsg.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            flag = false;
        }
        return flag;
    }
}

