/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.algorithm.db;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.algorithm.reader.BillReader;
import kd.mmc.mds.common.algorithm.util.ResourceFieldUtil;

public class DataSetSaver {
    private Map<String, String> keyRelFieldName;
    private String tableName;
    private String billNumber;
    private MainEntityType dataEntityType;
    private static final Log logger = LogFactory.getLog(DataSetSaver.class);

    public DataSetSaver(String billNumber) {
        this.billNumber = billNumber;
    }

    public void init() {
        this.keyRelFieldName = BillReader.getKeyRelFieldName(this.billNumber);
        this.tableName = BillReader.getTableName(this.billNumber);
        this.dataEntityType = EntityMetadataCache.getDataEntityType((String)this.billNumber);
    }

    public Map<String, String> getKeyRelFieldName() {
        return this.keyRelFieldName;
    }

    public void setKeyRelFieldName(Map<String, String> keyRelFieldName) {
        this.keyRelFieldName = keyRelFieldName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public void saveByDynamicObject(DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        HashSet<Field> allField = new HashSet<Field>(Arrays.asList(fields));
        Set insertField = allField.stream().map(Field::getName).filter(o -> this.keyRelFieldName.containsKey(o)).collect(Collectors.toSet());
        try (TXHandle h = TX.required();){
            try {
                LinkedList<DynamicObject> values = new LinkedList<DynamicObject>();
                for (Row row : dataSet) {
                    DynamicObject temp = BusinessDataServiceHelper.newDynamicObject((String)this.billNumber);
                    for (String field : insertField) {
                        IDataEntityProperty findProperty = this.dataEntityType.findProperty(field);
                        if (findProperty instanceof MulBasedataProp) {
                            this.setMulBasedataVal(field, row, temp);
                            continue;
                        }
                        temp.set(field, row.get(field));
                    }
                    values.add(temp);
                    if (values.size() < 10000) continue;
                    this.executeBatch(values);
                }
                if (values.size() > 0) {
                    this.executeBatch(values);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void setMulBasedataVal(String field, Row row, DynamicObject obj) {
        String mulVal = row.getString(field);
        DynamicObjectCollection mulBasedata = obj.getDynamicObjectCollection(field);
        if (StringUtils.isNotEmpty((CharSequence)mulVal)) {
            String[] valArr;
            for (String val : valArr = mulVal.split(",")) {
                DynamicObject addNew = mulBasedata.addNew();
                addNew.set("fbasedataid", (Object)val);
            }
        }
    }

    private void executeBatch(List<DynamicObject> values) {
        SaveServiceHelper.save((DynamicObject[])values.toArray(new DynamicObject[0]));
    }

    public void save(DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        HashSet<Field> allField = new HashSet<Field>(Arrays.asList(fields));
        Set insertField = allField.stream().map(Field::getName).filter(o -> this.keyRelFieldName.containsKey(o)).collect(Collectors.toSet());
        StringBuilder sqlsb = new StringBuilder();
        sqlsb.append("insert into ");
        sqlsb.append(this.tableName);
        sqlsb.append("(");
        LinkedList<String> list = new LinkedList<String>();
        LinkedList<String> list2 = new LinkedList<String>();
        for (String field : insertField) {
            String filedName = this.keyRelFieldName.get(field);
            if (StringUtils.isNotBlank((CharSequence)filedName)) {
                list.add(filedName);
                list2.add("?");
                continue;
            }
            logger.info(String.format("skip filed '%s'", filedName));
        }
        sqlsb.append(String.join((CharSequence)",", list)).append(")values ( ").append(String.join((CharSequence)",", list2)).append(")");
        String sql = sqlsb.toString();
        try (TXHandle h = TX.required();){
            try {
                LinkedList<Object[]> sqlParams = new LinkedList<Object[]>();
                int size = 0;
                for (Row row : dataSet) {
                    ++size;
                    Object[] val = new Object[insertField.size()];
                    int i = 0;
                    for (String field : insertField) {
                        Object temp = row.get(field);
                        if (temp == null) {
                            temp = this.getDefaultValue(field);
                        }
                        val[i] = temp;
                        ++i;
                    }
                    sqlParams.add(val);
                    if (size < 100000) continue;
                    this.dbExecuteBatch(sql, sqlParams);
                    sqlParams.clear();
                    size = 0;
                }
                if (sqlParams.size() > 0) {
                    this.dbExecuteBatch(sql, sqlParams);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private Object getDefaultValue(String field) {
        if (this.dataEntityType == null) {
            return "";
        }
        IDataEntityProperty findProperty = this.dataEntityType.findProperty(field);
        if (findProperty instanceof DynamicProperty) {
            return ResourceFieldUtil.getMetaDataFieldDefaultValue((DynamicProperty)findProperty);
        }
        return "";
    }

    private void dbExecuteBatch(String updateSeqSql, List<Object[]> updateList) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSeqSql, updateList);
    }
}

