/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.algorithm.handle.impl;

import java.util.Arrays;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.mmc.mds.common.algorithm.handle.AbstractFieldHandler;

public class StandardGroupFieldHandler
extends AbstractFieldHandler {
    @Override
    public String[] getCalcField() {
        return super.getFieldId();
    }

    @Override
    public String[] getJoinField() {
        return super.getDimension();
    }

    @Override
    public DataSet process(DataSet dataSet) {
        String sql = this.buildAlgoSql();
        return dataSet.executeSql(sql);
    }

    private String buildAlgoSql() {
        StringBuilder sb = new StringBuilder();
        String dimensionStr = this.buildDimensionStr();
        String exprSql = this.buildExprStr();
        sb.append("select ");
        sb.append(exprSql);
        sb.append(",");
        sb.append(dimensionStr);
        sb.append(" group by ");
        sb.append(dimensionStr);
        return sb.toString();
    }

    private String buildDimensionStr() {
        String[] dimension = super.getDimension();
        String[] commonGroup = super.getCommonGroup();
        HashSet<String> allDimension = new HashSet<String>(16);
        allDimension.addAll(Arrays.asList(dimension));
        allDimension.addAll(Arrays.asList(commonGroup));
        return String.join((CharSequence)",", allDimension);
    }

    private String buildExprStr() {
        String[] fieldId = super.getFieldId();
        String[] expr = super.getExpr();
        int length = Math.min(fieldId.length, expr.length);
        CharSequence[] exprArr = new String[length];
        for (int i = 0; i < length; ++i) {
            StringBuilder sb = new StringBuilder(" ");
            sb.append(expr[i]);
            sb.append(" as ");
            sb.append(fieldId[i]);
            sb.append(" ");
            exprArr[i] = sb.toString();
        }
        return String.join((CharSequence)",", exprArr);
    }
}

