/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.algorithm.reader;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.algorithm.model.AlgorithmDef;
import kd.mmc.mds.common.algorithm.model.BillDestDef;
import kd.mmc.mds.common.algorithm.model.BillSrcDef;
import kd.mmc.mds.common.algorithm.model.FieldConfig;
import kd.mmc.mds.common.algorithm.reader.BillReader;

public class AlgorithmDefReader {
    public static AlgorithmDef read(Long algorithmDefId) {
        AlgorithmDef algorithmDef = new AlgorithmDef(algorithmDefId);
        DynamicObject mds_algorithmdef = BusinessDataServiceHelper.loadSingleFromCache((Object)algorithmDefId, (String)"mds_algorithmdef");
        if (mds_algorithmdef == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b97\u6cd5\u5b9a\u4e49\u672a\u627e\u5230\u3002", (String)"AlgorithmDefReader_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        BillSrcDef billSrcDef = AlgorithmDefReader.readSrcBill(mds_algorithmdef);
        BillDestDef billDestDef = AlgorithmDefReader.readDestBill(mds_algorithmdef);
        algorithmDef.setDestDef(billDestDef);
        algorithmDef.setSrcDef(billSrcDef);
        return algorithmDef;
    }

    private static BillDestDef readDestBill(DynamicObject mds_algorithmdef) {
        BillDestDef billDestDef = new BillDestDef();
        String destBillNumber = mds_algorithmdef.getString("destbill.number");
        Map<String, String> destKeyRelFieldName = BillReader.getKeyRelFieldName(destBillNumber);
        List<FieldConfig> fieldConfList = BillReader.getDestFieldConfig(mds_algorithmdef.getLong("id"));
        Set<String> maxDimension = BillReader.getMaxDimension(fieldConfList);
        String tableName = BillReader.getTableName(destBillNumber);
        HashSet<String> allField = new HashSet<String>(16);
        allField.addAll(destKeyRelFieldName.keySet());
        billDestDef.setKeyRelFieldName(destKeyRelFieldName);
        billDestDef.setAllField(allField);
        billDestDef.setFieldConfList(fieldConfList);
        billDestDef.setMaxDimension(maxDimension);
        billDestDef.setTableName(tableName);
        billDestDef.setBillNumber(destBillNumber);
        return billDestDef;
    }

    private static BillSrcDef readSrcBill(DynamicObject mds_algorithmdef) {
        BillSrcDef billSrcDef = new BillSrcDef();
        String srcBillNumber = mds_algorithmdef.getString("srcbill.number");
        Map<String, String> srcKeyRelFieldName = BillReader.getKeyRelFieldName(srcBillNumber);
        List<FieldConfig> fieldConfList = BillReader.getSrcFieldConfig(mds_algorithmdef.getLong("id"));
        Set<String> maxDimension = BillReader.getMaxDimension(fieldConfList);
        HashSet<String> allField = new HashSet<String>(16);
        allField.addAll(srcKeyRelFieldName.keySet());
        billSrcDef.setBillNumber(srcBillNumber);
        billSrcDef.setKeyRelFieldName(srcKeyRelFieldName);
        billSrcDef.setAllField(allField);
        billSrcDef.setFieldConfList(fieldConfList);
        billSrcDef.setMaxDimension(maxDimension);
        return billSrcDef;
    }
}

