/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.algorithm.reader;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.algorithm.model.FieldConfig;

public class BillReader {
    public static String getTableName(String billNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        return dataEntityType.getAlias();
    }

    public static String[] getBillPK(String billNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        String[] primaryKey = new String[2];
        ISimpleProperty property = dataEntityType.getPrimaryKey();
        if (property != null) {
            primaryKey[0] = property.getName();
            primaryKey[1] = property.getAlias();
        }
        return primaryKey;
    }

    public static Map<String, String> getKeyRelFieldName(String billNumber) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        Map allFields = dataEntityType.getAllFields();
        dataEntityType.getProperties();
        for (IDataEntityProperty pro : allFields.values()) {
            String parentName = pro.getParent().getName();
            if (!StringUtils.equals((CharSequence)billNumber, (CharSequence)parentName)) continue;
            String name = pro.getName();
            String alias = pro.getAlias();
            result.put(name, alias);
        }
        String[] primaryKey = BillReader.getBillPK(billNumber);
        if (primaryKey.length > 0) {
            result.put(primaryKey[0], primaryKey[1]);
        }
        return result;
    }

    public static List<FieldConfig> getSrcFieldConfig(Long algorithmDefId) {
        LinkedList<FieldConfig> fieldConfList = new LinkedList<FieldConfig>();
        String selectField = "entryentitysrc.caldimensionvalsrc  as dimension,entryentitysrc.fieldidsrc as fieldid ,entryentitysrc.calmethodsrc as calmethod,entryentitysrc.calculateexcsrc as calculate";
        DataSet dataSet = BillReader.getEntryentityDataSet(selectField, "entryentitysrc.seq", algorithmDefId);
        for (Row row : dataSet) {
            FieldConfig fieldConfig = BillReader.buildFieldConfig(row);
            fieldConfList.add(fieldConfig);
        }
        dataSet.close();
        return fieldConfList;
    }

    public static List<FieldConfig> getDestFieldConfig(Long algorithmDefId) {
        LinkedList<FieldConfig> fieldConfList = new LinkedList<FieldConfig>();
        String selectField = "entryentitydest.caldimensionvaldest  as dimension,entryentitydest.fieldiddest as fieldid ,entryentitydest.calmethoddest as calmethod,entryentitydest.calculateexcdest as calculate";
        DataSet dataSet = BillReader.getEntryentityDataSet(selectField, "entryentitydest.seq", algorithmDefId);
        for (Row row : dataSet) {
            FieldConfig fieldConfig = BillReader.buildFieldConfig(row);
            fieldConfList.add(fieldConfig);
        }
        dataSet.close();
        return fieldConfList;
    }

    private static DataSet getEntryentityDataSet(String selectField, String order, Long algorithmDefId) {
        return QueryServiceHelper.queryDataSet((String)BillReader.class.getName(), (String)"mds_algorithmdef", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)algorithmDefId)}, (String)order);
    }

    private static FieldConfig buildFieldConfig(Row row) {
        FieldConfig fieldConfig = new FieldConfig();
        String dimensionstr = row.getString("dimension");
        String fieldId = row.getString("fieldid");
        String calmethod = row.getString("calmethod");
        String calculate = row.getString("calculate");
        String[] dimension = new String[]{};
        if (StringUtils.isNotEmpty((CharSequence)dimensionstr)) {
            dimension = dimensionstr.split(",");
        }
        fieldConfig.setDimension(dimension);
        fieldConfig.setFieldId(fieldId);
        fieldConfig.setCustomFieldHandler("1".equalsIgnoreCase(calmethod));
        fieldConfig.setCalculate(calculate);
        return fieldConfig;
    }

    public static Set<String> getMaxDimension(List<FieldConfig> fieldConfList) {
        HashSet<String> result = new HashSet<String>(16);
        for (FieldConfig config : fieldConfList) {
            result.addAll(Arrays.asList(config.getDimension()));
        }
        return result;
    }
}

