/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.algorithm.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.tree.TreeNode;
import kd.mmc.mds.common.algorithm.util.EntityFieldTypeEnum;

public class ResourceFieldUtil {
    public static TreeNode buildCalTreeNodes(BillTreeBuildParameter parameter) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List<TreeNode> fldNodes = ResourceFieldUtil.buildFldCalTreeNodes(parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            if (!"billhead".equals(parentNode.getId())) continue;
            parentNode.addChild(node);
        }
        return billNode;
    }

    public static List<TreeNode> buildFldCalTreeNodes(BillTreeBuildParameter parameter) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        MainEntityType mainType = parameter.getMainType();
        HashSet<Object> selectedEntity = new HashSet(parameter.getSelectedEntity());
        if (selectedEntity.size() == 0) {
            selectedEntity = new HashSet(mainType.getAllEntities().keySet());
        }
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            EntityType entityType;
            if (!selectedEntity.contains(entry.getKey()) || (entityType = (EntityType)entry.getValue()) instanceof LinkEntryType) continue;
            String entityNodeId = entityType.getName();
            String entityNodeName = "";
            boolean isHead = false;
            if (entityType instanceof MainEntityType) {
                entityNodeName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ResourceFieldUtil_0", (String)"mmc-mds-common", (Object[])new Object[0]);
                entityNodeId = "billhead";
                isHead = true;
            } else if (entityType.getDisplayName() != null) {
                entityNodeName = entityType.getDisplayName().toString();
            }
            TreeNode entityNode = new TreeNode(mainType.getName(), entityNodeId, entityNodeName);
            entityNode.setIsOpened(true);
            ArrayList<TreeNode> entityFldNodes = new ArrayList<TreeNode>();
            if (parameter.isIncludePKField()) {
                ResourceFieldUtil.buildPKFldTreeNode(entityType, entityNode, entityFldNodes, parameter);
            }
            for (IDataEntityProperty property : entityType.getFields().values()) {
                BasedataProp bdProp;
                MainEntityType bdType;
                List<TreeNode> refNodes;
                boolean matched = false;
                if (parameter.isOnlyPhysicsField() && StringUtils.isBlank((CharSequence)property.getAlias()) || "id".equalsIgnoreCase(property.getName()) || "seq".equalsIgnoreCase(property.getName())) continue;
                TreeNode fldNode = null;
                fldNode = isHead ? ResourceFieldUtil.BuildFldTreeNode(property, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, "", parameter.isDynamicText()) : ResourceFieldUtil.BuildFldTreeNode(property, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getExtendName(), parameter.isDynamicText());
                if (fldNode != null) {
                    entityFldNodes.add(fldNode);
                    matched = true;
                }
                if (!(property instanceof BasedataProp)) continue;
                if (fldNode == null) {
                    fldNode = ResourceFieldUtil.BuildFldTreeNode(property, null, null, entityNode, "", parameter.isDynamicText());
                }
                if ((refNodes = ResourceFieldUtil.BuildBDFldRefPropNodes(bdType = (MainEntityType)(bdProp = (BasedataProp)property).getComplexType(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), fldNode, entityType.getExtendName() + '.' + property.getName(), parameter.isDynamicText())).size() <= 0) continue;
                entityFldNodes.addAll(refNodes);
                if (matched) continue;
                entityFldNodes.add(fldNode);
            }
            if (entityFldNodes.size() <= 0) continue;
            nodes.add(entityNode);
            nodes.addAll(entityFldNodes);
        }
        return nodes;
    }

    private static TreeNode BuildFldTreeNode(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode parentNode, String prefix, boolean isDynamicText) {
        TreeNode fldNode = null;
        boolean isMatch = ResourceFieldUtil.isMatchType(fldProperty, matchedProperty, matchedClassType);
        DynamicProperty prop = null;
        if (fldProperty instanceof DynamicProperty) {
            prop = (DynamicProperty)fldProperty;
        }
        if (isMatch && prop != null) {
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            if (isDynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }

    private static boolean isMatchType(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType) {
        boolean isMatch = true;
        if (matchedClassType != null && !matchedClassType.isInstance(fldProperty)) {
            isMatch = false;
        }
        if (matchedProperty != null) {
            if (matchedProperty instanceof BasedataProp && fldProperty instanceof BasedataProp) {
                BasedataProp bdProp1 = (BasedataProp)matchedProperty;
                BasedataProp bdProp2 = (BasedataProp)fldProperty;
                if (matchedProperty.getClass().isInstance(fldProperty)) {
                    return true;
                }
                if (bdProp1.isFromSampleMaster((IDataEntityProperty)bdProp2)) {
                    return true;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)bdProp1.getBaseEntityId(), (CharSequence)bdProp2.getBaseEntityId())) {
                    isMatch = false;
                }
            } else if (!matchedProperty.getClass().isInstance(fldProperty)) {
                isMatch = false;
            }
            if (!isMatch && (matchedProperty instanceof DateProp || matchedProperty instanceof DateTimeProp) && (fldProperty instanceof DateProp || fldProperty instanceof DateTimeProp)) {
                isMatch = true;
            } else if (!isMatch && (matchedProperty instanceof IntegerProp || matchedProperty instanceof DecimalProp || matchedProperty instanceof QtyProp) && (fldProperty instanceof IntegerProp || fldProperty instanceof DecimalProp || fldProperty instanceof QtyProp)) {
                isMatch = true;
            } else if (!isMatch && (matchedProperty instanceof TextProp || matchedProperty instanceof MuliLangTextProp || matchedProperty instanceof ComboProp) && (fldProperty instanceof TextProp || fldProperty instanceof MuliLangTextProp || fldProperty instanceof ComboProp)) {
                isMatch = true;
            }
        }
        return isMatch;
    }

    private static void buildPKFldTreeNode(EntityType entityType, TreeNode entityNode, List<TreeNode> entityFldNodes, BillTreeBuildParameter parameter) {
        if (entityType instanceof MainEntityType) {
            TreeNode idNode = ResourceFieldUtil.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, "", parameter.isDynamicText());
            if (idNode != null) {
                idNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"ResourceFieldUtil_1", (String)"mmc-mds-common", (Object[])new Object[0]), entityType.getDisplayName().getLocaleValue()));
                entityFldNodes.add(idNode);
            }
        } else {
            TreeNode seqNode;
            DynamicProperty seqProp;
            TreeNode idNode = ResourceFieldUtil.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText());
            if (idNode != null) {
                idNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"ResourceFieldUtil_2", (String)"mmc-mds-common", (Object[])new Object[0]), entityType.getDisplayName().getLocaleValue()));
                entityFldNodes.add(idNode);
            }
            if ((seqProp = entityType.getProperty("seq")) != null && (seqNode = ResourceFieldUtil.BuildFldTreeNode((IDataEntityProperty)seqProp, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText())) != null) {
                seqNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5e8f\u53f7", (String)"ResourceFieldUtil_3", (String)"mmc-mds-common", (Object[])new Object[0]), entityType.getDisplayName().getLocaleValue()));
                entityFldNodes.add(seqNode);
            }
        }
    }

    private static List<TreeNode> BuildBDFldRefPropNodes(MainEntityType bdType, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode bdFldNode, String prefix, boolean isDynamicText) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        if (bdType == null) {
            return refNodes;
        }
        for (IDataEntityProperty property : bdType.getFields().values()) {
            String prefix2;
            BasedataProp bdProp2;
            MainEntityType bdType2;
            List<TreeNode> refNodes2;
            if (property instanceof EntryProp) continue;
            TreeNode fldNode = ResourceFieldUtil.BuildFldTreeNode(property, matchedProperty, matchedClassType, bdFldNode, prefix, isDynamicText);
            boolean matched = false;
            if (fldNode != null) {
                refNodes.add(fldNode);
                matched = true;
            }
            if (!(property instanceof BasedataProp)) continue;
            if (fldNode == null) {
                fldNode = ResourceFieldUtil.BuildFldTreeNode(property, null, null, bdFldNode, prefix, isDynamicText);
            }
            if ((refNodes2 = ResourceFieldUtil.BuildBDFldRefPropNodes(bdType2 = (MainEntityType)(bdProp2 = (BasedataProp)property).getComplexType(), matchedProperty, matchedClassType, fldNode, prefix2 = prefix + "." + property.getName(), isDynamicText)).size() <= 0) continue;
            refNodes.addAll(refNodes2);
            if (matched) continue;
            refNodes.add(fldNode);
        }
        return refNodes;
    }

    public static String getAbsoluteDisplayPropertyName(IDataEntityProperty property) {
        StringBuilder disPlayName = new StringBuilder();
        if (property.getParent() != null && property.getParent() instanceof EntryType) {
            disPlayName.append(property.getParent().getDisplayName()).append('.');
        } else {
            disPlayName.append(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ResourceFieldUtil_4", (String)"mmc-mds-common", (Object[])new Object[0])).append('.');
        }
        disPlayName.append(property.getDisplayName());
        return disPlayName.toString();
    }

    public static String getFuncsXML(String[] supportMethod) {
        HashSet<String> functionSet = new HashSet<String>(Arrays.asList(supportMethod));
        FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
        Iterator functionTypeIterator = functionTypes.getFunctionTypes().iterator();
        while (functionTypeIterator.hasNext()) {
            FunctionType function = (FunctionType)functionTypeIterator.next();
            String functionId = function.getId();
            if (functionSet.contains(functionId)) continue;
            functionTypeIterator.remove();
        }
        List functionGroups = functionTypes.getFunctionGroups();
        for (FunctionGroup functionGroup : functionGroups) {
            String id = functionGroup.getId();
            if (!"Set".equalsIgnoreCase(id)) continue;
            functionGroup.setName(new LocaleString(ResManager.loadKDString((String)"\u805a\u5408\u51fd\u6570", (String)"ResourceFieldUtil_6", (String)"mmc-mds-common", (Object[])new Object[0])));
            break;
        }
        return FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
    }

    public static String buildPropFullCaption(EntityType mainType, String fullPropName) {
        ArrayList<String> captions = new ArrayList<String>();
        Map<String, IDataEntityProperty> props = ResourceFieldUtil.findPropertys(mainType, fullPropName);
        IDataEntityProperty firstProp = props.entrySet().iterator().next().getValue();
        if (firstProp != null) {
            IDataEntityType parentType = null;
            parentType = firstProp instanceof EntryProp ? ((EntryProp)firstProp).getItemType() : firstProp.getParent();
            if (parentType instanceof MainEntityType) {
                captions.add(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ResourceFieldUtil_5", (String)"mpscmm-msplan-business", (Object[])new Object[0]));
            }
        }
        for (Map.Entry<String, IDataEntityProperty> item : props.entrySet()) {
            if (item.getValue() == null) {
                captions.add(item.getKey());
                continue;
            }
            IDataEntityProperty property = item.getValue();
            if (property instanceof DynamicProperty) {
                LocaleString displayCaption = ((DynamicProperty)property).getDisplayName();
                captions.add(displayCaption == null ? item.getKey() : displayCaption.toString());
                continue;
            }
            captions.add(item.getKey());
        }
        return StringUtils.join((Object[])captions.toArray(), (String)".");
    }

    public static Map<String, IDataEntityProperty> findPropertys(EntityType mainType, String fullPropName) {
        LinkedHashMap<String, IDataEntityProperty> props = new LinkedHashMap<String, IDataEntityProperty>();
        if (mainType.getName().equalsIgnoreCase(fullPropName) || "billhead".equalsIgnoreCase(fullPropName)) {
            props.put(fullPropName, (IDataEntityProperty)mainType.getPrimaryKey());
            return props;
        }
        Object prop = null;
        String[] keys = fullPropName.split("\\.");
        ArrayList<String> unknowKeys = new ArrayList<String>(16);
        String key1 = null;
        int index = 0;
        boolean flag = false;
        for (int i = 0; i < keys.length; ++i) {
            unknowKeys.add(keys[i]);
            if (flag || keys[i].equals(mainType.getExtendName())) continue;
            key1 = keys[i];
            index = i;
            flag = true;
        }
        int nextKeyIndex = index + 1;
        if (keys.length == 1) {
            prop = mainType.findProperty(key1);
            if (prop != null) {
                props.put(key1, (IDataEntityProperty)prop);
            } else {
                props.put(key1, null);
            }
            unknowKeys.clear();
        } else if (keys.length > 1) {
            prop = mainType.findProperty(key1);
            if (prop == null) {
                props.put(fullPropName, null);
                unknowKeys.clear();
            } else {
                props.put(key1, (IDataEntityProperty)prop);
                unknowKeys.remove(0);
                String key2 = keys[nextKeyIndex];
                if (prop instanceof EntryProp) {
                    prop = mainType.findProperty(key2);
                    if (prop == null) {
                        prop = mainType.findProperty(key1 + "." + key2);
                    }
                    ++nextKeyIndex;
                    if (prop != null) {
                        props.put(key2, (IDataEntityProperty)prop);
                        unknowKeys.remove(0);
                    }
                }
                if (prop instanceof BasedataProp && keys.length > nextKeyIndex) {
                    key2 = keys[nextKeyIndex];
                    ++nextKeyIndex;
                    BasedataProp bdProp1 = (BasedataProp)prop;
                    MainEntityType baseEntityType1 = (MainEntityType)bdProp1.getComplexType();
                    if ((prop = baseEntityType1.getPrimaryKey().getName().equals(key2) ? baseEntityType1.getPrimaryKey() : baseEntityType1.findProperty(key2)) != null) {
                        props.put(key2, (IDataEntityProperty)prop);
                        unknowKeys.remove(0);
                    }
                    if (prop instanceof BasedataProp && keys.length > nextKeyIndex) {
                        String key3 = keys[nextKeyIndex];
                        ++nextKeyIndex;
                        BasedataProp bdProp2 = (BasedataProp)prop;
                        MainEntityType baseEntityType2 = (MainEntityType)bdProp2.getComplexType();
                        if ((prop = baseEntityType2.getPrimaryKey().getName().equals(key3) ? baseEntityType2.getPrimaryKey() : baseEntityType2.findProperty(key3)) != null) {
                            props.put(key3, (IDataEntityProperty)prop);
                            unknowKeys.remove(0);
                        }
                    }
                }
            }
        }
        if (unknowKeys.size() > 0) {
            // empty if block
        }
        return props;
    }

    public static String getMetaDataFieldType(DynamicProperty dynamicProperty) {
        String typeName = null;
        if (dynamicProperty instanceof TimeProp) {
            typeName = EntityFieldTypeEnum.getName(TimeProp.class);
        } else if (dynamicProperty instanceof LargeTextProp) {
            typeName = EntityFieldTypeEnum.getName(LargeTextProp.class);
        } else if (dynamicProperty instanceof MuliLangTextProp) {
            typeName = EntityFieldTypeEnum.getName(MuliLangTextProp.class);
        } else if (dynamicProperty instanceof TextAreaProp) {
            typeName = EntityFieldTypeEnum.getName(TextAreaProp.class);
        } else if (dynamicProperty instanceof TextProp) {
            typeName = EntityFieldTypeEnum.getName(TextProp.class);
        } else if (dynamicProperty instanceof BigIntProp) {
            typeName = EntityFieldTypeEnum.getName(BigIntProp.class);
        } else if (dynamicProperty instanceof IntegerProp) {
            typeName = EntityFieldTypeEnum.getName(IntegerProp.class);
        } else if (dynamicProperty instanceof PriceProp) {
            typeName = EntityFieldTypeEnum.getName(PriceProp.class);
        } else if (dynamicProperty instanceof DateTimeProp) {
            typeName = EntityFieldTypeEnum.getName(DateTimeProp.class);
        } else if (dynamicProperty instanceof QtyProp) {
            typeName = EntityFieldTypeEnum.getName(QtyProp.class);
        } else if (dynamicProperty instanceof BooleanProp) {
            typeName = EntityFieldTypeEnum.getName(BooleanProp.class);
        } else if (dynamicProperty instanceof CreaterProp) {
            typeName = EntityFieldTypeEnum.getName(CreaterProp.class);
        } else if (dynamicProperty instanceof ModifierProp) {
            typeName = EntityFieldTypeEnum.getName(ModifierProp.class);
        } else if (dynamicProperty instanceof MainOrgProp) {
            typeName = EntityFieldTypeEnum.getName(MainOrgProp.class);
        } else if (dynamicProperty instanceof OrgProp) {
            typeName = EntityFieldTypeEnum.getName(OrgProp.class);
        } else if (dynamicProperty instanceof MaterielProp) {
            typeName = EntityFieldTypeEnum.getName(MaterielProp.class);
        } else if (dynamicProperty instanceof GroupProp) {
            typeName = EntityFieldTypeEnum.getName(GroupProp.class);
        } else if (dynamicProperty instanceof FlexProp) {
            typeName = EntityFieldTypeEnum.getName(FlexProp.class);
        } else if (dynamicProperty instanceof UserProp) {
            typeName = EntityFieldTypeEnum.getName(UserProp.class);
        } else if (dynamicProperty instanceof BasedataProp) {
            typeName = EntityFieldTypeEnum.getName(BasedataProp.class);
        } else if (dynamicProperty instanceof ItemClassTypeProp) {
            typeName = EntityFieldTypeEnum.getName(ItemClassTypeProp.class);
        } else if (dynamicProperty instanceof ComboProp) {
            typeName = EntityFieldTypeEnum.getName(ComboProp.class);
        } else if (dynamicProperty instanceof DecimalProp) {
            typeName = EntityFieldTypeEnum.getName(DecimalProp.class);
        }
        return typeName;
    }

    public static Object getMetaDataFieldDefaultValue(DynamicProperty dynamicProperty) {
        Object defaultValue = null;
        if (dynamicProperty instanceof TimeProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(TimeProp.class);
        } else if (dynamicProperty instanceof LargeTextProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(LargeTextProp.class);
        } else if (dynamicProperty instanceof MuliLangTextProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(MuliLangTextProp.class);
        } else if (dynamicProperty instanceof TextAreaProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(TextAreaProp.class);
        } else if (dynamicProperty instanceof TextProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(TextProp.class);
        } else if (dynamicProperty instanceof BigIntProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(BigIntProp.class);
        } else if (dynamicProperty instanceof IntegerProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(IntegerProp.class);
        } else if (dynamicProperty instanceof PriceProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(PriceProp.class);
        } else if (dynamicProperty instanceof DateTimeProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(DateTimeProp.class);
        } else if (dynamicProperty instanceof QtyProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(QtyProp.class);
        } else if (dynamicProperty instanceof BooleanProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(BooleanProp.class);
        } else if (dynamicProperty instanceof CreaterProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(CreaterProp.class);
        } else if (dynamicProperty instanceof ModifierProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(ModifierProp.class);
        } else if (dynamicProperty instanceof MainOrgProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(MainOrgProp.class);
        } else if (dynamicProperty instanceof OrgProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(OrgProp.class);
        } else if (dynamicProperty instanceof MaterielProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(MaterielProp.class);
        } else if (dynamicProperty instanceof GroupProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(GroupProp.class);
        } else if (dynamicProperty instanceof FlexProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(FlexProp.class);
        } else if (dynamicProperty instanceof UserProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(UserProp.class);
        } else if (dynamicProperty instanceof BasedataProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(BasedataProp.class);
        } else if (dynamicProperty instanceof ItemClassTypeProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(ItemClassTypeProp.class);
        } else if (dynamicProperty instanceof ComboProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(ComboProp.class);
        } else if (dynamicProperty instanceof DecimalProp) {
            defaultValue = EntityFieldTypeEnum.getDefaultValue(DecimalProp.class);
        }
        return defaultValue;
    }
}

