/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.batchtask;

import java.util.HashMap;
import java.util.Map;
import kd.bos.id.ID;
import kd.mmc.mds.common.batchtask.BatchTaskEvent;
import kd.mmc.mds.common.batchtask.BatchTaskImpl;
import kd.mmc.mds.common.batchtask.context.CalcContext;
import kd.mmc.mds.common.batchtask.util.HeartBeat;

public abstract class BatchTask {
    static Map<String, BatchTask> batchTaskCache = new HashMap<String, BatchTask>(16);

    public abstract CalcContext getContext();

    abstract void setHeartBeat(HeartBeat var1);

    abstract void setHeartCtx(CalcContext var1);

    static BatchTask getBatchTask(String taskId) {
        return batchTaskCache.get(taskId);
    }

    public static BatchTask create(String calcName) {
        String calcId = ID.genStringId();
        BatchTask task = batchTaskCache.computeIfAbsent(calcId, k -> new BatchTaskImpl());
        CalcContext newContext = new CalcContext();
        newContext.setCalcName(calcName);
        newContext.setCalcId(calcId);
        task.setHeartBeat(new HeartBeat());
        task.setHeartCtx(newContext);
        return task;
    }

    public String getCalcId() {
        return this.getContext().getCalcId();
    }

    abstract boolean fastFail();

    abstract void taskFail();

    abstract boolean isInterrupt();

    abstract void taskInterrupt();

    public abstract void registBizClass(Class<? extends BatchTaskEvent> var1);

    public abstract void addEvent(Map var1);

    abstract void childTaskFinish(CalcContext var1);

    public abstract void setQueueName(String var1);

    abstract String getQueueName();

    public abstract void startTask() throws Exception;

    public abstract void terminate();

    public static void interrupt(String calcId) {
        kd.mpscmm.msplan.mservice.service.batchtask.BatchTask.interrupt((String)calcId);
    }
}

