/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.batchtask;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.mmc.mds.common.batchtask.BatchTask;
import kd.mmc.mds.common.batchtask.BatchTaskEvent;
import kd.mmc.mds.common.batchtask.consumer.BatchConsumer;
import kd.mmc.mds.common.batchtask.context.CalcContext;
import kd.mmc.mds.common.batchtask.util.CacheManager;
import kd.mmc.mds.common.batchtask.util.HeartBeat;
import kd.mmc.mds.common.batchtask.util.MQManager;

public class BatchTaskImpl
extends BatchTask {
    private static final Log logger = LogFactory.getLog(BatchTaskImpl.class);
    private CalcContext ctx;
    private HeartBeat heartBeat;
    private boolean isFail = false;
    private boolean isInterrupt = false;
    private long masterCheckPeriod = 10000L;
    private long masterKeepAlivePeriod = 30000L;
    private int masterKeepAliveTimeout = 78;
    private Timer timer;
    private CacheManager cacheManager;
    private String queueName;
    private final List<Map> needEvents = new LinkedList<Map>();
    private final Map<Long, CalcContext> calEvents = new HashMap<Long, CalcContext>(16);

    BatchTaskImpl() {
    }

    @Override
    public CalcContext getContext() {
        return this.ctx;
    }

    @Override
    public void setHeartBeat(HeartBeat heartBeat) {
        this.heartBeat = heartBeat;
    }

    @Override
    public void setHeartCtx(CalcContext ctx) {
        this.ctx = ctx;
    }

    @Override
    boolean fastFail() {
        return this.isFail;
    }

    @Override
    void taskFail() {
        logger.info(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s',\u72b6\u6001\u76d1\u63a7\u7ebf\u7a0b\u76d1\u6d4b\u5230\u4efb\u52a1\u5931\u8d25", this.ctx.getCalcName(), this.ctx.getCalcId()));
        this.isFail = true;
    }

    @Override
    boolean isInterrupt() {
        return this.isInterrupt;
    }

    @Override
    void taskInterrupt() {
        logger.info(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s',\u72b6\u6001\u76d1\u63a7\u7ebf\u7a0b\u76d1\u6d4b\u5230\u4efb\u52a1\u624b\u52a8\u5173\u95ed", this.ctx.getCalcName(), this.ctx.getCalcId()));
        this.isInterrupt = true;
    }

    @Override
    public void registBizClass(Class<? extends BatchTaskEvent> clazz) {
        this.ctx.setBizClazzName(clazz.getName());
    }

    @Override
    public void addEvent(Map params) {
        this.needEvents.add(params);
    }

    @Override
    synchronized void childTaskFinish(CalcContext ctx) {
        Long id = ctx.getChildId();
        String calcId = ctx.getCalcId();
        this.heartBeat.refresh();
        this.calEvents.remove(id);
        logger.info(String.format("BatchTask\uff0cCalcName:'%s',CalcId:'%s',ChildId:'%s'\uff0c\u4e3b\u8282\u70b9\u6536\u5230\u5b50\u4efb\u52a1\u5b8c\u6210", ctx.getCalcName(), calcId, id));
    }

    @Override
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public void startTask() throws Exception {
        StringBuilder errMsg = new StringBuilder();
        if (!this.validation(errMsg)) {
            logger.error(errMsg.insert(0, String.format("BatchTask:CalcName:'%s'\uff0cCalcId:'%s' ,\u542f\u52a8\u5931\u8d25:", this.ctx.getCalcName(), this.ctx.getCalcId())).toString());
        }
        this.startCheckThread();
        MQManager.registControlQueue(this.ctx, BatchConsumer.class);
        logger.info(String.format("BatchTask:CalcName:'%s'\uff0cCalcId:'%s'\uff0cQueueName:'%s',\u6ce8\u518cControlQueue......", this.ctx.getCalcName(), this.ctx.getCalcId(), this.getQueueName()));
        this.publishChildTask();
        do {
            if (this.heartBeat.isTimeOut()) {
                logger.error(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s',\u4efb\u52a1\u8d85\u65f6", this.ctx.getCalcName(), this.ctx.getCalcId()));
                throw new KDBizException("BatchTask timeout\u3002");
            }
            if (this.fastFail()) {
                logger.error(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s',\u4efb\u52a1\u5931\u8d25\uff0c\u4e3b\u8282\u70b9\u5173\u95ed", this.ctx.getCalcName(), this.ctx.getCalcId()));
                throw new KDBizException(this.cacheManager.get("fail_msg_key"));
            }
            if (!this.isInterrupt()) continue;
            logger.info(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s',\u4efb\u52a1\u624b\u52a8\u505c\u6b62\uff0c\u4e3b\u8282\u70b9\u5173\u95ed", this.ctx.getCalcName(), this.ctx.getCalcId()));
            return;
        } while (!this.calEventsEmpty());
    }

    private void publishChildTask() {
        MessagePublisher pub = MQFactory.get().createSimplePublisher("mmc", this.getQueueName());
        Long id = 0L;
        logger.info(String.format("BatchTask:CalcName:'%s'\uff0cCalcId:'%s',\u4efb\u52a1\u5f00\u59cb.....", this.ctx.getCalcName(), this.ctx.getCalcId()));
        for (Map params : this.needEvents) {
            Long l = id;
            Long l2 = id = Long.valueOf(id + 1L);
            CalcContext childCtx = new CalcContext();
            childCtx.setCalcName(this.ctx.getCalcName());
            childCtx.setCalcId(this.ctx.getCalcId());
            childCtx.setBizClazzName(this.ctx.getBizClazzName());
            childCtx.setParams(params);
            childCtx.setChildId(id);
            this.calEvents.put(id, childCtx);
            pub.publish((Object)childCtx);
        }
        pub.close();
        logger.info(String.format("BatchTask:CalcName:'%s'\uff0cCalcId:'%s',\u4efb\u52a1\u5206\u53d1\u5b8c\u6210", this.ctx.getCalcName(), this.ctx.getCalcId()));
    }

    private void startCheckThread() {
        this.timer = new Timer();
        this.cacheManager = new CacheManager(this.ctx.getCalcId());
        this.cacheManager.put("fail_msg_key", "");
        this.cacheManager.put("fail_tag_key", "0");
        this.cacheManager.put("interrupt_msg_key", "0");
        TimerTask masterCheckTimeTask = new TimerTask(){

            @Override
            public void run() {
                String failTag = BatchTaskImpl.this.cacheManager.get("fail_tag_key");
                String interruptTag = BatchTaskImpl.this.cacheManager.get("interrupt_msg_key");
                if ("1".equals(failTag)) {
                    BatchTaskImpl.this.taskFail();
                    BatchTaskImpl.this.timer.cancel();
                }
                if ("1".equals(interruptTag)) {
                    BatchTaskImpl.this.taskInterrupt();
                    BatchTaskImpl.this.timer.cancel();
                }
            }
        };
        this.timer.scheduleAtFixedRate(masterCheckTimeTask, this.masterCheckPeriod, this.masterCheckPeriod);
        TimerTask masterLiveTimeTask = new TimerTask(){

            @Override
            public void run() {
                BatchTaskImpl.this.cacheManager.put("master_keep_live", "is_live", BatchTaskImpl.this.masterKeepAliveTimeout);
            }
        };
        this.timer.scheduleAtFixedRate(masterLiveTimeTask, 0L, this.masterKeepAlivePeriod);
    }

    private synchronized boolean calEventsEmpty() {
        return this.calEvents.isEmpty();
    }

    private boolean validation(StringBuilder errMsg) {
        String queueName = this.getQueueName();
        String bizClazzName = this.getContext().getBizClazzName();
        if (StringUtils.isEmpty((CharSequence)queueName)) {
            errMsg.append(ResManager.loadKDString((String)"queueName\u4e3a\u7a7a\u3002", (String)"BatchTaskImpl_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)bizClazzName)) {
            errMsg.append(ResManager.loadKDString((String)"bizClazzName\u4e3a\u7a7a\u3002", (String)"BatchTaskImpl_1", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        return errMsg.length() == 0;
    }

    @Override
    public void terminate() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.cacheManager != null) {
            this.cacheManager.removeAll();
        }
        if (this.ctx != null) {
            MQManager.deleteControlQueue(this.ctx);
            batchTaskCache.remove(this.ctx.getCalcId());
            logger.info(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s',\u4efb\u52a1\u7ed3\u675f\u6e05\u9664\u7f13\u5b58", this.ctx.getCalcName(), this.ctx.getCalcId()));
        }
    }
}

