/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.batchtask.consumer;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessagePublisher;
import kd.bos.util.ExceptionUtils;
import kd.mmc.mds.common.batchtask.BatchTaskEvent;
import kd.mmc.mds.common.batchtask.BatchTasks;
import kd.mmc.mds.common.batchtask.consumer.BatchConsumer;
import kd.mmc.mds.common.batchtask.context.CalcContext;
import kd.mmc.mds.common.batchtask.util.CacheManager;
import kd.mmc.mds.common.batchtask.util.MQManager;
import kd.mmc.mds.common.batchtask.util.MQUtils;

public class BatchBizConsumer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onMessage(Object body, String messageId, boolean resend, MessageAcker acker, Log logger) {
        CalcContext ctx = null;
        if (body instanceof CalcContext) {
            ctx = (CalcContext)body;
        }
        if (ctx == null) {
            acker.discard(messageId);
            return;
        }
        if (resend) {
            acker.ack(messageId);
            logger.info(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s'\uff0cchildId:'%s'\uff0cresend:'true'\u5b50\u4efb\u52a1\u8282\u70b9\u6536\u5230resend\u4efb\u52a1\uff0c\u6682\u4e0d\u505a\u5904\u7406\u3002", ctx.getCalcName(), ctx.getCalcId(), ctx.getChildId()));
        } else {
            logger.info(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s'\uff0cchildId:'%s'\uff0cresend:'false'\u5b50\u4efb\u52a1\u8282\u70b9\u6536\u5230\u4efb\u52a1,\u5f00\u59cb\u6267\u884c\u5b50\u4efb\u52a1\u3002", ctx.getCalcName(), ctx.getCalcId(), ctx.getChildId()));
        }
        CacheManager cacheManager = new CacheManager(ctx.getCalcId());
        String fail = cacheManager.get("fail_tag_key");
        String interrupt = cacheManager.get("interrupt_msg_key");
        String masterIsLive = cacheManager.get("master_keep_live");
        if (!"is_live".equals(masterIsLive)) {
            BatchTasks.clear(ctx.getCalcName(), ctx.getCalcId());
            logger.info(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s'\uff0cchildId:'%s'\u5b50\u8282\u70b9\u68c0\u6d4b\u5230\u4e3b\u8282\u70b9\u5df2\u5931\u8d25\uff0c\u6e05\u7406\u4efb\u52a1\u3002", ctx.getCalcName(), ctx.getCalcId(), ctx.getChildId()));
            return;
        }
        if (!"0".equals(fail)) {
            acker.ack(messageId);
            logger.info(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s'\uff0cchildId:'%s'\u68c0\u6d4b\u5230\u4efb\u52a1\u5df2\u7ecf\u7ed3\u675f\uff0c\u8df3\u8fc7\u4efb\u52a1\u5904\u7406\u3002", ctx.getCalcName(), ctx.getCalcId(), ctx.getChildId()));
            return;
        }
        if (!"0".equals(interrupt)) {
            acker.ack(messageId);
            logger.info(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s'\uff0cchildId:'%s'\u68c0\u6d4b\u5230\u4efb\u52a1\u5df2\u7ecf\u624b\u52a8\u7ed3\u675f\uff0c\u8df3\u8fc7\u4efb\u52a1\u5904\u7406\u3002", ctx.getCalcName(), ctx.getCalcId(), ctx.getChildId()));
            return;
        }
        Map params = ctx.getParams();
        String bizClazzName = ctx.getBizClazzName();
        try {
            Class<?> clazz = Class.forName(bizClazzName);
            Object task = clazz.newInstance();
            if (!(task instanceof BatchTaskEvent)) {
                logger.error(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s'\uff0cchildId:'%s'", ctx.getCalcName(), ctx.getCalcId(), ctx.getChildId()));
                throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\u9519\u8bef\u3002", (String)"BatchBizConsumer_0", (String)"mmc-mds-common", (Object[])new Object[0]));
            }
            ((BatchTaskEvent)task).execute(params);
        }
        catch (Exception e) {
            logger.error(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s'\uff0cchildId:'%s'\uff0c\u5b50\u4efb\u52a1\u8282\u70b9\u53d1\u73b0\u5f02\u5e38:'%s'\uff0c\u6807\u8bb0\u4efb\u52a1\u5931\u8d25\u3002", ctx.getCalcName(), ctx.getCalcId(), ctx.getChildId(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            cacheManager.put("fail_msg_key", e.getMessage());
            cacheManager.put("fail_tag_key", "1");
            return;
        }
        MQManager.registNode(ctx, BatchConsumer.class);
        String queueName = MQUtils.buildQueueName(ctx.getCalcName(), ctx.getCalcId());
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("mmc", queueName);){
            ctx.setParams(null);
            pub.publish((Object)ctx);
            acker.ack(messageId);
            logger.info(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s'\uff0cchildId:'%s'\uff0c\u5b50\u4efb\u52a1\u8282\u70b9\u4efb\u52a1\u5b8c\u6210\u3002", ctx.getCalcName(), ctx.getCalcId(), ctx.getChildId()));
        }
    }
}

