/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.datafetch;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msplan.mservice.service.datafetch.DataFetcher;

public class DataFetchUtil {
    private static String entityName = "mds_datafetchset";

    public static DataSet fetchDataBySetId(long id) {
        return DataFetchUtil.fetchDataBySetId(id, null);
    }

    public static DataSet fetchDataBySetId(long id, String addSrcEntityNameField) {
        DataSet dataSet = null;
        DynamicObject datafetchset = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityName);
        DynamicObjectCollection resourceentity = datafetchset.getDynamicObjectCollection("resourceentity");
        List modelIds = resourceentity.stream().filter(o -> o.getBoolean("use")).map(o -> o.getLong("resource.id")).collect(Collectors.toList());
        DataFetcher dataFetcher = new DataFetcher();
        for (Long modelId : modelIds) {
            DataSet dsItem = dataFetcher.getDataSet(modelId);
            if (StringUtils.isNotEmpty((CharSequence)addSrcEntityNameField)) {
                String entityName = DataFetchUtil.getSrcEntityName(modelId);
                dsItem = dsItem.addField(String.format("'%s'", entityName), addSrcEntityNameField);
            }
            if (dataSet == null) {
                dataSet = dsItem;
                continue;
            }
            RowMeta leftRowMeta = dataSet.getRowMeta();
            RowMeta rightRowMeta = dsItem.getRowMeta();
            Field[] leftFields = leftRowMeta.getFields();
            Field[] rightFields = rightRowMeta.getFields();
            HashSet<String> allFieldName = new HashSet<String>(16);
            HashSet<String> leftName = new HashSet<String>(16);
            HashSet<String> rightName = new HashSet<String>(16);
            for (Field leftField : leftFields) {
                allFieldName.add(leftField.getName());
                leftName.add(leftField.getName());
            }
            for (Field rightField : rightFields) {
                allFieldName.add(rightField.getName());
                rightName.add(rightField.getName());
            }
            for (String fieldName : allFieldName) {
                if (!leftName.contains(fieldName)) {
                    dataSet = dataSet.addNullField(fieldName);
                }
                if (rightName.contains(fieldName)) continue;
                dsItem = dsItem.addNullField(fieldName);
            }
            dataSet = dataSet.select(allFieldName.toArray(new String[0]));
            dsItem = dsItem.select(allFieldName.toArray(new String[0]));
            dataSet = dataSet.union(dsItem);
        }
        return dataSet;
    }

    private static String getSrcEntityName(Long modelId) {
        String entityName = "";
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"mrp_resource_dataconf_rgt");
        if (dynamicObject != null) {
            entityName = dynamicObject.getString("billfieldtransfer.srcbill.id");
        }
        return entityName;
    }

    public static String getTargetEntityName(long id) {
        DynamicObject datafetchset = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityName);
        return datafetchset.getString("businessentity.number");
    }
}

