/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.deliveryquery;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.mmc.mds.common.deliveryquery.DeliveryQueryValidationUtil;
import kd.mmc.mds.common.deliveryquery.model.DeliveryBillConst;
import kd.mmc.mds.common.deliveryquery.model.DeliveryBillMapper;

public class DeliveryQueryManger {
    Object setId;
    DynamicObject setObj;
    List<DeliveryBillMapper> billMappers;
    private ORM orm = ORM.create();

    private DeliveryQueryManger() {
    }

    public static DeliveryQueryManger create(Object setId) throws KDBizException {
        if (setId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u8d27\u67e5\u8be2\u65b9\u6848\u7248\u672c\u4e3a\u7a7a\u3002", (String)"DeliveryQueryManger_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        DynamicObject setObj = BusinessDataServiceHelper.loadSingleFromCache((Object)setId, (String)"mds_deliveryqueryset");
        return DeliveryQueryManger.createByDynamicObject(setObj);
    }

    public static DeliveryQueryManger createByDynamicObject(DynamicObject setObj) throws KDBizException {
        if (setObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u8d27\u67e5\u8be2\u65b9\u6848\u4e3a\u7a7a\u3002", (String)"DeliveryQueryManger_1", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        DeliveryQueryManger manger = new DeliveryQueryManger();
        manger.setObj = setObj;
        manger.setId = setObj.getPkValue();
        manger.billMappers = manger.buildDeliveryBillMappers();
        StringBuilder errMsg = new StringBuilder();
        if (!DeliveryQueryValidationUtil.checkDeliveryQuerySet(manger.billMappers, errMsg)) {
            throw new KDBizException(errMsg.toString());
        }
        return manger;
    }

    private List<DeliveryBillMapper> buildDeliveryBillMappers() {
        if (this.setObj == null) {
            this.setObj = BusinessDataServiceHelper.loadSingleFromCache((Object)this.setId, (String)"mds_deliveryqueryset");
        }
        if (this.setObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u8d27\u67e5\u8be2\u65b9\u6848\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"DeliveryQueryManger_2", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        DynamicObjectCollection resourceentry = this.setObj.getDynamicObjectCollection("resourceentry");
        if (resourceentry == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u53d1\u8d27\u67e5\u8be2\u65b9\u6848\u201d\u65e0\u53d1\u8d27\u6570\u636e\u6e90\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"DeliveryQueryManger_3", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        List useResourceentry = resourceentry.stream().filter(o -> o.getBoolean("use")).collect(Collectors.toList());
        if (useResourceentry.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u53d1\u8d27\u67e5\u8be2\u65b9\u6848\u201d\u53d1\u8d27\u6570\u636e\u6e90\u672a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"DeliveryQueryManger_4", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        LinkedList<DeliveryBillMapper> mappers = new LinkedList<DeliveryBillMapper>();
        for (DynamicObject entry : useResourceentry) {
            DynamicObject source = entry.getDynamicObject("resource");
            if (source == null) continue;
            DeliveryBillMapper mapper = this.buildDeliveryBillMapper(entry);
            mapper.setDeliveryquerysetId(this.setId);
            mappers.add(mapper);
        }
        return mappers;
    }

    private DeliveryBillMapper buildDeliveryBillMapper(DynamicObject entry) {
        DeliveryBillMapper mapper = new DeliveryBillMapper();
        DynamicObject source = entry.getDynamicObject("resource");
        String deliverytype = entry.getString("deliverytype");
        source = BusinessDataServiceHelper.loadSingleFromCache((Object)source.getPkValue(), (String)"mrp_resource_dataconf_rgt");
        DynamicObject billfieldtransfer = source.getDynamicObject("billfieldtransfer");
        billfieldtransfer = BusinessDataServiceHelper.loadSingleFromCache((Object)billfieldtransfer.getPkValue(), (String)"mrp_billfieldtransfer");
        DynamicObjectCollection entryentity = billfieldtransfer.getDynamicObjectCollection("entryentity");
        String filter = source.getString("filter_tag");
        String sourceNumber = source.getString("number");
        String sourceName = source.getString("name");
        String entityNumber = billfieldtransfer.getDynamicObject("srcbill").getString("number");
        Object srcbillId = billfieldtransfer.getDynamicObject("srcbill").getPkValue();
        HashMap<String, String> destRelSrcMap = new HashMap<String, String>(16);
        HashMap<String, String> destRelConvertTypeMap = new HashMap<String, String>(16);
        for (DynamicObject fieldConf : entryentity) {
            String sourcefieldflag = fieldConf.getString("sourcefieldflag");
            String destfieldflag = fieldConf.getString("destfieldflag");
            String converttype = fieldConf.getString("converttype");
            String calculateexc = fieldConf.getString("calculateexc");
            if ("0".equals(converttype)) {
                destRelSrcMap.put(destfieldflag, sourcefieldflag);
            } else {
                destRelSrcMap.put(destfieldflag, calculateexc);
            }
            destRelConvertTypeMap.put(destfieldflag, converttype);
        }
        String materialSrc = (String)destRelSrcMap.get("materiel");
        String baseunitSrc = (String)destRelSrcMap.get("unit");
        if (baseunitSrc == null && materialSrc != null) {
            destRelSrcMap.put("unit", materialSrc + ".baseunit");
        }
        mapper.setSourceNumber(sourceNumber);
        mapper.setSourceName(sourceName);
        mapper.setDestRelSrcMap(destRelSrcMap);
        mapper.setDestRelConvertTypeMap(destRelConvertTypeMap);
        mapper.setFilters_tag(filter);
        mapper.setEntityNumber(entityNumber);
        mapper.setDeliverytype(deliverytype);
        mapper.setBilltype(srcbillId);
        return mapper;
    }

    public DataSet queryDeliverySet(Set<Long> materialIds) {
        JobSession session = AlgoX.createSession((String)"DeliveryQueryManger", (String)"DeliveryQueryManger");
        LinkedList<DataSetInput> dataSetInputs = new LinkedList<DataSetInput>();
        for (DeliveryBillMapper mapper : this.billMappers) {
            QFilter materialFilters;
            String materialSrc;
            String entityNumber = mapper.getEntityNumber();
            String filters_tag = mapper.getFilters_tag();
            Object billtype = mapper.getBilltype();
            String deliverytype = mapper.getDeliverytype();
            Map<String, String> destRelSrcMap = mapper.getDestRelSrcMap();
            QFilter filters = this.buildFilter(filters_tag, entityNumber);
            String selectFields = this.buildSelect(destRelSrcMap);
            if (materialIds != null) {
                materialSrc = destRelSrcMap.get("materiel");
                materialFilters = new QFilter(materialSrc, "in", materialIds);
            } else {
                materialSrc = destRelSrcMap.get("materiel");
                materialFilters = new QFilter(materialSrc, "is not null", null);
            }
            if (filters != null) {
                filters.and(materialFilters);
            } else {
                filters = materialFilters;
            }
            DataSet dataSet = this.extracted(entityNumber, filters, selectFields);
            dataSet = dataSet.addFields(new String[]{"'" + billtype + "'", "'" + deliverytype + "'"}, new String[]{"billtype", "deliverytype"});
            dataSetInputs.add(new DataSetInput(dataSet));
        }
        DataSetX dataSetX = session.fromInput((Input[])dataSetInputs.toArray(new DataSetInput[0]));
        Field rundateField = new Field("rundate", (DataType)DataType.DateType);
        Field deliveryquerysetField = new Field("deliveryqueryset", (DataType)DataType.LongType);
        dataSetX = dataSetX.addFields(new Field[]{rundateField, deliveryquerysetField}, new Object[]{null, this.setId});
        DataSetOutput output = new DataSetOutput(dataSetX.getRowMeta());
        String outputId = output.getId();
        dataSetX.output((Output)output);
        session.commit(10, TimeUnit.MINUTES);
        DataSet dataset = session.readDataSet(outputId);
        return dataset;
    }

    private DataSet extracted(String entityNumber, QFilter filters, String selectFields) {
        return this.orm.queryDataSet("DeliveryQueryHelper", entityNumber, selectFields, new QFilter[]{filters});
    }

    public DataSet queryDeliverySet() {
        return this.queryDeliverySet(null);
    }

    private String buildSelect(Map<String, String> destRelSrcMap) {
        Set<String> requiredSet = DeliveryBillConst.selectFieldSet;
        StringBuilder buildSelectprop = new StringBuilder();
        for (String field : requiredSet) {
            if (buildSelectprop.length() > 0) {
                buildSelectprop.append(" , ");
            }
            String sourcefieldflag = destRelSrcMap.get(field);
            buildSelectprop.append(sourcefieldflag).append(" as ").append(field).append(" ");
        }
        return buildSelectprop.toString();
    }

    private QFilter buildFilter(String filter, String entityNumber) {
        FilterCondition filterCondition = new FilterCondition();
        if (!StringUtils.isBlank((CharSequence)filter)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        }
        filterCondition.setFilter(filter);
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        FilterBuilder fb = new FilterBuilder(mainType, filterCondition);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        QFilter filters = fb.getQFilter();
        return filters;
    }
}

