/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.deliveryquery;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.mds.common.deliveryquery.model.DeliveryBillMapper;

public class DeliveryQueryValidationUtil {
    public static boolean checkDeliveryQuerySet(List<DeliveryBillMapper> mappers, StringBuilder errMsg) {
        boolean flag = true;
        for (DeliveryBillMapper mapper : mappers) {
            if (!DeliveryQueryValidationUtil.checkRequired(mapper, errMsg)) {
                flag = false;
            }
            if (DeliveryQueryValidationUtil.checkRule(mapper, errMsg)) continue;
            flag = false;
        }
        return flag;
    }

    private static boolean checkRequired(DeliveryBillMapper mapper, StringBuilder errMsg) {
        LinkedList<String> errList = new LinkedList<String>();
        Map<String, String> destRelSrcMap = mapper.getDestRelSrcMap();
        String sourceNumber = mapper.getSourceNumber();
        String material = destRelSrcMap.get("materiel");
        String stockorg = destRelSrcMap.get("stockorg");
        String qty = destRelSrcMap.get("qty");
        String deliverydate = destRelSrcMap.get("deliverydate");
        if (StringUtils.isEmpty((CharSequence)material)) {
            errList.add(ResManager.loadKDString((String)"\u7269\u6599\u5b57\u6bb5\u4e3a\u7a7a", (String)"DeliveryQueryValidationUtil_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)qty)) {
            errList.add(ResManager.loadKDString((String)"\u6570\u91cf\u5b57\u6bb5\u4e3a\u7a7a", (String)"DeliveryQueryValidationUtil_1", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)deliverydate)) {
            errList.add(ResManager.loadKDString((String)"\u51fa\u5e93\u65e5\u671f\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"DeliveryQueryValidationUtil_2", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)stockorg)) {
            errList.add(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"DeliveryQueryValidationUtil_3", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        if (errList.size() > 0) {
            String err = String.join((CharSequence)";", errList);
            String msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u914d\u7f6e\uff1a%1$s\uff1a%2$s\u3002", (String)"DeliveryQueryValidationUtil_4", (String)"mmc-mds-common", (Object[])new Object[0]), sourceNumber, err);
            errMsg.append(msg);
            return false;
        }
        return true;
    }

    private static boolean checkRule(DeliveryBillMapper mapper, StringBuilder errMsg) {
        StringBuilder itemErrMsg = new StringBuilder();
        String sourceNumber = mapper.getSourceNumber();
        Map<String, String> destRelConvertTypeMap = mapper.getDestRelConvertTypeMap();
        String converttype = destRelConvertTypeMap.get("materiel");
        if (!"0".equals(converttype)) {
            itemErrMsg.append(ResManager.loadKDString((String)"\u7269\u6599\u5b57\u6bb5\u76ee\u524d\u4ec5\u652f\u6301\u201c\u6e90\u5355\u5b57\u6bb5\u201d\u6620\u5c04\u7c7b\u578b\u3002", (String)"DeliveryQueryValidationUtil_5", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        if (itemErrMsg.length() > 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u914d\u7f6e\uff1a%1$s\uff1a%2$s\u3002", (String)"DeliveryQueryValidationUtil_4", (String)"mmc-mds-common", (Object[])new Object[0]), sourceNumber, itemErrMsg);
            errMsg.append(msg);
            return false;
        }
        return true;
    }
}

