/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.deliveryquery.algo;

import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;

public class MonthTransformMapFunctionByAlgo
extends MapFunction {
    private RowMeta rowMeta;
    private int transformFieldIndex;

    public MonthTransformMapFunctionByAlgo(RowMeta rowMeta, String transformField) {
        this.rowMeta = rowMeta;
        this.transformFieldIndex = rowMeta.getFieldIndex(transformField);
    }

    public Object[] map(Row row) {
        Object[] newRow = new Object[this.rowMeta.getFieldCount()];
        for (int i = 0; i < this.rowMeta.getFieldCount(); ++i) {
            if (this.transformFieldIndex == i) {
                Date d = row.getDate(i);
                if (d == null) continue;
                Date date = MonthTransformMapFunctionByAlgo.getTheMonthStart(d);
                newRow[i] = date;
                continue;
            }
            newRow[i] = row.get(i);
        }
        return newRow;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public static Date getTheMonthStart(Date baseDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(5, 1);
        return cal.getTime();
    }
}

