/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.deliveryquery.task;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.deliveryquery.DeliveryQueryManger;

public class DeliveryQueryTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DeliveryQueryTask.class);

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        DeliveryQueryManger deliveryQueryManger;
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u53d1\u8d27\u67e5\u8be2\u4efb\u52a1\u3002", (String)"DeliveryQueryTask_0", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        Date rundate = new Date();
        Object setid = params.get("setid");
        DynamicObject setObj = BusinessDataServiceHelper.loadSingle((Object)setid, (String)"mds_deliveryqueryset");
        String enable = setObj.getString("enable");
        String status = setObj.getString("status");
        if (!"C".equals(status) || !"1".equals(enable)) {
            setObj.set("lastruntime", (Object)rundate);
            setObj.set("result", (Object)"B");
            SaveServiceHelper.update((DynamicObject)setObj);
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u53d1\u8d27\u67e5\u8be2\u65b9\u6848\u975e\u5ba1\u6838\u4e14\u53ef\u7528\u3002", (String)"DeliveryQueryTask_1", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            logger.info("\u53d1\u8d27\u67e5\u8be2\u65b9\u6848\u975e\u5ba1\u6838\u4e14\u53ef\u7528\u3002");
        }
        try {
            deliveryQueryManger = DeliveryQueryManger.createByDynamicObject(setObj);
        }
        catch (KDBizException e) {
            String err = e.getMessage();
            setObj.set("lastruntime", (Object)rundate);
            setObj.set("result", (Object)"B");
            SaveServiceHelper.update((DynamicObject)setObj);
            this.feedbackProgress(100, err, null);
            return;
        }
        this.feedbackProgress(50, ResManager.loadKDString((String)"\u53d6\u6570\u5b8c\u6210\uff0c\u5165\u5e93\u5f00\u59cb\u3002", (String)"DeliveryQueryTask_2", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        try (AlgoContext algoContext = Algo.newContext();){
            DataSet dataSet = deliveryQueryManger.queryDeliverySet();
            LinkedList<Object[]> sqlParams = new LinkedList<Object[]>();
            String sql = "insert into t_mds_deliverydata(fid, fdeliveryquerysetid, fstockorg, fmateriel, fdeliverytype, fdeliverydate, frundate, fqty, funit, fbilltype) values (?,?,?,?,?,?,?,?,?,?)";
            try (TXHandle h = TX.required();){
                try {
                    String deleteSql = "delete from t_mds_deliverydata where fdeliveryquerysetid=?";
                    DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)deleteSql, (Object[])new Object[]{setid});
                    int size = 0;
                    for (Row row : dataSet) {
                        ++size;
                        Long materiel = row.getLong("materiel");
                        Long stockorg = row.getLong("stockorg");
                        Object qty = row.get("qty");
                        Date deliverydate = row.getDate("deliverydate");
                        Object billtype = row.get("billtype");
                        Object deliverytype = row.get("deliverytype");
                        Object deliveryqueryset = row.get("deliveryqueryset");
                        Object baseunit = row.get("unit");
                        Object[] val = new Object[]{ID.genLongId(), deliveryqueryset, stockorg, materiel, deliverytype, deliverydate, rundate, qty, baseunit, billtype};
                        sqlParams.add(val);
                        if (size < 100000) continue;
                        this.dbExecuteBatch(sql, sqlParams);
                        sqlParams.clear();
                        size = 0;
                    }
                    if (sqlParams.size() > 0) {
                        this.dbExecuteBatch(sql, sqlParams);
                    }
                    setObj.set("lastruntime", (Object)rundate);
                    setObj.set("result", (Object)"A");
                    SaveServiceHelper.update((DynamicObject)setObj);
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
        this.feedbackProgress(100, ResManager.loadKDString((String)"\u5165\u5e93\u5b8c\u6210\uff0c\u4efb\u52a1\u7ed3\u675f\u3002", (String)"DeliveryQueryTask_3", (String)"mmc-mds-common", (Object[])new Object[0]), null);
    }

    private void dbExecuteBatch(String updateSeqSql, List<Object[]> updateList) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSeqSql, updateList);
    }
}

