/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dpsarrange;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.mmc.mds.common.dpsarrange.handler.AbstractDPSArrangeCalcHandler;
import kd.mmc.mds.common.dpsarrange.handler.impl.DPSArrangeBaremarginDataHandler;
import kd.mmc.mds.common.dpsarrange.handler.impl.DPSArrangeBaseDataHandler;
import kd.mmc.mds.common.dpsarrange.handler.impl.DPSArrangeDPSPlanDataHandler;
import kd.mmc.mds.common.dpsarrange.handler.impl.DPSArrangeDeliveryDataHandler;
import kd.mmc.mds.common.dpsarrange.handler.impl.DPSArrangeOtherCalcHandler;
import kd.mmc.mds.common.dpsarrange.handler.impl.DPSArrangeSOPPlanDataHandler;
import kd.mmc.mds.common.dpsarrange.handler.impl.DPSArrangeStockDataHandler;
import kd.mmc.mds.common.dpsarrange.handler.impl.DPSArrangeWorkOrderDataHandler;
import kd.mmc.mds.common.dpsarrange.log.KDCloudMdsExecuteLogRecorder;
import kd.mmc.mds.common.dpsarrange.pojo.CalcDatePOJO;
import kd.mmc.mds.common.dpsarrange.pojo.DpsArrangeBO;
import kd.mmc.mds.common.dpsarrange.pojo.PlanDataEntity;
import kd.mmc.mds.common.dpsarrange.util.DpsArrangeUtil;
import kd.mmc.mds.common.util.CalcuColumns;

public class DpsArrangeTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DpsArrangeTask.class);
    private static DBRoute pur = new DBRoute("scm");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext ctx, Map<String, Object> arg) throws KDException {
        Long dpsArrangeSetID = 0L;
        Object dpsArrangeSetIDObj = arg.get("dpsArrangeSetID");
        Object customerRun = arg.get("customerRun");
        if (dpsArrangeSetIDObj instanceof Long) {
            dpsArrangeSetID = (Long)dpsArrangeSetIDObj;
        }
        DynamicObject dpsarrangeset = null;
        if (!"1".equals(customerRun) && dpsArrangeSetID == 0L) {
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            qFilter.and("status", "=", (Object)"C");
            qFilter.and("isfault", "=", (Object)"1");
            dpsarrangeset = BusinessDataServiceHelper.loadSingleFromCache((String)"mds_dpsarrangeset", (QFilter[])new QFilter[]{qFilter});
            dpsArrangeSetID = dpsarrangeset.getLong("id");
        }
        KDCloudMdsExecuteLogRecorder recorder = new KDCloudMdsExecuteLogRecorder(dpsArrangeSetID, System.currentTimeMillis());
        recorder.updateLog("B", null, null);
        StringBuilder err = new StringBuilder();
        if (!MutexHelper.require((String)"mds_dpsarrangeset", (Object)String.valueOf(dpsArrangeSetID), (String)"modify", (boolean)true, (StringBuilder)err)) {
            recorder.updateLog("D", System.currentTimeMillis(), err.toString());
            return;
        }
        try {
            DpsArrangeUtil.deleteTableData("mds_dpstable", dpsArrangeSetID);
            this.executeTask("1".equals(customerRun), dpsArrangeSetID);
            recorder.updateLog("C", System.currentTimeMillis(), null);
        }
        catch (KDException ex) {
            recorder.updateLog("D", System.currentTimeMillis(), ex.getMessage());
            logger.error("\u8ba1\u7b97\u5f02\u5e38\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)((Object)ex)), (Throwable)ex);
        }
        catch (Exception e) {
            recorder.updateLog("D", System.currentTimeMillis(), e.getMessage());
            logger.error("\u8ba1\u7b97\u51fa\u9519\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e), (Throwable)e);
        }
        finally {
            CalcuColumns.releaseLock("mds_dpsarrangeset", "modify", String.valueOf(dpsArrangeSetID));
        }
    }

    private void executeTask(boolean isCustomerRun, Long dpsarrangesetID) {
        if (!isCustomerRun && dpsarrangesetID == null) {
            logger.error("\u627e\u4e0d\u5230\u65e5\u751f\u4ea7\u8ba1\u5212\u5f85\u6392\u4ea7\u8868\u5b9a\u4e49");
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u65e5\u751f\u4ea7\u8ba1\u5212\u5f85\u6392\u4ea7\u8868\u5b9a\u4e49\u3002", (String)"DpsArrangeTask_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        DynamicObject dpsarrangeset = BusinessDataServiceHelper.loadSingleFromCache((Object)dpsarrangesetID, (String)"mds_dpsarrangeset");
        DynamicObject sopvrds = dpsarrangeset.getDynamicObject("sopvrds");
        DynamicObject dpsvrds = dpsarrangeset.getDynamicObject("vrds");
        if (sopvrds == null || dpsvrds == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u751f\u4ea7\u8ba1\u5212\u5f85\u6392\u4ea7\u8868\u5b9a\u4e49\u7248\u672c\u4e3a\u7a7a\u3002", (String)"DpsArrangeTask_1", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        boolean dpsstatuscheckbox = dpsarrangeset.getBoolean("dpsstatuscheckbox");
        boolean sopstatuscheckbox = dpsarrangeset.getBoolean("sopstatuscheckbox");
        Long sopvrdsPk = sopvrds.getLong("id");
        Long dpsvrdsPk = dpsvrds.getLong("id");
        QFilter filter = new QFilter("fcvrnnum", "in", (Object)new Object[]{sopvrds.getPkValue(), dpsvrds.getPkValue()});
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection mdsdataConllection = QueryServiceHelper.query((String)"mds_data", (String)"id,billstatus,fcvrnnum", (QFilter[])filters);
        long sopPlanPk = 0L;
        long dpsplanPk = 0L;
        String sopBillStatus = "A";
        String dpsBillStatus = "A";
        for (DynamicObject dynamicObject : mdsdataConllection) {
            if (sopvrdsPk.equals(dynamicObject.getLong("fcvrnnum"))) {
                sopPlanPk = dynamicObject.getLong("id");
                sopBillStatus = dynamicObject.getString("billstatus");
            }
            if (!dpsvrdsPk.equals(dynamicObject.getLong("fcvrnnum"))) continue;
            dpsplanPk = dynamicObject.getLong("id");
            dpsBillStatus = dynamicObject.getString("billstatus");
        }
        if (sopPlanPk == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DpsArrangeTask_2", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        if (dpsplanPk == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u751f\u4ea7\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DpsArrangeTask_3", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        if (dpsstatuscheckbox && !"C".equals(dpsBillStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u751f\u4ea7\u8ba1\u5212\u5355\u636e\u672a\u786e\u8ba4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DpsArrangeTask_4", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        if (sopstatuscheckbox && !"C".equals(sopBillStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u5212\u5355\u636e\u672a\u786e\u8ba4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DpsArrangeTask_5", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        Date lastupdatetime = new Date();
        CalcDatePOJO calcDate = DpsArrangeUtil.getCalcDate(lastupdatetime);
        Date startDate = calcDate.getCurMonthStart();
        Date endDate = calcDate.getNextMonthEnd();
        Date dpsEndDate = calcDate.getNextMonthEnd();
        int weeknum = dpsarrangeset.getInt("weeknum");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(5, (weeknum + 1) * 7);
        dpsEndDate = dpsEndDate.compareTo(calendar.getTime()) > 0 ? dpsEndDate : calendar.getTime();
        List<Date> calcDateList = DpsArrangeUtil.getDPSPlanCalcDateList(calcDate.getCurWeekStart(), weeknum);
        Map<Long, List<PlanDataEntity>> sopEntity = this.buildPlanData(sopPlanPk, startDate, endDate);
        Map<Long, List<PlanDataEntity>> dpsEntity = this.buildPlanData(dpsplanPk, startDate, dpsEndDate);
        logger.info("DPS arrange\u8fd0\u7b97\u65f6\u95f4\u70b9\u4e3a\uff1a" + calcDate);
        logger.info("DPS arrange\u5468\u8ba1\u5212\u65f6\u95f4\u70b9\uff1a" + calcDateList);
        this.calcByMaterialIDSet(sopEntity.keySet(), dpsarrangesetID, sopEntity, dpsEntity, lastupdatetime, calcDate, calcDateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, List<PlanDataEntity>> buildPlanData(Long mdsdataId, Date startDate, Date endDate) {
        HashMap<Long, List<PlanDataEntity>> result = new HashMap<Long, List<PlanDataEntity>>(16);
        String queryMainSql = "select fmaterialid,fdatenode,ffcqty,fprodorg from T_MDS_FCDATADTLENT where fid in (?) and fdatenode>= ? and fdatenode<= ?";
        DataSet queryMainData = DB.queryDataSet((String)"queryFcData", (DBRoute)pur, (String)queryMainSql, (Object[])new Object[]{mdsdataId, startDate, endDate});
        Iterator iteratorMain = queryMainData.iterator();
        try {
            while (iteratorMain.hasNext()) {
                Row row = (Row)iteratorMain.next();
                Long fmaterialid = row.getLong("fmaterialid");
                Date fdatenode = row.getDate("fdatenode");
                BigDecimal ffcqty = row.getBigDecimal("ffcqty");
                Long fprodorg = row.getLong("fprodorg");
                PlanDataEntity dataEntity = new PlanDataEntity();
                dataEntity.setMaterialid(fmaterialid);
                dataEntity.setDatenode(fdatenode);
                dataEntity.setFcqty(ffcqty);
                dataEntity.setProdorg(fprodorg);
                LinkedList<PlanDataEntity> dataEntities = (LinkedList<PlanDataEntity>)result.get(fmaterialid);
                if (dataEntities == null) {
                    dataEntities = new LinkedList<PlanDataEntity>();
                    result.put(fmaterialid, dataEntities);
                }
                dataEntities.add(dataEntity);
            }
        }
        finally {
            queryMainData.close();
        }
        return result;
    }

    private void calcByMaterialIDSet(Set<Long> materialIDSet, Long dpsarrangesetID, Map<Long, List<PlanDataEntity>> sopEntity, Map<Long, List<PlanDataEntity>> dpsEntity, Date lastupdatetime, CalcDatePOJO calcDate, List<Date> calcDateList) {
        for (Long materialId : materialIDSet) {
            this.calcByMaterialId(materialId, dpsarrangesetID, lastupdatetime, sopEntity, dpsEntity, calcDate, calcDateList);
        }
    }

    private void calcByMaterialId(Long materialId, Long dpsarrangesetID, Date lastupdatetime, Map<Long, List<PlanDataEntity>> sopEntity, Map<Long, List<PlanDataEntity>> dpsEntity, CalcDatePOJO calcDate, List<Date> calcDateList) {
        DpsArrangeBO bo = new DpsArrangeBO();
        bo.setDpsarrangeset(dpsarrangesetID);
        bo.setMitem(materialId);
        bo.setLastupdatetime(lastupdatetime);
        bo.setSopEntity(sopEntity);
        bo.setDpsEntity(dpsEntity);
        bo.setCalcDate(calcDate);
        bo.setCalcDateList(calcDateList);
        AbstractDPSArrangeCalcHandler handler = this.getDPSArrangeCalcHandler();
        handler.handlerNext(bo);
        DpsArrangeUtil.DpsArrangeToDynamicObject(bo);
    }

    protected AbstractDPSArrangeCalcHandler getDPSArrangeCalcHandler() {
        DPSArrangeBaseDataHandler handler = new DPSArrangeBaseDataHandler();
        DPSArrangeDPSPlanDataHandler dpsArrangeDPSPlanDataHandler = new DPSArrangeDPSPlanDataHandler();
        handler.setNextHandler(dpsArrangeDPSPlanDataHandler);
        DPSArrangeSOPPlanDataHandler dpsArrangeSOPPlanDataHandler = new DPSArrangeSOPPlanDataHandler();
        dpsArrangeDPSPlanDataHandler.setNextHandler(dpsArrangeSOPPlanDataHandler);
        DPSArrangeStockDataHandler dpsArrangeStockDataHandler = new DPSArrangeStockDataHandler();
        dpsArrangeSOPPlanDataHandler.setNextHandler(dpsArrangeStockDataHandler);
        DPSArrangeWorkOrderDataHandler dpsArrangeWorkOrderDataHandler = new DPSArrangeWorkOrderDataHandler();
        dpsArrangeStockDataHandler.setNextHandler(dpsArrangeWorkOrderDataHandler);
        DPSArrangeBaremarginDataHandler dpsArrangeBaremarginDataHandler = new DPSArrangeBaremarginDataHandler();
        dpsArrangeWorkOrderDataHandler.setNextHandler(dpsArrangeBaremarginDataHandler);
        DPSArrangeDeliveryDataHandler dpsArrangeDeliveryDataHandler = new DPSArrangeDeliveryDataHandler();
        dpsArrangeBaremarginDataHandler.setNextHandler(dpsArrangeDeliveryDataHandler);
        DPSArrangeOtherCalcHandler dpsArrangeOtherCalcHandler = new DPSArrangeOtherCalcHandler();
        dpsArrangeDeliveryDataHandler.setNextHandler(dpsArrangeOtherCalcHandler);
        return handler;
    }
}

