/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dpsarrange.handler.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mmc.mds.common.dpsarrange.handler.AbstractDPSArrangeCalcHandler;
import kd.mmc.mds.common.dpsarrange.pojo.DpsArrangeBO;
import kd.mmc.mds.common.dpsarrange.util.DpsArrangeUtil;

public class DPSArrangeBaremarginDataHandler
extends AbstractDPSArrangeCalcHandler {
    private static Log logger = LogFactory.getLog(DPSArrangeBaremarginDataHandler.class);

    @Override
    protected void handlerRequest(DpsArrangeBO obj) {
        Long dpsarrangeset = obj.getDpsarrangeset();
        if (dpsarrangeset == null || dpsarrangeset == 0L) {
            obj.setBaremargin(BigDecimal.ZERO);
            logger.warn("DPS\u5f85\u6392\u4ea7\u5b9a\u4e49\u4e3b\u952e\u4e3a\u7a7a\uff0c\u88f8\u673a\u4f59\u91cf\u8fd0\u7b97\u7ed3\u675f\u3002");
            return;
        }
        Long mitem = obj.getMitem();
        if (mitem == null || mitem == 0L) {
            obj.setBaremargin(BigDecimal.ZERO);
            logger.warn("\u9884\u6d4b\u8ba1\u5212\u7269\u6599\u4e3a\u7a7a\uff0c\u88f8\u673a\u4f59\u91cf\u8fd0\u7b97\u7ed3\u675f\u3002");
            return;
        }
        Long pbom = obj.getPbom();
        if (pbom != null && pbom != 0L) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(16);
            if (Objects.equals(mitem, pbom)) {
                filterList.add(new QFilter("material", "=", (Object)mitem));
                BigDecimal avastockBar = DpsArrangeUtil.getStockData(dpsarrangeset, filterList, logger);
                if (avastockBar == null) {
                    avastockBar = BigDecimal.ZERO;
                }
                logger.info("\u9884\u6d4b\u8ba1\u5212\u7269\u6599\u7f16\u7801\u7684\u53ef\u7528\u5e93\u5b58\u6570\u91cf\u4e3a\uff1a" + avastockBar);
                filterList.clear();
                filterList.add(new QFilter("treeentryentity.material.masterid", "=", (Object)mitem));
                BigDecimal processBar = DpsArrangeUtil.getWorkOrderData(dpsarrangeset, filterList, logger);
                if (processBar == null) {
                    processBar = BigDecimal.ZERO;
                }
                logger.info("\u9884\u6d4b\u8ba1\u5212\u7269\u6599\u7f16\u7801\u7684\u5728\u5236\u6570\u91cf\u4e3a\uff1a" + processBar);
                BigDecimal process = obj.getProcess();
                if (process == null) {
                    process = BigDecimal.ZERO;
                }
                logger.info("\u6574\u673a-\u5728\u5236\u6570\u91cf\u4e3a\uff1a" + process);
                BigDecimal baremargin = avastockBar.add(processBar).subtract(process);
                logger.info("\u88f8\u673a\u4f59\u91cf\u4e3a\uff1a" + process);
                obj.setBaremargin(baremargin);
            } else {
                filterList.add(new QFilter("material", "=", (Object)pbom));
                BigDecimal avastockPbom = DpsArrangeUtil.getStockData(dpsarrangeset, filterList, logger);
                if (avastockPbom == null) {
                    avastockPbom = BigDecimal.ZERO;
                }
                logger.info("PBOM\u7684\u53ef\u7528\u5e93\u5b58\u6570\u91cf\u4e3a\uff1a" + avastockPbom);
                filterList.clear();
                filterList.add(new QFilter("treeentryentity.material.masterid", "=", (Object)pbom));
                BigDecimal processPbom = DpsArrangeUtil.getWorkOrderData(dpsarrangeset, filterList, logger);
                if (processPbom == null) {
                    processPbom = BigDecimal.ZERO;
                }
                logger.info("PBOM\u7684\u5728\u5236\u6570\u91cf\u4e3a\uff1a" + processPbom);
                Set<Long> mbomSet = DpsArrangeUtil.getMbomByPbom(pbom);
                BigDecimal baremargin = BigDecimal.ZERO;
                if (mbomSet != null && !mbomSet.isEmpty()) {
                    filterList.clear();
                    filterList.add(new QFilter("treeentryentity.material.masterid", "in", mbomSet));
                    BigDecimal processMbom = DpsArrangeUtil.getWorkOrderData(dpsarrangeset, filterList, logger);
                    if (processMbom == null) {
                        processMbom = BigDecimal.ZERO;
                    }
                    baremargin = avastockPbom.add(processPbom).subtract(processMbom);
                    logger.info("Pbom\u88f8\u673a\u4f59\u91cf\u4e3a\uff1a" + baremargin);
                } else {
                    baremargin = avastockPbom.add(processPbom);
                    logger.info("Pbom\u88f8\u673a\u4f59\u91cf\u4e3a\uff1a" + baremargin);
                }
                obj.setBaremargin(baremargin);
            }
        }
    }
}

