/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dpsarrange.handler.impl;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.dpsarrange.handler.AbstractDPSArrangeCalcHandler;
import kd.mmc.mds.common.dpsarrange.pojo.DpsArrangeBO;
import kd.mmc.mds.common.dpsarrange.util.DpsArrangeUtil;

public class DPSArrangeBaseDataHandler
extends AbstractDPSArrangeCalcHandler {
    private static final String MPDM_MATERIALPLAN = "mpdm_materialplan";
    private static final String MDS_PRODUCTFAMILY = "mds_productfamily";

    @Override
    protected void handlerRequest(DpsArrangeBO ctx) {
        Long dpsarrangesetID = ctx.getDpsarrangeset();
        DynamicObject dpsarrangeset = BusinessDataServiceHelper.loadSingleFromCache((Object)dpsarrangesetID, (String)"mds_dpsarrangeset");
        Long mitemId = ctx.getMitem();
        Long user = this.getUser(mitemId);
        ctx.setUser(user);
        Long baseUnit = this.getBaseUnit(mitemId);
        ctx.setBaseunit(baseUnit);
        Boolean isProductfamily = dpsarrangeset.getBoolean("productfamily");
        ctx.setOpenProductFamily(isProductfamily);
        if (isProductfamily.booleanValue()) {
            QFilter qFilter = new QFilter("materielitem", "=", (Object)mitemId);
            DynamicObject productFamily = BusinessDataServiceHelper.loadSingleFromCache((String)MDS_PRODUCTFAMILY, (QFilter[])new QFilter[]{qFilter});
            if (productFamily != null) {
                String bomtype = productFamily.getString("bomtype");
                if ("PBOM".equals(bomtype)) {
                    ctx.setPbom(mitemId);
                    Set<Long> MbomSet = DpsArrangeUtil.getMbomByPbom(mitemId);
                    ctx.setMbomSet(MbomSet);
                } else if ("MBOM".equals(bomtype)) {
                    Long materielpbom = productFamily.getLong("materielpbom.id");
                    ctx.setPbom(materielpbom);
                    HashSet<Long> mbomSet = new HashSet<Long>(16);
                    mbomSet.add(materielpbom);
                    ctx.setMbomSet(mbomSet);
                }
            }
        }
    }

    private Long getUser(Long mitemId) {
        Long operator = 0L;
        QFilter qFilter = new QFilter("masterid", "=", (Object)mitemId);
        DynamicObject materialplan = BusinessDataServiceHelper.loadSingleFromCache((String)MPDM_MATERIALPLAN, (QFilter[])new QFilter[]{qFilter});
        if (materialplan != null) {
            operator = materialplan.getLong("operator.id");
        }
        return operator;
    }

    private Long getBaseUnit(Long mitemId) {
        Long baseunit = 0L;
        QFilter qFilter = new QFilter("masterid", "=", (Object)mitemId);
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)mitemId, (String)"bd_material");
        if (material != null) {
            baseunit = material.getLong("baseunit.id");
        }
        return baseunit;
    }
}

