/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dpsarrange.handler.impl;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.dpsarrange.handler.AbstractDPSArrangeCalcHandler;
import kd.mmc.mds.common.dpsarrange.pojo.CalcDatePOJO;
import kd.mmc.mds.common.dpsarrange.pojo.DpsArrangeBO;
import kd.mmc.mds.common.dpsarrange.pojo.DpsArrangeEntityPO;
import kd.mmc.mds.common.dpsarrange.pojo.PlanDataEntity;

public class DPSArrangeDPSPlanDataHandler
extends AbstractDPSArrangeCalcHandler {
    @Override
    protected void handlerRequest(DpsArrangeBO ctx) {
        Long dpsarrangesetID = ctx.getDpsarrangeset();
        DynamicObject dpsarrangeset = BusinessDataServiceHelper.loadSingleFromCache((Object)dpsarrangesetID, (String)"mds_dpsarrangeset");
        this.clacDpsMaterial(ctx, dpsarrangeset);
        this.clacDpsMaterialOrg(ctx);
        this.clacDpsMaterialPreQty(ctx);
        this.clacDpsWeekPlan(ctx);
    }

    private void clacDpsWeekPlan(DpsArrangeBO ctx) {
        LinkedList<DpsArrangeEntityPO> entity = new LinkedList<DpsArrangeEntityPO>();
        ctx.setEntity(entity);
        List<Date> dates = ctx.getCalcDateList();
        for (Date date : dates) {
            DpsArrangeEntityPO arrangeEntity = new DpsArrangeEntityPO();
            arrangeEntity.setWeekdate(date);
            entity.add(arrangeEntity);
        }
        Map<Long, List<PlanDataEntity>> dpsMap = ctx.getDpsEntity();
        Set<Long> dpsPlanMaterialSet = ctx.getDpsPlanMaterialSet();
        HashSet<Long> materialSet = new HashSet<Long>(16);
        Long pbom = ctx.getPbom();
        Set<Long> mbom = ctx.getMbomSet();
        Long mitem = ctx.getMitem();
        if (mitem != null) {
            materialSet.add(mitem);
        }
        if (pbom != null) {
            materialSet.add(pbom);
        }
        if (mbom != null) {
            materialSet.addAll(mbom);
        }
        if (materialSet.size() > 0) {
            LinkedList<PlanDataEntity> materialEntities = new LinkedList<PlanDataEntity>();
            for (Long material : dpsPlanMaterialSet) {
                List<PlanDataEntity> planDataEntities = dpsMap.get(material);
                if (planDataEntities == null) continue;
                materialEntities.addAll(planDataEntities);
            }
            for (DpsArrangeEntityPO dpsArrangeEntity : entity) {
                Date startDate = dpsArrangeEntity.getWeekdate();
                Calendar c = Calendar.getInstance();
                c.setTime(startDate);
                c.add(5, 7);
                Date endDate = c.getTime();
                BigDecimal decimal = materialEntities.stream().filter(o -> startDate.compareTo(o.getDatenode()) <= 0 && endDate.compareTo(o.getDatenode()) > 0).map(PlanDataEntity::getFcqty).reduce(BigDecimal.ZERO, BigDecimal::add);
                dpsArrangeEntity.setWeekplan(decimal);
            }
        }
    }

    private void clacDpsMaterialPreQty(DpsArrangeBO ctx) {
        Map<Long, List<PlanDataEntity>> dpsMap = ctx.getDpsEntity();
        Set<Long> dpsPlanMaterialSet = ctx.getDpsPlanMaterialSet();
        CalcDatePOJO calcDate = ctx.getCalcDate();
        HashSet<Long> materialSet = new HashSet<Long>(16);
        Long pbom = ctx.getPbom();
        Set<Long> mbom = ctx.getMbomSet();
        Long mitem = ctx.getMitem();
        if (mitem != null) {
            materialSet.add(mitem);
        }
        if (pbom != null) {
            materialSet.add(pbom);
        }
        if (mbom != null) {
            materialSet.addAll(mbom);
        }
        if (materialSet.size() == 0) {
            ctx.setPredisplace(new BigDecimal("0"));
            ctx.setMtwopredisplace(new BigDecimal("0"));
        } else {
            LinkedList<PlanDataEntity> materialEntities = new LinkedList<PlanDataEntity>();
            for (Long material : dpsPlanMaterialSet) {
                List<PlanDataEntity> planDataEntities = dpsMap.get(material);
                if (planDataEntities == null) continue;
                materialEntities.addAll(planDataEntities);
            }
            Date curMonthStart = calcDate.getCurMonthStart();
            Date curMonthEnd = calcDate.getCurMonthEnd();
            Date nextMonthStart = calcDate.getNextMonthStart();
            Date nextMonthEnd = calcDate.getNextMonthEnd();
            BigDecimal decimal = materialEntities.stream().filter(o -> curMonthStart.compareTo(o.getDatenode()) <= 0 && curMonthEnd.compareTo(o.getDatenode()) >= 0).map(PlanDataEntity::getFcqty).reduce(BigDecimal.ZERO, BigDecimal::add);
            ctx.setPredisplace(decimal);
            BigDecimal decimal2 = materialEntities.stream().filter(o -> nextMonthStart.compareTo(o.getDatenode()) <= 0 && nextMonthEnd.compareTo(o.getDatenode()) >= 0).map(PlanDataEntity::getFcqty).reduce(BigDecimal.ZERO, BigDecimal::add);
            ctx.setMtwopredisplace(decimal2);
        }
    }

    private void clacDpsMaterialOrg(DpsArrangeBO ctx) {
        Map<Long, List<PlanDataEntity>> dpsMap = ctx.getDpsEntity();
        Set<Long> dpsPlanMaterialSet = ctx.getDpsPlanMaterialSet();
        HashSet<Long> dpsPlanMaterialOrgSet = new HashSet<Long>(16);
        for (Long material : dpsPlanMaterialSet) {
            List<PlanDataEntity> planDataEntities = dpsMap.get(material);
            if (planDataEntities == null) continue;
            Set materialOrgSet = planDataEntities.stream().map(PlanDataEntity::getProdorg).collect(Collectors.toSet());
            dpsPlanMaterialOrgSet.addAll(materialOrgSet);
        }
        ctx.setDpsPlanMaterialOrgSet(dpsPlanMaterialOrgSet);
    }

    private void clacDpsMaterial(DpsArrangeBO ctx, DynamicObject dpsarrangeset) {
        Map<Long, List<PlanDataEntity>> dpsMap = ctx.getDpsEntity();
        HashSet<Long> materialSet = new HashSet<Long>();
        Long pbom = ctx.getPbom();
        Set<Long> mbom = ctx.getMbomSet();
        Long mitem = ctx.getMitem();
        if (mitem != null) {
            materialSet.add(mitem);
        }
        if (pbom != null) {
            materialSet.add(pbom);
        }
        if (mbom != null) {
            materialSet.addAll(mbom);
        }
        boolean isProductfamily = dpsarrangeset.getBoolean("productfamily");
        HashSet<Long> dpsPlanMaterialSet = new HashSet<Long>(16);
        if (!isProductfamily || pbom == null) {
            dpsPlanMaterialSet.add(ctx.getMitem());
        } else {
            for (Long materialId : materialSet) {
                if (!dpsMap.containsKey(materialId)) continue;
                dpsPlanMaterialSet.add(materialId);
            }
            if (dpsPlanMaterialSet.size() == 0) {
                dpsPlanMaterialSet.add(pbom);
            }
        }
        ctx.setDpsPlanMaterialSet(dpsPlanMaterialSet);
    }
}

