/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dpsarrange.handler.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.dpsarrange.handler.AbstractDPSArrangeCalcHandler;
import kd.mmc.mds.common.dpsarrange.pojo.CalcDatePOJO;
import kd.mmc.mds.common.dpsarrange.pojo.DpsArrangeBO;
import kd.mmc.mds.common.dpsarrange.pojo.PlanDataEntity;
import kd.mmc.mds.common.util.MDSUtils;

public class DPSArrangeDeliveryDataHandler
extends AbstractDPSArrangeCalcHandler {
    private static Log logger = LogFactory.getLog(DPSArrangeDeliveryDataHandler.class);

    @Override
    protected void handlerRequest(DpsArrangeBO obj) {
        Long dpsarrangesetId = obj.getDpsarrangeset();
        if (dpsarrangesetId == null || dpsarrangesetId == 0L) {
            logger.warn("DPS\u5f85\u6392\u4ea7\u5b9a\u4e49\u4e3b\u952e\u4e3a\u7a7a\uff0c\u672c\u5468\u53d1\u8d27\u8fd0\u7b97\u7ed3\u675f\u3002");
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)dpsarrangesetId, (String)"mds_dpsarrangeset");
        ArrayList<QFilter> saloutFilterList = new ArrayList<QFilter>(16);
        ArrayList<QFilter> otheroutFilterList = new ArrayList<QFilter>(16);
        ArrayList<QFilter> materialreqoutFilterList = new ArrayList<QFilter>(16);
        ArrayList<QFilter> transoutFilterList = new ArrayList<QFilter>(16);
        ArrayList<QFilter> transdirFilterList = new ArrayList<QFilter>(16);
        String deliveryradiogroup = dynamicObject.getString("deliveryradiogroup");
        DynamicObjectCollection deliveryentity = dynamicObject.getDynamicObjectCollection("deliveryentity");
        if (deliveryentity != null && !deliveryentity.isEmpty()) {
            Map<String, List<DynamicObject>> map = deliveryentity.stream().collect(Collectors.groupingBy(p -> p.getString("billtype")));
            for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
                List<DynamicObject> value;
                String key = entry.getKey();
                List<QFilter> filterList = this.getBillQFilter(deliveryradiogroup, key, value = entry.getValue());
                if (filterList == null || filterList.isEmpty()) continue;
                if ("0".equals(key)) {
                    saloutFilterList.addAll(filterList);
                }
                if ("1".equals(key)) {
                    otheroutFilterList.addAll(filterList);
                }
                if ("2".equals(key)) {
                    materialreqoutFilterList.addAll(filterList);
                }
                if ("3".equals(key)) {
                    transoutFilterList.addAll(filterList);
                }
                if (!"4".equals(key)) continue;
                transdirFilterList.addAll(filterList);
            }
        }
        ArrayList<PlanDataEntity> dataList = new ArrayList<PlanDataEntity>(16);
        String selectFields = "id, auditdate, billentry.material.masterid, billentry.qty";
        List<PlanDataEntity> saloutEntity = this.getDeliveryQty(obj, deliveryradiogroup, "saloutbill", "im_saloutbill", selectFields, saloutFilterList);
        logger.info("\u9500\u552e\u51fa\u5e93\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a" + saloutFilterList);
        if (saloutEntity != null && !saloutEntity.isEmpty()) {
            dataList.addAll(saloutEntity);
        }
        List<PlanDataEntity> otheroutEntity = this.getDeliveryQty(obj, deliveryradiogroup, "otheroutbill", "im_otheroutbill", selectFields, otheroutFilterList);
        logger.info("\u5176\u4ed6\u51fa\u5e93\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a" + otheroutFilterList);
        if (otheroutEntity != null && !otheroutEntity.isEmpty()) {
            dataList.addAll(otheroutEntity);
        }
        List<PlanDataEntity> materialreqoutEntity = this.getDeliveryQty(obj, deliveryradiogroup, "materialreqoutbill", "im_materialreqoutbill", selectFields, materialreqoutFilterList);
        logger.info("\u9886\u6599\u51fa\u5e93\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a" + materialreqoutFilterList);
        if (materialreqoutEntity != null && !materialreqoutEntity.isEmpty()) {
            dataList.addAll(materialreqoutEntity);
        }
        List<PlanDataEntity> transoutEntity = this.getDeliveryQty(obj, deliveryradiogroup, "transoutbill", "im_transoutbill", selectFields, transoutFilterList);
        logger.info("\u5206\u6b65\u8c03\u51fa\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a" + transoutFilterList);
        if (transoutEntity != null && !transoutEntity.isEmpty()) {
            dataList.addAll(transoutEntity);
        }
        List<PlanDataEntity> transdirEntity = this.getDeliveryQty(obj, deliveryradiogroup, "transdirbill", "im_transdirbill", selectFields, transdirFilterList);
        logger.info("\u76f4\u63a5\u8c03\u62e8\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a" + transdirFilterList);
        if (transdirEntity != null && !transdirEntity.isEmpty()) {
            dataList.addAll(transdirEntity);
        }
        CalcDatePOJO calcDate = obj.getCalcDate();
        Date curWeekStart = calcDate.getCurWeekStart();
        Date curWeekEnd = calcDate.getCurWeekEnd();
        Date curMonthStart = calcDate.getCurMonthStart();
        BigDecimal weekdelivery = dataList.stream().filter(o -> curWeekStart.compareTo(o.getDatenode()) <= 0 && curWeekEnd.compareTo(o.getDatenode()) >= 0).map(PlanDataEntity::getFcqty).reduce(BigDecimal.ZERO, BigDecimal::add);
        obj.setWeekdelivery(weekdelivery);
        BigDecimal weekdelivered = dataList.stream().filter(o -> curMonthStart.compareTo(o.getDatenode()) <= 0 && curWeekStart.compareTo(o.getDatenode()) > 0).map(PlanDataEntity::getFcqty).reduce(BigDecimal.ZERO, BigDecimal::add);
        obj.setWeekdelivered(weekdelivered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PlanDataEntity> getDeliveryQty(DpsArrangeBO obj, String deliveryGroup, String algoKey, String entityName, String selectFields, List<QFilter> filterList) {
        if (filterList == null) {
            return null;
        }
        if (filterList.isEmpty() && "2".equals(deliveryGroup)) {
            return null;
        }
        ArrayList<PlanDataEntity> dataEntities = new ArrayList<PlanDataEntity>(16);
        filterList.add(new QFilter("billstatus", "=", (Object)"C"));
        CalcDatePOJO calcDate = obj.getCalcDate();
        Date curMonthStart = calcDate.getCurMonthStart();
        Date curWeekEnd = calcDate.getCurWeekEnd();
        filterList.add(new QFilter("auditdate", ">=", (Object)curMonthStart));
        filterList.add(new QFilter("auditdate", "<=", (Object)curWeekEnd));
        Long mitem = obj.getMitem();
        Long pbom = obj.getPbom();
        Set<Long> mbomSet = obj.getMbomSet();
        if (Objects.equals(mitem, pbom)) {
            if (mbomSet == null || mbomSet.isEmpty()) {
                logger.warn("\u5f53\u8be5\u7269\u6599\u7f16\u7801\u4e3aPBOM\uff0c\u4ea7\u54c1\u65cf\u5bf9\u5e94MBOM\u7269\u6599\u4e3a\u7a7a\uff0c\u53d1\u8d27\u6570\u91cf\u8fd0\u7b97\u7ed3\u675f\u3002");
                return null;
            }
            filterList.add(new QFilter("billentry.material.masterid", "in", mbomSet));
            logger.info("\u9884\u6d4b\u8ba1\u5212Mbom\u7269\u6599\uff1a" + mbomSet);
        } else {
            filterList.add(new QFilter("billentry.material.masterid", "=", (Object)mitem));
            logger.info("\u9884\u6d4b\u8ba1\u5212\u7269\u6599\uff1a" + mitem);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filterList.toArray(new QFilter[filterList.size()]), (String)"id");){
            for (Row row : dataSet) {
                Long materialid = row.getLong("billentry.material.masterid");
                Date datenode = row.getDate("auditdate");
                BigDecimal fcqty = row.getBigDecimal("billentry.qty");
                PlanDataEntity dataEntity = new PlanDataEntity();
                dataEntity.setMaterialid(materialid);
                dataEntity.setDatenode(datenode);
                dataEntity.setFcqty(fcqty);
                dataEntities.add(dataEntity);
            }
        }
        return dataEntities;
    }

    private List<QFilter> getBillQFilter(String deliveryradiogroup, String billtype, List<DynamicObject> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(16);
        QFilter deliveryQFilter = null;
        for (DynamicObject dynamicObject : list) {
            QFilter filter = new QFilter("1", "=", (Object)1);
            DynamicObject biztype = dynamicObject.getDynamicObject("biztype");
            DynamicObject invscheme = dynamicObject.getDynamicObject("invscheme");
            String transtype = dynamicObject.getString("transtype");
            if ("2".equals(deliveryradiogroup)) {
                if (biztype != null) {
                    filter.and(new QFilter("biztype.id", "=", biztype.getPkValue()));
                }
                if (invscheme != null) {
                    filter.and(new QFilter("invscheme.id", "=", invscheme.getPkValue()));
                }
                if (MDSUtils.isNotEmpty(transtype) && ("3".equals(billtype) || "4".equals(billtype))) {
                    filter.and(new QFilter("transtype", "=", (Object)transtype));
                }
            } else if ("3".equals(deliveryradiogroup)) {
                filter = new QFilter("1", "!=", (Object)1);
                if (biztype != null) {
                    filter.or(new QFilter("biztype.id", "!=", biztype.getPkValue()));
                }
                if (invscheme != null) {
                    filter.or(new QFilter("invscheme.id", "!=", invscheme.getPkValue()));
                }
                if (MDSUtils.isNotEmpty(transtype) && ("3".equals(billtype) || "4".equals(billtype))) {
                    filter.or(new QFilter("transtype", "!=", (Object)transtype));
                }
            }
            if (deliveryQFilter == null) {
                deliveryQFilter = filter;
                continue;
            }
            deliveryQFilter.or(filter);
        }
        if (deliveryQFilter != null) {
            filterList.add(deliveryQFilter);
        }
        return filterList;
    }
}

