/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dpsarrange.handler.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mmc.mds.common.dpsarrange.handler.AbstractDPSArrangeCalcHandler;
import kd.mmc.mds.common.dpsarrange.pojo.DpsArrangeBO;
import kd.mmc.mds.common.dpsarrange.util.DpsArrangeUtil;

public class DPSArrangeStockDataHandler
extends AbstractDPSArrangeCalcHandler {
    private static Log logger = LogFactory.getLog(DPSArrangeStockDataHandler.class);

    @Override
    protected void handlerRequest(DpsArrangeBO obj) {
        Long dpsarrangeset = obj.getDpsarrangeset();
        if (dpsarrangeset == null || dpsarrangeset == 0L) {
            obj.setAvastock(BigDecimal.ZERO);
            logger.warn("DPS\u5f85\u6392\u4ea7\u5b9a\u4e49\u4e3b\u952e\u4e3a\u7a7a\uff0c\u53ef\u7528\u5e93\u5b58\u6570\u91cf\u8fd0\u7b97\u7ed3\u675f\u3002");
            return;
        }
        Long mitem = obj.getMitem();
        Long pbom = obj.getPbom();
        Set<Long> mbomSet = obj.getMbomSet();
        if (mitem == null || mitem == 0L) {
            obj.setAvastock(BigDecimal.ZERO);
            logger.warn("\u9884\u6d4b\u8ba1\u5212\u7269\u6599\u7f16\u7801\u4e3a\u7a7a\uff0c\u53ef\u7528\u5e93\u5b58\u6570\u91cf\u8fd0\u7b97\u7ed3\u675f\u3002");
            return;
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(16);
        if (Objects.equals(mitem, pbom)) {
            if (mbomSet == null || mbomSet.isEmpty()) {
                obj.setAvastock(BigDecimal.ZERO);
                logger.warn("\u5f53\u8be5\u7269\u6599\u7f16\u7801\u4e3aPBOM\uff0c\u4ea7\u54c1\u65cf\u5bf9\u5e94MBOM\u7269\u6599\u4e3a\u7a7a\uff0c\u53ef\u7528\u5e93\u5b58\u6570\u91cf\u8fd0\u7b97\u7ed3\u675f\u3002");
                return;
            }
            filterList.add(new QFilter("material", "in", mbomSet));
            logger.info("\u9884\u6d4b\u8ba1\u5212Mbom\u7269\u6599\uff1a" + mbomSet);
        } else {
            filterList.add(new QFilter("material", "=", (Object)mitem));
            logger.info("\u9884\u6d4b\u8ba1\u5212\u7269\u6599\uff1a" + mitem);
        }
        BigDecimal avastock = DpsArrangeUtil.getStockData(dpsarrangeset, filterList, logger);
        logger.info("\u53ef\u7528\u5e93\u5b58\u6570\u91cf\u4e3a\uff1a" + avastock);
        obj.setAvastock(avastock);
    }
}

