/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dpsarrange.log;

import java.util.Date;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.util.MDSUtils;

public class KDCloudMdsExecuteLogRecorder {
    private static final Log logger = LogFactory.getLog(KDCloudMdsExecuteLogRecorder.class);
    private static final ORM orm = ORM.create();
    private static final String MDS_DPSRUNLOG = "mds_dpsrunlog";
    private Long dpsarrangesetid;
    private DynamicObject dpsarrangeset;
    private Long starttime;
    private DynamicObject logObj;

    public KDCloudMdsExecuteLogRecorder(Long _dpsarrangesetid, Long _starttime) {
        this.dpsarrangeset = BusinessDataServiceHelper.loadSingle((Object)_dpsarrangesetid, (String)"mds_dpsarrangeset");
        this.dpsarrangesetid = _dpsarrangesetid;
        this.starttime = _starttime;
        this.logObj = this.createLog("");
    }

    public final DynamicObject createLog(String errormessage) {
        if (this.dpsarrangesetid == null) {
            logger.error("DPS\u5f85\u6392\u4ea7\u5b9a\u4e49\u4e3a\u7a7a\uff0c\u521b\u5efa\u65e5\u5fd7\u5931\u8d25\u3002");
            return null;
        }
        DynamicObject dynamicObject = orm.newDynamicObject(MDS_DPSRUNLOG);
        dynamicObject.set("dpsarrangeset", (Object)this.dpsarrangesetid);
        dynamicObject.set("calstatus", (Object)"A");
        dynamicObject.set("starttime", (Object)this.starttime);
        dynamicObject.set("enable", (Object)1);
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("errormessage", (Object)errormessage);
        SaveServiceHelper.saveOperate((String)MDS_DPSRUNLOG, (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
        this.dpsarrangeset.set("result", (Object)ResManager.loadKDString((String)"\u5f85\u8fd0\u7b97", (String)"KDCloudMdsExecuteLogRecorder_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        this.dpsarrangeset.set("detailmsg", (Object)errormessage);
        this.dpsarrangeset.set("starttime", (Object)new Date(this.starttime));
        SaveServiceHelper.update((DynamicObject)this.dpsarrangeset);
        return dynamicObject;
    }

    public void updateLog(String calstatus, Long endtime, String errormessage) {
        if (this.logObj == null) {
            logger.error("\u65e5\u5fd7\u4e3a\u7a7a\uff0c\u66f4\u65b0\u65e5\u5fd7\u5931\u8d25\u3002");
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)this.logObj.getPkValue(), (String)MDS_DPSRUNLOG);
        dynamicObject.set("calstatus", (Object)calstatus);
        if (endtime != null) {
            float sumtime = (float)(endtime - this.starttime) / 1000.0f;
            dynamicObject.set("endtime", (Object)endtime);
            dynamicObject.set("sumtime", (Object)Float.valueOf(sumtime));
            this.dpsarrangeset.set("endtime", (Object)new Date(endtime));
        }
        if (MDSUtils.isNotEmpty(errormessage)) {
            dynamicObject.set("errormessage", (Object)errormessage);
            this.dpsarrangeset.set("detailmsg", (Object)errormessage);
        }
        SaveServiceHelper.update((DynamicObject)dynamicObject);
        if ("A".equals(calstatus)) {
            this.dpsarrangeset.set("result", (Object)ResManager.loadKDString((String)"\u5f85\u8fd0\u7b97", (String)"KDCloudMdsExecuteLogRecorder_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        } else if ("B".equals(calstatus)) {
            this.dpsarrangeset.set("result", (Object)ResManager.loadKDString((String)"\u8fd0\u7b97\u4e2d", (String)"KDCloudMdsExecuteLogRecorder_1", (String)"mmc-mds-common", (Object[])new Object[0]));
        } else if ("C".equals(calstatus)) {
            this.dpsarrangeset.set("result", (Object)ResManager.loadKDString((String)"\u8fd0\u7b97\u6210\u529f", (String)"KDCloudMdsExecuteLogRecorder_2", (String)"mmc-mds-common", (Object[])new Object[0]));
        } else if ("D".equals(calstatus)) {
            this.dpsarrangeset.set("result", (Object)ResManager.loadKDString((String)"\u8fd0\u7b97\u9519\u8bef", (String)"KDCloudMdsExecuteLogRecorder_3", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        SaveServiceHelper.update((DynamicObject)this.dpsarrangeset);
    }
}

