/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dpsarrange.util;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.dpsarrange.pojo.CalcDatePOJO;
import kd.mmc.mds.common.dpsarrange.pojo.DpsArrangeBO;
import kd.mmc.mds.common.dpsarrange.pojo.DpsArrangeEntityPO;
import kd.mmc.mds.common.util.DateUtil;
import kd.mmc.mds.common.util.MDSUtils;

public class DpsArrangeUtil {
    private static final String MDS_DPSTABLE = "mds_dpstable";
    private static final String MDS_DPSARRANGESET = "mds_dpsarrangeset";
    private static final String POM_MFTORDER = "pom_mftorder";
    private static final String MDS_PRODUCTFAMILY = "mds_productfamily";

    public static void DpsArrangeToDynamicObject(DpsArrangeBO dpsArrangeBo) {
        List<DpsArrangeEntityPO> list;
        DynamicObjectCollection dynamicObjectCollection;
        Set<Long> dpsPlanMaterialOrgSet;
        DynamicObjectCollection collection2;
        Set<Long> dpsPlanMaterialSet;
        DynamicObjectCollection collection3;
        if (dpsArrangeBo == null) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)MDS_DPSTABLE);
        dynamicObject.set("dpsarrangeset", (Object)dpsArrangeBo.getDpsarrangeset());
        dynamicObject.set("lastupdatetime", (Object)dpsArrangeBo.getLastupdatetime());
        dynamicObject.set("user", (Object)dpsArrangeBo.getUser());
        dynamicObject.set("mitem", (Object)dpsArrangeBo.getMitem());
        dynamicObject.set("pbom", (Object)dpsArrangeBo.getPbom());
        dynamicObject.set("openproductfamily", (Object)dpsArrangeBo.getOpenProductFamily());
        dynamicObject.set("baseunit", (Object)dpsArrangeBo.getBaseunit());
        dynamicObject.set("weekdelivery", (Object)dpsArrangeBo.getWeekdelivery());
        dynamicObject.set("avastock", (Object)dpsArrangeBo.getAvastock());
        dynamicObject.set("process", (Object)dpsArrangeBo.getProcess());
        dynamicObject.set("baremargin", (Object)dpsArrangeBo.getBaremargin());
        dynamicObject.set("weekdelivered", (Object)dpsArrangeBo.getWeekdelivered());
        dynamicObject.set("demandsend", (Object)dpsArrangeBo.getDemandsend());
        dynamicObject.set("displacement", (Object)dpsArrangeBo.getDisplacement());
        dynamicObject.set("waitdisplace", (Object)dpsArrangeBo.getWaitdisplace());
        dynamicObject.set("predisplace", (Object)dpsArrangeBo.getPredisplace());
        dynamicObject.set("monegap", (Object)dpsArrangeBo.getMonegap());
        dynamicObject.set("mtwodemand", (Object)dpsArrangeBo.getMtwodemand());
        dynamicObject.set("mtwopredisplace", (Object)dpsArrangeBo.getMtwopredisplace());
        dynamicObject.set("mtwogap", (Object)dpsArrangeBo.getMtwogap());
        Set<Long> mbomSet = dpsArrangeBo.getMbomSet();
        if (mbomSet != null && !mbomSet.isEmpty() && (collection3 = dynamicObject.getDynamicObjectCollection("mbom")) != null) {
            for (Long l : mbomSet) {
                DynamicObject dynamicObject2 = collection3.addNew();
                dynamicObject2.set("fbasedataid", (Object)l);
            }
        }
        if ((dpsPlanMaterialSet = dpsArrangeBo.getDpsPlanMaterialSet()) != null && !dpsPlanMaterialSet.isEmpty() && (collection2 = dynamicObject.getDynamicObjectCollection("dpsplanmaterial")) != null) {
            for (Long l : dpsPlanMaterialSet) {
                DynamicObject dynamic = collection2.addNew();
                dynamic.set("fbasedataid", (Object)l);
            }
        }
        if ((dpsPlanMaterialOrgSet = dpsArrangeBo.getDpsPlanMaterialOrgSet()) != null && !dpsPlanMaterialOrgSet.isEmpty() && (dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("dpsplanmaterialorg")) != null) {
            for (Long id : dpsPlanMaterialOrgSet) {
                DynamicObject dynamic = dynamicObjectCollection.addNew();
                dynamic.set("fbasedataid", (Object)id);
            }
        }
        if ((list = dpsArrangeBo.getEntity()) != null && !list.isEmpty()) {
            DynamicObjectCollection dynamicObjectCollection2 = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DpsArrangeEntityPO dpsArrangeEntity : list) {
                DynamicObject entity = dynamicObjectCollection2.addNew();
                entity.setParent((Object)dynamicObject);
                entity.set("weekdate", (Object)dpsArrangeEntity.getWeekdate());
                entity.set("weekplan", (Object)dpsArrangeEntity.getWeekplan());
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public static void deleteTableData(String entityName, Long id) {
        if (MDSUtils.isNotEmpty(entityName)) {
            QFilter qFilter = new QFilter("id", "is not null", null);
            if (id != null && id != 0L) {
                qFilter.and(new QFilter("dpsarrangeset", "=", (Object)id));
            }
            DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{qFilter});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal getStockData(Long dpsarrangeset, List<QFilter> filterList, Log logger) {
        String stockradiogroup;
        DynamicObjectCollection stockstatusentity;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)dpsarrangeset, (String)MDS_DPSARRANGESET);
        DynamicObjectCollection stocktypeentity = dynamicObject.getDynamicObjectCollection("stocktypeentity");
        if (!DpsArrangeUtil.dynamicObjectCollectionIsEmpty(stocktypeentity)) {
            Set stocktypeSet = stocktypeentity.stream().filter(f -> f.getBoolean("stocktypeflag")).map(m -> m.getLong("stocktype.id")).collect(Collectors.toSet());
            QFilter stocktypeQFilter = new QFilter("invtype", "in", stocktypeSet);
            filterList.add(stocktypeQFilter);
        }
        if (!DpsArrangeUtil.dynamicObjectCollectionIsEmpty(stockstatusentity = dynamicObject.getDynamicObjectCollection("stockstatusentity"))) {
            Set stockstatusSet = stockstatusentity.stream().filter(f -> f.getBoolean("stockstatusflag")).map(m -> m.getLong("stockstatus.id")).collect(Collectors.toSet());
            QFilter stockstatusQFilter = new QFilter("invstatus", "in", stockstatusSet);
            filterList.add(stockstatusQFilter);
        }
        if ("5".equals(stockradiogroup = dynamicObject.getString("stockradiogroup")) || "6".equals(stockradiogroup)) {
            QFilter stockQFilter = null;
            DynamicObjectCollection stockentity = dynamicObject.getDynamicObjectCollection("stockentity");
            if (!DpsArrangeUtil.dynamicObjectCollectionIsEmpty(stockentity)) {
                for (DynamicObject dynamicObj : stockentity) {
                    QFilter filter = new QFilter("1", "=", (Object)1);
                    DynamicObject stockorg = dynamicObj.getDynamicObject("stockorg");
                    DynamicObject stocknumber = dynamicObj.getDynamicObject("stocknumber");
                    DynamicObject stockindex = dynamicObj.getDynamicObject("stockindex");
                    if ("5".equals(stockradiogroup)) {
                        if (stockorg != null) {
                            filter.and(new QFilter("org.id", "=", stockorg.getPkValue()));
                        }
                        if (stocknumber != null) {
                            filter.and(new QFilter("warehouse.id", "=", stocknumber.getPkValue()));
                        }
                        if (stockindex != null) {
                            filter.and(new QFilter("location.id", "=", stockindex.getPkValue()));
                        }
                    } else if ("6".equals(stockradiogroup)) {
                        filter = new QFilter("1", "!=", (Object)1);
                        if (stockorg != null) {
                            filter.or(new QFilter("org.id", "!=", stockorg.getPkValue()));
                        }
                        if (stocknumber != null) {
                            filter.or(new QFilter("warehouse.id", "!=", stocknumber.getPkValue()));
                        }
                        if (stockindex != null) {
                            filter.or(new QFilter("location.id", "!=", stockindex.getPkValue()));
                        }
                    }
                    if (stockQFilter == null) {
                        stockQFilter = filter;
                        continue;
                    }
                    stockQFilter.or(filter);
                }
            }
            if (stockQFilter != null) {
                filterList.add(stockQFilter);
            }
        }
        BigDecimal avastock = BigDecimal.ZERO;
        DataSet querySqlData = QueryServiceHelper.queryDataSet((String)"queryRealbalance", (String)"im_inv_realbalance", (String)"id,material,baseqty", (QFilter[])filterList.toArray(new QFilter[filterList.size()]), (String)"id");
        try {
            for (Row row : querySqlData) {
                BigDecimal baseqty = row.getBigDecimal("baseqty");
                if (baseqty == null) continue;
                avastock = avastock.add(baseqty);
            }
        }
        finally {
            querySqlData.close();
            logger.info("\u4f59\u989d\u6a21\u578b\u5e93\u5b58\u6570\u636e\u67e5\u8be2\u7ed3\u675f\uff0c\u53ef\u7528\u5e93\u5b58\u6570\u91cf\u4e3a\uff1a" + avastock);
        }
        return avastock;
    }

    public static boolean dynamicObjectCollectionIsEmpty(DynamicObjectCollection dynamicObjectCollection) {
        return dynamicObjectCollection == null || dynamicObjectCollection.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal getWorkOrderData(Long dpsarrangeset, List<QFilter> filterList, Log logger) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)dpsarrangeset, (String)MDS_DPSARRANGESET);
        String workorderradiogroup = dynamicObject.getString("workorderradiogroup");
        if ("8".equals(workorderradiogroup) || "9".equals(workorderradiogroup)) {
            QFilter orderQFilter = null;
            DynamicObjectCollection workorderentity = dynamicObject.getDynamicObjectCollection("workorderentity");
            if (!DpsArrangeUtil.dynamicObjectCollectionIsEmpty(workorderentity)) {
                for (DynamicObject dynamicObj : workorderentity) {
                    DynamicObject orderuseorg = dynamicObj.getDynamicObject("orderuseorg");
                    DynamicObject transactproduct = dynamicObj.getDynamicObject("transactproduct");
                    QFilter filter = new QFilter("1", "=", (Object)1);
                    if ("8".equals(workorderradiogroup)) {
                        if (orderuseorg != null) {
                            filter.and(new QFilter("org.id", "=", orderuseorg.getPkValue()));
                        }
                        if (transactproduct != null) {
                            filter.and(new QFilter("transactiontype.id", "=", transactproduct.getPkValue()));
                        }
                    } else if ("9".equals(workorderradiogroup)) {
                        filter = new QFilter("1", "!=", (Object)1);
                        if (orderuseorg != null) {
                            filter.or(new QFilter("org.id", "!=", orderuseorg.getPkValue()));
                        }
                        if (transactproduct != null) {
                            filter.or(new QFilter("transactiontype.id", "!=", transactproduct.getPkValue()));
                        }
                    }
                    if (orderQFilter == null) {
                        orderQFilter = filter;
                        continue;
                    }
                    orderQFilter.or(filter);
                }
            }
            if (orderQFilter != null) {
                filterList.add(orderQFilter);
            }
        }
        filterList.add(new QFilter("billstatus", "=", (Object)"C"));
        filterList.add(new QFilter("treeentryentity.taskstatus", "in", (Object)new Object[]{"A", "B", "D"}));
        BigDecimal process = BigDecimal.ZERO;
        DataSet mftorderDataSet = QueryServiceHelper.queryDataSet((String)"queryPomMftorder", (String)POM_MFTORDER, (String)"id,billno,treeentryentity.baseqty,treeentryentity.stockqty", (QFilter[])filterList.toArray(new QFilter[filterList.size()]), (String)"id");
        try {
            for (Row mftorder : mftorderDataSet) {
                BigDecimal stockqty;
                BigDecimal baseqty = mftorder.getBigDecimal("treeentryentity.baseqty");
                if (baseqty == null) {
                    baseqty = BigDecimal.ZERO;
                }
                if ((stockqty = mftorder.getBigDecimal("treeentryentity.stockqty")) == null) {
                    stockqty = BigDecimal.ZERO;
                }
                process = process.add(baseqty.subtract(stockqty));
            }
        }
        finally {
            mftorderDataSet.close();
            logger.info("\u5728\u5236\u6570\u91cf\u8fd0\u7b97\u7ed3\u675f\uff0c\u5728\u5236\u6570\u91cf\u4e3a\uff1a" + process);
        }
        return process;
    }

    public static Set<Long> getMbomByPbom(Long mitemId) {
        HashSet<Long> result = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("materielpbom", "=", (Object)mitemId);
        qFilter.and("bomtype", "=", (Object)"MBOM");
        Map valueMap = BusinessDataServiceHelper.loadFromCache((String)MDS_PRODUCTFAMILY, (QFilter[])new QFilter[]{qFilter});
        if (valueMap != null) {
            Collection collection = valueMap.values();
            for (DynamicObject dynamicObject : collection) {
                result.add(dynamicObject.getLong("materielitem.id"));
            }
        }
        return result;
    }

    public static CalcDatePOJO getCalcDate(Date d) {
        Date[] dates = DateUtil.curWeek(d);
        Date[] dates1 = DateUtil.curMonth(d);
        Calendar c = Calendar.getInstance();
        c.setTime(dates1[1]);
        c.add(5, 1);
        Date[] dates2 = DateUtil.curMonth(c.getTime());
        CalcDatePOJO calcDate = new CalcDatePOJO();
        calcDate.setCurWeekStart(dates[0]);
        calcDate.setCurWeekEnd(dates[1]);
        calcDate.setCurMonthStart(dates1[0]);
        calcDate.setCurMonthEnd(dates1[1]);
        calcDate.setNextMonthStart(dates2[0]);
        calcDate.setNextMonthEnd(dates2[1]);
        return calcDate;
    }

    public static List<Date> getDPSPlanCalcDateList(Date curWeekStart, int weeknum) {
        LinkedList<Date> dates = new LinkedList<Date>();
        Calendar c = Calendar.getInstance();
        c.setTime(curWeekStart);
        for (int i = 0; i < weeknum; ++i) {
            dates.add(c.getTime());
            c.add(5, 7);
        }
        return dates;
    }
}

