/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dspsite;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.dspsite.DPSSiteCalcTaskQuotaV2;
import kd.mmc.mds.common.dspsite.DPSSiteCalcTaskSaleOrderItemV2;
import kd.mmc.mds.common.dspsite.DPSSiteCalcTaskV2;
import kd.mmc.mds.common.dspsite.DPSSiteTaskResult;
import kd.mmc.mds.common.util.MDSUtils;

public class DPSSiteCalcTaskEventHandler {
    private static final Log logger = LogFactory.getLog(DPSSiteCalcTaskEventHandler.class);

    public DPSSiteTaskResult handle(Long dpsSiteExecId, Long startTime, DynamicObject def, List<Long> materialIds) {
        if (materialIds == null) {
            return new DPSSiteTaskResult(-1, "task list is null or empty");
        }
        Map<Object, Object> materialOrderMap = new HashMap();
        Map<Object, Object> quotaMap = new HashMap();
        materialOrderMap = this.batchQueryMaterialOrder(materialIds, def.getLong("id"));
        quotaMap = this.batchQueryQuotaNew(def.getLong("dataversion.id"), materialIds);
        for (Long id : materialIds) {
            try {
                Map<String, List<DPSSiteCalcTaskSaleOrderItemV2>> orderItems = ((MaterialOrder)materialOrderMap.get(id)).getOrderItems();
                DPSSiteCalcTaskQuotaV2 quota = (DPSSiteCalcTaskQuotaV2)quotaMap.get(id);
                DPSSiteCalcTaskV2 runTask = new DPSSiteCalcTaskV2(dpsSiteExecId, id, def, startTime, orderItems, quota);
                runTask.doTask();
            }
            catch (Throwable throwable) {
                return new DPSSiteTaskResult(-1, throwable.getMessage());
            }
        }
        return DPSSiteTaskResult.ok;
    }

    private Map<Long, MaterialOrder> batchQueryMaterialOrder(List<Long> materialIds, Long defId) {
        HashMap<Long, MaterialOrder> result = new HashMap<Long, MaterialOrder>(materialIds.size());
        QFilter filter = new QFilter("siteschemeid", "=", (Object)defId);
        filter.and("materialid", "in", materialIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"mds_siterecord", (String)"billno,materialid,billid,billunit,saleorg,recorddate,billrowno,billentryid,qty,stockoutqty,sourceqty", (QFilter[])new QFilter[]{filter}, null);
        if (dataSet != null) {
            for (Row row : dataSet) {
                this.setOrderItemValue(result, row);
            }
            dataSet.close();
        }
        return result;
    }

    private void setOrderItemValue(Map<Long, MaterialOrder> result, Row each) {
        String billno = each.getString("billno");
        Long materialid = each.getLong("materialid");
        Date recorddate = each.getDate("recorddate");
        Long recorddateTime = 0L;
        if (recorddate != null) {
            recorddateTime = recorddate.getTime();
        }
        DPSSiteCalcTaskSaleOrderItemV2 orderItem = new DPSSiteCalcTaskSaleOrderItemV2();
        orderItem.setBillno(billno);
        orderItem.setMaterial(materialid);
        orderItem.setBillid(each.getLong("billid"));
        orderItem.setBaseunitid(each.getLong("billunit"));
        orderItem.setSaleorg(each.getLong("saleorg"));
        orderItem.setOrdertime(recorddateTime);
        orderItem.setBillrowno(each.getInteger("billrowno"));
        orderItem.setBillentryid(each.getLong("billentryid"));
        orderItem.setQty(each.getBigDecimal("sourceqty"));
        orderItem.setAccoutqty(each.getBigDecimal("stockoutqty"));
        orderItem.setUnyetqty(each.getBigDecimal("qty"));
        result.computeIfAbsent(materialid, v -> new MaterialOrder());
        result.get(materialid).put(orderItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, DPSSiteCalcTaskQuotaV2> batchQueryQuotaNew(Long snapshotschemeid, List<Long> materialIds) {
        DPSSiteCalcTaskQuotaV2.DPSSiteCalcTaskQuotaItemV2 item;
        Long losedate;
        Long effectdate;
        Row row;
        DataSet quotasCachedDataSet;
        HashMap<Long, DPSSiteCalcTaskQuotaV2> resultMaterial = new HashMap<Long, DPSSiteCalcTaskQuotaV2>();
        HashMap<Long, DPSSiteCalcTaskQuotaV2> resultoffing = new HashMap<Long, DPSSiteCalcTaskQuotaV2>();
        QFilter filter = new QFilter("id", "in", materialIds);
        filter.and(new QFilter("status", "=", (Object)"C"));
        ArrayList<Long> offingIds = new ArrayList<Long>();
        HashMap offingToMaterial = new HashMap();
        DataSet dataSet = MDSUtils.loadCacheDatas(snapshotschemeid, "bd_material", "id,offeringcode", new QFilter[]{filter});
        Iterator iterator = null;
        DataSet offings = null;
        if (dataSet != null) {
            iterator = dataSet.iterator();
        } else {
            offings = QueryServiceHelper.queryDataSet((String)"dpssite_offings_", (String)"bd_material", (String)"id,offeringcode", (QFilter[])new QFilter[]{filter}, (String)"");
            iterator = offings.iterator();
        }
        try {
            while (iterator.hasNext()) {
                Row row2 = (Row)iterator.next();
                Long materialid = row2.getLong("id");
                Long offeringcode = row2.getLong("offeringcode");
                offingIds.add(offeringcode);
                if (offingToMaterial.get(offeringcode) != null) {
                    ((Set)offingToMaterial.get(offeringcode)).add(materialid);
                    continue;
                }
                HashSet<Long> materialList = new HashSet<Long>();
                materialList.add(materialid);
                offingToMaterial.put(offeringcode, materialList);
            }
        }
        finally {
            if (offings != null) {
                offings.close();
            } else if (dataSet != null) {
                dataSet.close();
            }
        }
        if (offingIds.size() > 0) {
            filter = new QFilter("status", "=", (Object)"C");
            filter.and(new QFilter("enable", "=", (Object)"1"));
            filter.and(new QFilter("quotatype", "=", (Object)"bd_productsummary"));
            filter.and(new QFilter("material.id", "in", offingIds));
            DataSet quotas = null;
            quotasCachedDataSet = MDSUtils.loadCacheDatas(snapshotschemeid, "mds_quotadata", "quotatype,material.id,effectdate,losedate,entryentity.id,entryentity.seq,entryentity.quotamod,entryentity.allocateorg", new QFilter[]{filter});
            if (quotasCachedDataSet != null) {
                iterator = quotasCachedDataSet.iterator();
            } else {
                quotas = QueryServiceHelper.queryDataSet((String)"dpssite_quotadata_", (String)"mds_quotadata", (String)"quotatype,material.id,effectdate,losedate,entryentity.id,entryentity.seq,entryentity.quotamod,entryentity.allocateorg", (QFilter[])new QFilter[]{filter}, (String)"");
                iterator = quotas.iterator();
            }
            try {
                while (iterator.hasNext()) {
                    row = (Row)iterator.next();
                    Long offingId = row.getLong("material.id");
                    effectdate = row.getDate("effectdate").getTime();
                    losedate = row.getDate("losedate").getTime();
                    BigDecimal quotamod = row.getBigDecimal("entryentity.quotamod");
                    Long allocateorg = row.getLong("entryentity.allocateorg");
                    String entryid = String.valueOf(row.getLong("entryentity.id"));
                    item = new DPSSiteCalcTaskQuotaV2.DPSSiteCalcTaskQuotaItemV2();
                    item.setQuotatype("bd_productsummary");
                    item.setEffectdate(effectdate);
                    item.setLosedate(losedate);
                    item.setQuotamod(quotamod);
                    item.setAllocateorg(allocateorg);
                    item.setQuotaentryid(entryid);
                    resultoffing.computeIfAbsent(offingId, v -> new DPSSiteCalcTaskQuotaV2());
                    ((DPSSiteCalcTaskQuotaV2)resultoffing.get(offingId)).addQuota(item);
                }
            }
            finally {
                if (quotas != null) {
                    quotas.close();
                } else if (quotasCachedDataSet != null) {
                    quotasCachedDataSet.close();
                }
            }
        }
        filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("quotatype", "=", (Object)"bd_material"));
        filter.and(new QFilter("material.id", "in", materialIds));
        DataSet materials = null;
        quotasCachedDataSet = MDSUtils.loadCacheDatas(snapshotschemeid, "mds_quotadata", "quotatype,material.id,effectdate,losedate,entryentity.id,entryentity.seq,entryentity.quotamod,entryentity.allocateorg", new QFilter[]{filter});
        if (quotasCachedDataSet != null) {
            iterator = quotasCachedDataSet.iterator();
        } else {
            materials = QueryServiceHelper.queryDataSet((String)"dpssite_material_", (String)"mds_quotadata", (String)"quotatype,material.id,effectdate,losedate,entryentity.id,entryentity.seq,entryentity.quotamod,entryentity.allocateorg", (QFilter[])new QFilter[]{filter}, (String)"");
            iterator = materials.iterator();
        }
        try {
            while (iterator.hasNext()) {
                row = (Row)iterator.next();
                Long materialId = row.getLong("material.id");
                effectdate = row.getDate("effectdate").getTime();
                losedate = row.getDate("losedate").getTime();
                String entryid = String.valueOf(row.getLong("entryentity.id"));
                BigDecimal quotamod = row.getBigDecimal("entryentity.quotamod");
                Long allocateorg = row.getLong("entryentity.allocateorg");
                item = new DPSSiteCalcTaskQuotaV2.DPSSiteCalcTaskQuotaItemV2();
                item.setQuotatype("bd_material");
                item.setEffectdate(effectdate);
                item.setLosedate(losedate);
                item.setQuotamod(quotamod);
                item.setQuotaentryid(entryid);
                item.setAllocateorg(allocateorg);
                resultMaterial.computeIfAbsent(materialId, v -> new DPSSiteCalcTaskQuotaV2());
                ((DPSSiteCalcTaskQuotaV2)resultMaterial.get(materialId)).addQuota(item);
            }
            if (materialIds.size() > 0) {
                for (Long materialId : materialIds) {
                    for (Map.Entry mapEntry : offingToMaterial.entrySet()) {
                        Long offing = (Long)mapEntry.getKey();
                        Set materialSet = (Set)mapEntry.getValue();
                        if (!materialSet.contains(materialId)) continue;
                        resultMaterial.computeIfAbsent(materialId, v -> new DPSSiteCalcTaskQuotaV2());
                        if (resultoffing.get(offing) == null) continue;
                        ((DPSSiteCalcTaskQuotaV2)resultMaterial.get(materialId)).addQuotaAll(((DPSSiteCalcTaskQuotaV2)resultoffing.get(offing)).getQuotas());
                    }
                }
            }
        }
        finally {
            if (quotasCachedDataSet != null) {
                quotasCachedDataSet.close();
            } else if (materials != null) {
                materials.close();
            }
        }
        return resultMaterial;
    }

    public static class MaterialOrder {
        private Map<String, List<DPSSiteCalcTaskSaleOrderItemV2>> orderItems = new HashMap<String, List<DPSSiteCalcTaskSaleOrderItemV2>>();

        public void put(DPSSiteCalcTaskSaleOrderItemV2 item) {
            this.orderItems.computeIfAbsent(item.getBillno(), k -> new ArrayList());
            this.orderItems.get(item.getBillno()).add(item);
        }

        public Map<String, List<DPSSiteCalcTaskSaleOrderItemV2>> getOrderItems() {
            return this.orderItems;
        }
    }
}

