/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dspsite;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.mmc.mds.common.dspsite.AbstractDPSSiteCalcHandler;
import kd.mmc.mds.common.dspsite.DPSSiteCalcTaskQuotaV2;
import kd.mmc.mds.common.dspsite.DPSSiteCalcTaskSaleOrderItemV2;
import kd.mmc.mds.common.dspsite.DPSSiteMaterialBO;
import kd.mmc.mds.common.dspsite.DPSSiteQuotaDealHandlerV2;
import kd.mmc.mds.common.dspsite.DPSSiteSaleOrderBO;
import kd.mmc.mds.common.dspsite.impl.DPSSiteBDGatherHandler;
import kd.mmc.mds.common.dspsite.impl.DPSSiteDummySiteGatherHandler;
import kd.mmc.mds.common.dspsite.impl.DPSSiteFNReleResultGatherHandler;
import kd.mmc.mds.common.dspsite.impl.DPSSiteResultGatherHandler;
import kd.mmc.mds.common.impl.KDCloudMdsNewLogRecorder;
import kd.mmc.mds.common.util.MDSUtils;

public class DPSSiteCalcTaskV2 {
    private final Context context;
    private static final Log logger = LogFactory.getLog(DPSSiteCalcTaskV2.class);

    public DPSSiteCalcTaskV2(Long dpsSiteExecId, Long materialId, DynamicObject def, long startTime, Map<String, List<DPSSiteCalcTaskSaleOrderItemV2>> saleOrders, DPSSiteCalcTaskQuotaV2 quota) {
        this.context = new Context(dpsSiteExecId, materialId, startTime, def, saleOrders, quota);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTask() {
        boolean isException = false;
        boolean doLog = true;
        String errorinfo = null;
        try {
            if (!this.checkDPSSuppendStatus()) {
                this.startLog();
                this.startBusinessFlow();
            } else {
                doLog = false;
            }
        }
        catch (Exception e) {
            errorinfo = e.getMessage();
            if (errorinfo == null) {
                errorinfo = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            }
            if (errorinfo != null && errorinfo.length() >= 1000) {
                errorinfo = errorinfo.substring(0, 999);
            }
            isException = true;
            logger.info("DPSSite\u8ba1\u7b97\uff1a", (Object)e);
        }
        finally {
            if (doLog) {
                if (isException) {
                    this.context.bo.getLogger().updateResultLog(ResManager.loadKDString((String)"\u5f02\u5e38", (String)"DPSSiteCalcTaskV2_0", (String)"mmc-mds-common", (Object[])new Object[0]), errorinfo);
                } else {
                    this.context.bo.getLogger().updateResultLog(ResManager.loadKDString((String)"\u6210\u529f", (String)"DPSSiteCalcTaskV2_1", (String)"mmc-mds-common", (Object[])new Object[0]), "");
                }
            }
        }
    }

    private boolean checkDPSSuppendStatus() {
        boolean isSuppend = false;
        Long dpsSiteExecId = this.context.dpsSiteExecId;
        QFilter filter = new QFilter("id", "=", (Object)dpsSiteExecId);
        QFilter[] qfilters = new QFilter[]{filter};
        DynamicObject dpsplan = QueryServiceHelper.queryOne((String)"mds_dpsplanexec", (String)"enable", (QFilter[])qfilters);
        if (dpsplan.getString("enable").equals("E")) {
            isSuppend = true;
        }
        return isSuppend;
    }

    private void startLog() {
        KDCloudMdsNewLogRecorder recorder = new KDCloudMdsNewLogRecorder(this.context.dpsSiteExecId, this.context.startTime);
        QFilter filter = new QFilter("id", "=", (Object)this.context.materialId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bd_material", (String)"name", (QFilter[])new QFilter[]{filter});
        if (obj == null) {
            recorder.initMDSRunLog(String.format(ResManager.loadKDString((String)"\u7269\u6599ID\u4e3a\u201c%s\u201d\uff0c\u65e0\u6cd5\u67e5\u8be2\u5230\u7269\u6599\uff0c\u65e0\u6cd5\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"DPSSiteCalcTaskV2_11", (String)"mmc-mds-common", (Object[])new Object[0]), this.context.materialId));
            this.context.bo.setLogger(recorder);
            return;
        }
        recorder.initMDSRunLog(String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\uff0c\u4f9b\u5e94\u7ec4\u7ec7\u5206\u914d\u8ba1\u7b97\u4efb\u52a1\u5f00\u59cb\u3002", (String)"DPSSiteCalcTaskV2_12", (String)"mmc-mds-common", (Object[])new Object[0]), obj.getString("name")));
        this.context.bo.setLogger(recorder);
    }

    private void startBusinessFlow() {
        this.context.bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u6b63\u5728\u51c6\u5907\u6765\u6e90\u6570\u636e\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"DPSSiteCalcTaskV2_6", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
        ArrayList<DPSSiteSaleOrderBO> saleorderList = new ArrayList<DPSSiteSaleOrderBO>();
        if (!this.context.saleOrders.isEmpty()) {
            Long sitbasedataid = this.context.def.getLong("sitebasedata.id");
            Boolean isquota = this.context.def.getBoolean("isquota");
            Long dummysiteid = this.context.def.getLong("dummysite.id");
            Long siteschemeid = this.context.def.getLong("id");
            Long fnschemeid = this.context.def.getLong("setoffsetting.id");
            Long snapshotschemeid = this.context.def.getLong("dataversion.id");
            this.context.bo.setMaterialid(this.context.materialId);
            this.context.bo.setBasedataid(sitbasedataid);
            this.context.bo.setQuota(isquota);
            this.context.bo.setDummysiteid(dummysiteid);
            this.context.bo.setSiteschemeid(siteschemeid);
            this.context.bo.setFnschemeid(fnschemeid);
            this.context.bo.setSnapshotschemeid(snapshotschemeid);
            this.context.saleOrders.forEach((billNo, orderItems) -> {
                if (orderItems == null) {
                    return;
                }
                for (DPSSiteCalcTaskSaleOrderItemV2 orderItem : orderItems) {
                    DPSSiteSaleOrderBO saleorderbo = orderItem.mapperToSaleOrderBO();
                    if (saleorderbo.getUnyetqty().compareTo(BigDecimal.ZERO) <= 0) continue;
                    saleorderList.add(saleorderbo);
                }
            });
            Collections.sort(saleorderList, new Comparator<DPSSiteSaleOrderBO>(){

                @Override
                public int compare(DPSSiteSaleOrderBO o1, DPSSiteSaleOrderBO o2) {
                    if (o1.getOrdertime().compareTo(o2.getOrdertime()) == 0) {
                        return o1.getUnyetqty().compareTo(o2.getUnyetqty());
                    }
                    return o1.getOrdertime().compareTo(o2.getOrdertime());
                }
            });
            int salecount = saleorderList.size();
            if (salecount > 0) {
                ((DPSSiteSaleOrderBO)saleorderList.get(salecount - 1)).setCargo(true);
            }
        }
        this.context.bo.setSaleorders(saleorderList);
        AbstractDPSSiteCalcHandler handler = this.getHandlerByMaterialType();
        handler.handlerNext(this.context.bo);
    }

    private Boolean getCompleteTag() {
        Boolean isCompleteTag = Boolean.FALSE;
        DynamicObject completetag = BusinessDataServiceHelper.loadSingleFromCache((Object)this.context.materialId, (String)"bd_material", (String)"completetag");
        if (completetag != null) {
            isCompleteTag = completetag.getBoolean("completetag");
        }
        return isCompleteTag;
    }

    private AbstractDPSSiteCalcHandler getHandlerByMaterialType() {
        QFilter filter = new QFilter("masterid", "=", (Object)this.context.materialId);
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DataSet dataSet = MDSUtils.loadCacheDatas(this.context.def.getLong("dataversion.id"), "mpdm_materialplan", "id,materialattr", new QFilter[]{filter});
        String materialattr = null;
        if (dataSet != null) {
            Iterator iter = dataSet.iterator();
            if (dataSet.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u8be5\u7269\u6599\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"DPSSiteCalcTaskV2_7", (String)"mmc-mds-common", (Object[])new Object[0]));
            }
            boolean i = false;
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                materialattr = row.getString("materialattr");
                if (i) continue;
                break;
            }
        } else {
            DynamicObject materialplan = QueryServiceHelper.queryOne((String)"mpdm_materialplan", (String)"id,materialattr", (QFilter[])new QFilter[]{filter});
            if (materialplan == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u8be5\u7269\u6599\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"DPSSiteCalcTaskV2_7", (String)"mmc-mds-common", (Object[])new Object[0]));
            }
            materialattr = materialplan.getString("materialattr");
        }
        Boolean materialtype = this.getCompleteTag();
        AbstractDPSSiteCalcHandler gather = null;
        if ("10030".equals(materialattr)) {
            if (materialtype.booleanValue()) {
                this.context.bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u6d41\u8f6c\u6d41\u7a0b\u4e3a:\u4f9b\u5e94+\u914d\u989d+\u7f3a\u914d\u989d\u7ec4\u7ec7\u3002", (String)"DPSSiteCalcTaskV2_8", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
                DPSSiteBDGatherHandler bdgather = new DPSSiteBDGatherHandler();
                DPSSiteQuotaDealHandlerV2 quota = new DPSSiteQuotaDealHandlerV2(this.context);
                DPSSiteDummySiteGatherHandler dummysitegather = new DPSSiteDummySiteGatherHandler();
                DPSSiteResultGatherHandler resultgather = new DPSSiteResultGatherHandler();
                DPSSiteFNReleResultGatherHandler fnresultgather = new DPSSiteFNReleResultGatherHandler();
                bdgather.setNextHandler(quota);
                quota.setNextHandler(dummysitegather);
                dummysitegather.setNextHandler(resultgather);
                resultgather.setNextHandler(fnresultgather);
                gather = bdgather;
            } else {
                this.context.bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u6d41\u8f6c\u6d41\u7a0b\u4e3a:\u914d\u989d+\u7f3a\u914d\u989d\u7ec4\u7ec7\u3002", (String)"DPSSiteCalcTaskV2_9", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
                DPSSiteQuotaDealHandlerV2 quota = new DPSSiteQuotaDealHandlerV2(this.context);
                DPSSiteDummySiteGatherHandler dummysitegather = new DPSSiteDummySiteGatherHandler();
                DPSSiteResultGatherHandler resultgather = new DPSSiteResultGatherHandler();
                DPSSiteFNReleResultGatherHandler fnresultgather = new DPSSiteFNReleResultGatherHandler();
                quota.setNextHandler(dummysitegather);
                dummysitegather.setNextHandler(resultgather);
                resultgather.setNextHandler(fnresultgather);
                gather = quota;
            }
        } else {
            this.context.bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u6d41\u8f6c\u6d41\u7a0b\u4e3a\uff1a\u7f3a\u914d\u989d\u7ec4\u7ec7\u3002", (String)"DPSSiteCalcTaskV2_10", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
            DPSSiteDummySiteGatherHandler dummysitegather = new DPSSiteDummySiteGatherHandler();
            DPSSiteResultGatherHandler resultgather = new DPSSiteResultGatherHandler();
            DPSSiteFNReleResultGatherHandler fnresultgather = new DPSSiteFNReleResultGatherHandler();
            dummysitegather.setNextHandler(resultgather);
            resultgather.setNextHandler(fnresultgather);
            gather = dummysitegather;
        }
        return gather;
    }

    public static class Context {
        public static final String SM_SALORDER = "sm_salorder";
        private final Long dpsSiteExecId;
        private final Long materialId;
        private final long startTime;
        private final DynamicObject def;
        private DPSSiteCalcTaskQuotaV2 quota;
        private Map<String, List<DPSSiteCalcTaskSaleOrderItemV2>> saleOrders = new HashMap<String, List<DPSSiteCalcTaskSaleOrderItemV2>>();
        private DPSSiteMaterialBO bo = new DPSSiteMaterialBO();

        public Context(Long dpsSiteExecId, Long materialId, DynamicObject def, long startTime) {
            this.dpsSiteExecId = dpsSiteExecId;
            this.materialId = materialId;
            this.def = def;
            this.startTime = startTime;
        }

        public Context(Long dpsSiteExecId, Long materialId, long startTime, DynamicObject def, Map<String, List<DPSSiteCalcTaskSaleOrderItemV2>> saleOrders, DPSSiteCalcTaskQuotaV2 quota) {
            this.dpsSiteExecId = dpsSiteExecId;
            this.materialId = materialId;
            this.startTime = startTime;
            this.def = def;
            this.saleOrders = saleOrders;
            this.quota = quota;
        }

        public DPSSiteCalcTaskQuotaV2 getQuota() {
            return this.quota;
        }
    }
}

