/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dspsite;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.mmc.mds.common.dspsite.AbstractDPSSiteCalcHandler;
import kd.mmc.mds.common.dspsite.DPSSiteCalcTaskQuotaV2;
import kd.mmc.mds.common.dspsite.DPSSiteCalcTaskV2;
import kd.mmc.mds.common.dspsite.DPSSiteMaterialBO;
import kd.mmc.mds.common.dspsite.DPSSiteSaleOrderBO;
import kd.mmc.mds.common.dspsite.DPSSiteSaleOrderDetailBO;
import kd.mmc.mds.common.dspsite.DPSSiteSupplyTypeEnum;

public class DPSSiteQuotaDealHandlerV2
extends AbstractDPSSiteCalcHandler {
    private final DPSSiteCalcTaskV2.Context context;

    public DPSSiteQuotaDealHandlerV2(DPSSiteCalcTaskV2.Context context) {
        this.context = context;
    }

    @Override
    protected void handlerRequest(DPSSiteMaterialBO bo) {
        Boolean quota = bo.getQuota();
        bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u8fdb\u5165\u5bf9\u6bd4\u914d\u989d\u6570\u636e\u3002", (String)"DPSSiteQuotaDealHandlerV2_0", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
        if (quota.booleanValue()) {
            if (this.context.getQuota() == null || this.context.getQuota().getQuotas().size() == 0) {
                bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u8fdb\u5165\u5bf9\u6bd4\u914d\u989d\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DPSSiteQuotaDealHandlerV2_1", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
                return;
            }
            bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u8fdb\u5165\u5bf9\u6bd4\u914d\u989d\u6570\u636e\u5b58\u5728\u3002", (String)"DPSSiteQuotaDealHandlerV2_2", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
            List<DPSSiteSaleOrderBO> boList = bo.getSaleorders();
            for (DPSSiteSaleOrderBO eachOrderItem : boList) {
                if (eachOrderItem.getDpssiteid() != null || eachOrderItem.getUnyetqty().compareTo(BigDecimal.ZERO) <= 0) continue;
                Long orderTime = eachOrderItem.getOrdertime();
                List<DPSSiteCalcTaskQuotaV2.DPSSiteCalcTaskQuotaItemV2> quotaItems = this.context.getQuota().getQuotas();
                ArrayList<DPSSiteCalcTaskQuotaV2.DPSSiteCalcTaskQuotaItemV2> effectMaterials = new ArrayList<DPSSiteCalcTaskQuotaV2.DPSSiteCalcTaskQuotaItemV2>(quotaItems.size());
                ArrayList<DPSSiteCalcTaskQuotaV2.DPSSiteCalcTaskQuotaItemV2> effectProducts = new ArrayList<DPSSiteCalcTaskQuotaV2.DPSSiteCalcTaskQuotaItemV2>(quotaItems.size());
                for (DPSSiteCalcTaskQuotaV2.DPSSiteCalcTaskQuotaItemV2 each : quotaItems) {
                    Long effectDate = each.getEffectdate();
                    Long loseDate = each.getLosedate();
                    String quotaType = each.getQuotatype();
                    if (orderTime < effectDate || orderTime > loseDate) continue;
                    if ("bd_material".equals(quotaType)) {
                        effectMaterials.add(each);
                        continue;
                    }
                    effectProducts.add(each);
                }
                if (effectMaterials.size() > 0) {
                    this.createDetailDataCollection(effectMaterials, eachOrderItem);
                    continue;
                }
                if (effectProducts.size() <= 0) continue;
                this.createDetailDataCollection(effectProducts, eachOrderItem);
            }
            bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u5bf9\u6bd4\u914d\u989d\u6570\u636e\u5b8c\u6210\u3002", (String)"DPSSiteQuotaDealHandlerV2_3", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
        }
    }

    private void createDetailDataCollection(List<DPSSiteCalcTaskQuotaV2.DPSSiteCalcTaskQuotaItemV2> effectMaterials, DPSSiteSaleOrderBO bo) {
        Long siteOrg = null;
        BigDecimal initData = BigDecimal.ZERO;
        DPSSiteCalcTaskQuotaV2.DPSSiteCalcTaskQuotaItemV2 hit = null;
        for (DPSSiteCalcTaskQuotaV2.DPSSiteCalcTaskQuotaItemV2 each : effectMaterials) {
            BigDecimal quotaMod = each.getQuotamod();
            Long allocateOrg = each.getAllocateorg();
            if (quotaMod.compareTo(initData) <= 0) continue;
            initData = quotaMod;
            siteOrg = allocateOrg;
            hit = each;
        }
        if (siteOrg != null) {
            bo.setDpssiteid(siteOrg);
            bo.getDetials().add(this.createDetailData("SR", hit, bo.getOrdertime(), bo.getUnyetqty()));
            bo.setUnyetqty(BigDecimal.ZERO);
        }
    }

    private DPSSiteSaleOrderDetailBO createDetailData(String supplytype, DPSSiteCalcTaskQuotaV2.DPSSiteCalcTaskQuotaItemV2 obj, Long supplytime, BigDecimal matchqty) {
        DPSSiteSaleOrderDetailBO bo = new DPSSiteSaleOrderDetailBO();
        if ("IMV".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_WAREHOUSE);
        } else if ("WIP".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_WIP);
        } else if ("DPS".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_DPS);
        } else if ("CARGO".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_CARGO);
        } else if ("SR".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_SR);
        } else if ("DUMMYSITE".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_DUMMYSITE);
        }
        bo.setSupplytime(supplytime);
        bo.setMatchqty(matchqty);
        bo.setBillflag(obj.getQuotaentryid());
        return bo;
    }
}

