/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dspsite;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.setoff.FormulaExec;
import kd.mmc.mds.common.setoff.SetOffCommonUtil;
import kd.mmc.mds.common.util.MDSGetBillFieldChangeData;

public class SiteRecordDataOp {
    private final String BILLFIELDTRANSFER = "id,filter_tag,destbill.id,srcbill.id,entryentity.destfieldflag,entryentity.sourcefieldflag,entryentity.converttype,entryentity.calculateexc,entryentity.calculatetext";
    private final String SOURCEDATACONFIG = "id,billfieldtransfer,filter_tag";
    private static final Log logger = LogFactory.getLog(SiteRecordDataOp.class);
    private Long Siteschemeid = 0L;

    public Long getSiteschemeid() {
        return this.Siteschemeid;
    }

    public final void setSiteschemeid(Long siteschemeid) {
        this.Siteschemeid = siteschemeid;
    }

    public SiteRecordDataOp(Long siteschemeid) {
        this.setSiteschemeid(siteschemeid);
    }

    public void start() {
        this.checkDataSouceHasFiled();
        this.unSiteRecord();
        this.convertDataToSiteRecord();
    }

    private Long getDateSourceid(Long siteschemeid) {
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"mds_siteschemedef", (String)"salorderst", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)siteschemeid)});
        if (queryOne != null) {
            return queryOne.getLong("salorderst");
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u9700\u6c42\u5206\u914d\u65b9\u6848\u5b9a\u4e49\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u914d\u7f6e\u3002", (String)"SiteRecordDataOp_0", (String)"mmc-mds-common", (Object[])new Object[0]));
    }

    private Long getMrpDataid(Long siteschemeid) {
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"mds_siteschemedef", (String)"dataversion", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)siteschemeid)});
        if (queryOne != null) {
            return queryOne.getLong("dataversion");
        }
        return 0L;
    }

    private void convertDataToSiteRecord() {
        QFilter qfiltersor = new QFilter("id", "=", (Object)this.getDateSourceid(this.getSiteschemeid()));
        DynamicObject sourfield = QueryServiceHelper.queryOne((String)"mrp_resource_dataconf_rgt", (String)"id,billfieldtransfer,filter_tag", (QFilter[])new QFilter[]{qfiltersor});
        if (sourfield == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u914d\u7f6e\u3002", (String)"SiteRecordDataOp_1", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        QFilter qfilter = new QFilter("id", "=", (Object)sourfield.getLong("billfieldtransfer"));
        DynamicObjectCollection billfieldentry = QueryServiceHelper.query((String)"mrp_billfieldtransfer", (String)"id,filter_tag,destbill.id,srcbill.id,entryentity.destfieldflag,entryentity.sourcefieldflag,entryentity.converttype,entryentity.calculateexc,entryentity.calculatetext", (QFilter[])new QFilter[]{qfilter});
        if (billfieldentry == null || billfieldentry.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6570\u636e\u6e90\u914d\u7f6e\u5bf9\u5e94\u7684\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u3002", (String)"SiteRecordDataOp_2", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        String destbill = ((DynamicObject)billfieldentry.get(0)).getString("destbill.id");
        boolean degbugerr = true;
        ArrayList<Object> dynSet = new ArrayList<DynamicObject>();
        String materialUnitfiled = this.getMaterialUnitfiled(billfieldentry);
        MDSGetBillFieldChangeData bfcd = new MDSGetBillFieldChangeData();
        ArrayList<String> addfield = new ArrayList<String>(10);
        if (!materialUnitfiled.isEmpty()) {
            addfield.add(materialUnitfiled);
            bfcd.setAddFiled(addfield);
        }
        Long mrpDataid = this.getMrpDataid(this.getSiteschemeid());
        try (DataSet ds = bfcd.getEntityFieldMappingData(sourfield, mrpDataid);){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row dataitem = ds.next();
                    DynamicObject recordData = this.getNewDynamicObject(destbill);
                    recordData.set("siteschemeid", (Object)this.getSiteschemeid());
                    recordData.set("org", (Object)RequestContext.get().getOrgId());
                    recordData.set("billstatus", (Object)"C");
                    recordData.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
                    recordData.set("createtime", (Object)new Date());
                    for (DynamicObject item : billfieldentry) {
                        String contype = item.getString("entryentity.converttype");
                        try {
                            if ("0".equals(contype)) {
                                recordData.set(item.getString("entryentity.destfieldflag"), dataitem.get(item.getString("entryentity.sourcefieldflag").trim()));
                                continue;
                            }
                            if ("4".equals(contype)) {
                                recordData.set(item.getString("entryentity.destfieldflag"), dataitem.get(item.getString("entryentity.calculateexc").trim()));
                                continue;
                            }
                            String exestr = item.getString("entryentity.calculateexc");
                            if (FormulaExec.IsexecMode(exestr)) {
                                Object execval = FormulaExec.exec(exestr, dataitem);
                                if (execval == null) continue;
                                recordData.set(item.getString("entryentity.destfieldflag"), execval);
                                continue;
                            }
                            String dstag = item.getString("entryentity.destfieldflag");
                            String execfiledName = SetOffCommonUtil.getExecfiledName(exestr, dstag);
                            recordData.set(dstag, dataitem.get(execfiledName));
                        }
                        catch (Exception e) {
                            if (!degbugerr) continue;
                            logger.warn("MDS Dps Site getdata:" + e);
                        }
                    }
                    if (recordData.getLong("materialid") <= 0L || recordData.getBigDecimal("qty").compareTo(new BigDecimal(0)) < 0) continue;
                    if (recordData.getLong("billunit") <= 0L && !materialUnitfiled.isEmpty()) {
                        recordData.set("billunit", dataitem.get(materialUnitfiled));
                    }
                    dynSet.add(recordData);
                    if (dynSet.size() <= 10000) continue;
                    this.insertData(dynSet);
                    dynSet = new ArrayList(10005);
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        if (!dynSet.isEmpty()) {
            this.insertData(dynSet);
        }
    }

    private void checkDataSouceHasFiled() {
        ArrayList<String> fieldset = new ArrayList<String>();
        ArrayList<String> fieldsetCN = new ArrayList<String>();
        fieldset.add("recorddate");
        fieldsetCN.add(ResManager.loadKDString((String)"\u8bb0\u5f55\u65e5\u671f", (String)"SiteRecordDataOp_3", (String)"mmc-mds-common", (Object[])new Object[0]));
        fieldset.add("qty");
        fieldsetCN.add(ResManager.loadKDString((String)"\u6570\u91cf", (String)"SiteRecordDataOp_4", (String)"mmc-mds-common", (Object[])new Object[0]));
        fieldset.add("materialid");
        fieldsetCN.add(ResManager.loadKDString((String)"\u7269\u6599", (String)"SiteRecordDataOp_5", (String)"mmc-mds-common", (Object[])new Object[0]));
        QFilter qfiltersor = new QFilter("id", "=", (Object)this.getDateSourceid(this.getSiteschemeid()));
        DynamicObject sourfield = QueryServiceHelper.queryOne((String)"mrp_resource_dataconf_rgt", (String)"id,billfieldtransfer,filter_tag", (QFilter[])new QFilter[]{qfiltersor});
        if (sourfield == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u914d\u7f6e\u3002", (String)"SiteRecordDataOp_1", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        QFilter qfilter = new QFilter("id", "=", (Object)sourfield.getLong("billfieldtransfer"));
        DynamicObjectCollection billfieldentry = QueryServiceHelper.query((String)"mrp_billfieldtransfer", (String)"id,filter_tag,destbill.id,srcbill.id,entryentity.destfieldflag,entryentity.sourcefieldflag,entryentity.converttype,entryentity.calculateexc,entryentity.calculatetext", (QFilter[])new QFilter[]{qfilter});
        if (billfieldentry == null || billfieldentry.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6570\u636e\u6e90\u914d\u7f6e\u5bf9\u5e94\u7684\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u3002", (String)"SiteRecordDataOp_2", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        String destbill = ((DynamicObject)billfieldentry.get(0)).getString("destbill.id");
        if (!"mds_siterecord".equalsIgnoreCase(destbill)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u76ee\u6807\u5b9e\u4f53\u53ea\u80fd\u4e3a\u9700\u6c42\u5f85\u5206\u914d\u8bb0\u5f55\u67e5\u8be2\u3002", (String)"SiteRecordDataOp_6", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        StringBuilder sBuilder = new StringBuilder();
        int i = 0;
        for (String itemfield : fieldset) {
            boolean isfind = false;
            for (DynamicObject item : billfieldentry) {
                if (!itemfield.equalsIgnoreCase(item.getString("entryentity.destfieldflag"))) continue;
                isfind = true;
            }
            if (!isfind) {
                sBuilder.append((String)fieldsetCN.get(i));
                sBuilder.append(',');
            }
            ++i;
        }
        if (sBuilder.length() > 0) {
            sBuilder.deleteCharAt(sBuilder.length() - 1);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u9700\u8981\u914d\u7f6e\u76ee\u6807\u5b9e\u4f53\u201c%s\u201d\u5b57\u6bb5\u7684\u6620\u5c04\u4fe1\u606f\u3002", (String)"SiteRecordDataOp_7", (String)"mmc-mds-common", (Object[])new Object[0]), sBuilder.toString()));
        }
    }

    private Boolean unSiteRecord() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("delete from t_mds_siterecord  where fsiteschemeid=? ");
            DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sb.toString(), (Object[])new Object[]{this.getSiteschemeid()});
            return true;
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6e05\u9664\u9700\u6c42\u5f85\u5206\u914d\u8bb0\u5f55\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"SiteRecordDataOp_9", (String)"mmc-mds-common", (Object[])new Object[0]), e.toString()));
        }
    }

    private String getMaterialUnitfiled(DynamicObjectCollection dyobj) {
        StringBuilder sBuilder = new StringBuilder();
        for (DynamicObject item : dyobj) {
            if (!"materialid".equalsIgnoreCase(item.getString("entryentity.destfieldflag")) || item.getString("entryentity.sourcefieldflag").isEmpty()) continue;
            sBuilder.append(item.getString("entryentity.sourcefieldflag"));
            sBuilder.append('.');
            sBuilder.append("baseunit");
            return sBuilder.toString();
        }
        return "";
    }

    private DynamicObject getNewDynamicObject(String entityNumber) {
        return ORM.create().newDynamicObject(entityNumber);
    }

    private void insertData(List<DynamicObject> recordData) {
        ORM.create().insert(recordData);
    }
}

