/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dspsite.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.dspsite.AbstractDPSSiteCalcHandler;
import kd.mmc.mds.common.dspsite.DPSSiteConst;
import kd.mmc.mds.common.dspsite.DPSSiteMaterialBO;
import kd.mmc.mds.common.dspsite.DPSSiteSaleOrderBO;
import kd.mmc.mds.common.dspsite.DPSSiteSaleOrderDetailBO;
import kd.mmc.mds.common.dspsite.DPSSiteSupplyTypeEnum;
import kd.mmc.mds.common.dspsite.ISupplyDataByMaterialID;
import kd.mmc.mds.common.util.MDSUtils;
import kd.mmc.mds.common.util.SliceUtil;

public class DPSSiteBDGatherHandler
extends AbstractDPSSiteCalcHandler {
    private static Log logger = LogFactory.getLog(DPSSiteBDGatherHandler.class);

    @Override
    protected void handlerRequest(DPSSiteMaterialBO obj) {
        obj.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u8fdb\u5165\u5bf9\u6bd4\u4f9b\u5e94\u6570\u636e\u3002", (String)"DPSSiteBDGatherHandler_0", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
        Long materialid = obj.getMaterialid();
        Long basedataid = obj.getBasedataid();
        List<DPSSiteSaleOrderBO> saleorders = obj.getSaleorders();
        List<JSONObject> supplydataList = this.getSupplyDataByMaterialID(basedataid, obj, materialid);
        logger.info("\u7269\u6599ID{};\u4f9b\u5e94\u6570\u636e\uff1a{}", (Object)materialid, supplydataList);
        for (DPSSiteSaleOrderBO bo : saleorders) {
            logger.info("\u7269\u6599ID{};\u9700\u6c42\u6570\u636e\uff1a{}", (Object)materialid, (Object)bo);
            if (bo.isCargo()) {
                this.createDetailDataCollectionByCargo(supplydataList, bo);
            } else {
                this.createDetailDataCollection(supplydataList, bo);
            }
            SliceUtil.sortComposeCollPriority(supplydataList, "PRIORITY", "treeentryentity.planendtime", "BASEQTY");
        }
        obj.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u6b63\u5728\u6bd4\u5bf9\u4f9b\u5e94\u6570\u636e\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"DPSSiteBDGatherHandler_4", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
    }

    private void createDetailDataCollectionByCargo(List<JSONObject> supplydataList, DPSSiteSaleOrderBO bo) {
        BigDecimal unyetqty = bo.getUnyetqty();
        Long siteorg = null;
        if (supplydataList.size() > 0) {
            if (unyetqty.compareTo(BigDecimal.ZERO) > 0) {
                this.dealCargoDataToUnyetDataNew(supplydataList, unyetqty, bo, siteorg);
            }
            this.clearSuppyDataZero(supplydataList);
        }
    }

    private void createDetailDataCollection(List<JSONObject> supplydataList, DPSSiteSaleOrderBO bo) {
        BigDecimal unyetqty = bo.getUnyetqty();
        Long siteorg = null;
        Long carsitorg = null;
        if (supplydataList.size() > 0) {
            int index = 0;
            logger.info("\u9500\u552e\u8ba2\u5355:" + bo.getSaleordernumber());
            for (JSONObject supplydata : supplydataList) {
                logger.info("\u9500\u552e\u8ba2\u5355:" + bo.getSaleordernumber() + "\u5269\u4f59\u6570\u91cf1\uff1a" + unyetqty);
                if (unyetqty.compareTo(BigDecimal.ZERO) == 0) break;
                if (index == 0) {
                    JSONObject firstObj = supplydataList.get(0);
                    siteorg = firstObj.getLong("ORG");
                    bo.setDpssiteid(siteorg);
                    carsitorg = siteorg;
                    unyetqty = this.dealSupplyDataToUnyetData(firstObj, unyetqty, bo);
                    logger.info("\u9500\u552e\u8ba2\u5355:" + bo.getSaleordernumber() + "\u5269\u4f59\u6570\u91cf2\uff1a" + unyetqty);
                    bo.setUnyetqty(unyetqty);
                } else {
                    Long org = supplydata.getLong("ORG");
                    if (siteorg != null && siteorg.equals(org)) {
                        logger.info("\u9500\u552e\u8ba2\u5355:" + bo.getSaleordernumber() + "\u5269\u4f59\u6570\u91cf3\uff1a" + unyetqty);
                        unyetqty = this.dealSupplyDataToUnyetData(supplydata, unyetqty, bo);
                        bo.setUnyetqty(unyetqty);
                    }
                }
                ++index;
            }
            logger.info("\u9500\u552e\u8ba2\u5355:" + bo.getSaleordernumber() + "\u5269\u4f59\u6570\u91cf4\uff1a" + unyetqty);
            if (unyetqty.compareTo(BigDecimal.ZERO) > 0) {
                this.dealCargoDataToUnyetData(supplydataList, unyetqty, bo, carsitorg);
            }
            this.clearSuppyDataZero(supplydataList);
        }
    }

    private void dealCargoDataToUnyetDataNew(List<JSONObject> supplydataList, BigDecimal unyetqty, DPSSiteSaleOrderBO boMain, Long siteorg) {
        this.clearSuppyDataZero(supplydataList);
        DPSSiteSaleOrderBO childbo = this.cloneSaleOrderBO(boMain, unyetqty);
        if (supplydataList.size() > 0) {
            for (JSONObject supplydata : supplydataList) {
                if (unyetqty.compareTo(BigDecimal.ZERO) == 0) {
                    return;
                }
                Long cargoorg = supplydata.getLong("ORG");
                unyetqty = this.dealSupplyDataToUnyetData(supplydata, unyetqty, childbo);
                childbo.setUnyetqty(unyetqty);
                childbo.setDpssiteid(cargoorg);
                siteorg = cargoorg;
                if (supplydataList.isEmpty()) continue;
                break;
            }
            boMain.getCargo().add(childbo);
            if (unyetqty.compareTo(BigDecimal.ZERO) > 0 && supplydataList.size() > 0) {
                this.dealCargoDataToUnyetDataNew(supplydataList, unyetqty, boMain, siteorg);
            }
            boMain.setUnyetqty(BigDecimal.ZERO);
        } else {
            childbo.getDetials().add(this.createDetailData(new JSONObject(), "CARGO", unyetqty));
            childbo.setUnyetqty(BigDecimal.ZERO);
            childbo.setDpssiteid(siteorg);
            boMain.getCargo().add(childbo);
            boMain.setUnyetqty(BigDecimal.ZERO);
        }
    }

    private void dealCargoDataToUnyetData(List<JSONObject> supplydataList, BigDecimal unyetqty, DPSSiteSaleOrderBO boMain, Long carsitorg) {
        this.clearSuppyDataZero(supplydataList);
        DPSSiteSaleOrderBO childbo = this.cloneSaleOrderBO(boMain, unyetqty);
        logger.info("\u9500\u552e\u8ba2\u5355:" + childbo.getSaleordernumber() + "\u5269\u4f59\u6570\u91cf5\uff1a" + unyetqty);
        if (unyetqty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        Long siteorg = null;
        if (supplydataList.size() > 0) {
            int index = 0;
            for (JSONObject supplydata : supplydataList) {
                if (unyetqty.compareTo(BigDecimal.ZERO) == 0) continue;
                if (index == 0) {
                    JSONObject firstObj = supplydataList.get(0);
                    siteorg = firstObj.getLong("ORG");
                    childbo.setDpssiteid(siteorg);
                    carsitorg = siteorg;
                    unyetqty = this.dealSupplyDataToUnyetData(firstObj, unyetqty, childbo);
                    logger.info("\u9500\u552e\u8ba2\u5355:" + childbo.getSaleordernumber() + "\u5269\u4f59\u6570\u91cf6\uff1a" + unyetqty);
                    childbo.setUnyetqty(unyetqty);
                } else {
                    Long org = supplydata.getLong("ORG");
                    if (siteorg != null && siteorg.equals(org)) {
                        logger.info("\u9500\u552e\u8ba2\u5355:" + childbo.getSaleordernumber() + "\u5269\u4f59\u6570\u91cf7\uff1a" + unyetqty);
                        unyetqty = this.dealSupplyDataToUnyetData(supplydata, unyetqty, childbo);
                        childbo.setUnyetqty(unyetqty);
                    }
                }
                ++index;
            }
            boMain.getCargo().add(childbo);
            logger.info("\u9500\u552e\u8ba2\u5355:" + childbo.getSaleordernumber() + "\u5269\u4f59\u6570\u91cf8\uff1a" + unyetqty);
            if (unyetqty.compareTo(BigDecimal.ZERO) > 0 && supplydataList.size() > 0) {
                this.dealCargoDataToUnyetData(supplydataList, unyetqty, boMain, carsitorg);
            }
            boMain.setUnyetqty(BigDecimal.ZERO);
        } else {
            logger.info("\u9500\u552e\u8ba2\u5355:" + childbo.getSaleordernumber() + "\u5c3e\u5355\u6570\u636e\u91cf\uff1a" + unyetqty);
            childbo.getDetials().add(this.createDetailData(new JSONObject(), "CARGO", unyetqty));
            childbo.setUnyetqty(BigDecimal.ZERO);
            childbo.setDpssiteid(carsitorg);
            boMain.getCargo().add(childbo);
            boMain.setUnyetqty(BigDecimal.ZERO);
        }
    }

    private void clearSuppyDataZero(List<JSONObject> supplydataList) {
        ArrayList<JSONObject> removeListData = new ArrayList<JSONObject>();
        for (JSONObject supplydata : supplydataList) {
            BigDecimal baseqty = supplydata.getBigDecimal("BASEQTY");
            if (baseqty.compareTo(BigDecimal.ZERO) != 0) continue;
            removeListData.add(supplydata);
        }
        supplydataList.removeAll(removeListData);
    }

    private DPSSiteSaleOrderBO cloneSaleOrderBO(DPSSiteSaleOrderBO bo, BigDecimal unyetqty) {
        DPSSiteSaleOrderBO childbo = new DPSSiteSaleOrderBO();
        childbo.setAccoutstockqty(bo.getAccoutstockqty());
        childbo.setSaleorderid(bo.getSaleorderid());
        childbo.setMaterialid(bo.getMaterialid());
        childbo.setUnyetqty(unyetqty);
        childbo.setOrdertime(bo.getOrdertime());
        childbo.setSaleordernumber(bo.getSaleordernumber());
        childbo.setBilltype(bo.getBilltype());
        childbo.setSaleorg(bo.getSaleorg());
        childbo.setSeq(bo.getSeq());
        childbo.setBaseunitid(bo.getBaseunitid());
        childbo.setQty(bo.getQty());
        childbo.setUnyetqtyBak(bo.getUnyetqtyBak());
        return childbo;
    }

    private BigDecimal dealSupplyDataToUnyetData(JSONObject supplydata, BigDecimal unyetqty, DPSSiteSaleOrderBO bo) {
        BigDecimal baseqty = supplydata.getBigDecimal("BASEQTY");
        String type = supplydata.getString("TYPE");
        if (unyetqty.compareTo(baseqty) >= 0) {
            unyetqty = unyetqty.subtract(baseqty);
            supplydata.put("BASEQTY", (Object)BigDecimal.ZERO);
            BigDecimal matchqty = baseqty;
            bo.getDetials().add(this.createDetailData(supplydata, type, matchqty));
        } else {
            baseqty = baseqty.subtract(unyetqty);
            supplydata.put("BASEQTY", (Object)baseqty);
            bo.getDetials().add(this.createDetailData(supplydata, type, unyetqty));
            unyetqty = BigDecimal.ZERO;
        }
        return unyetqty;
    }

    private DPSSiteSaleOrderDetailBO createDetailData(JSONObject supplydata, String supplytype, BigDecimal matchqty) {
        DPSSiteSaleOrderDetailBO bo = new DPSSiteSaleOrderDetailBO();
        Long supplytime = supplydata.getLong("treeentryentity.planendtime");
        if ("IMV".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_WAREHOUSE);
        } else if ("WIP".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_WIP);
        } else if ("DPS".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_DPS);
        } else if ("CARGO".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_CARGO);
        }
        bo.setBillflag(supplydata.getString("billno"));
        bo.setMatchreq(supplydata.getInteger("seq"));
        bo.setSupplytime(supplytime);
        bo.setMatchqty(matchqty);
        return bo;
    }

    private List<JSONObject> getSupplyDataByMaterialID(Long basedataid, DPSSiteMaterialBO bo, Long materialid) {
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
        String sitebasedata = "entryentity.supplytype,entryentity.isselected";
        QFilter filter = new QFilter("entryentity.isselected", "=", (Object)Boolean.TRUE);
        filter.and(new QFilter("id", "=", (Object)basedataid));
        QFilter[] filters = new QFilter[]{filter};
        DataSet dataSet = MDSUtils.loadCacheDatas(bo.getSnapshotschemeid(), "mds_sitebasedata", sitebasedata, filters);
        if (dataSet != null) {
            Iterator iter = dataSet.iterator();
            if (dataSet.isEmpty()) {
                bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u4f9b\u5e94\u5b9a\u4e49\u672a\u542f\u52a8\u4efb\u4f55\u4f9b\u5e94\u7c7b\u578b\u3002", (String)"DPSSiteBDGatherHandler_5", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
                return resultList;
            }
            int priority = 1;
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String supplytype = row.getString("entryentity.supplytype");
                boolean isselected = row.getBoolean("entryentity.isselected");
                if (!isselected) continue;
                Map<String, String> supplydataMap = DPSSiteConst.getSupplyDataMap();
                ISupplyDataByMaterialID implClass = null;
                try {
                    implClass = (ISupplyDataByMaterialID)Class.forName(supplydataMap.get(supplytype)).newInstance();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
                if (implClass != null) {
                    resultList.addAll(implClass.getData(bo, materialid, basedataid, priority));
                }
                ++priority;
            }
        } else {
            DynamicObject basedataInfo = BusinessDataServiceHelper.loadSingle((String)"mds_sitebasedata", (String)sitebasedata, (QFilter[])filters);
            if (basedataInfo == null) {
                bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u4f9b\u5e94\u5b9a\u4e49\u672a\u542f\u52a8\u4efb\u4f55\u4f9b\u5e94\u7c7b\u578b\u3002", (String)"DPSSiteBDGatherHandler_5", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
                return resultList;
            }
            DynamicObjectCollection colls = basedataInfo.getDynamicObjectCollection("entryentity");
            int priority = 1;
            for (DynamicObject entry : colls) {
                String supplytype = entry.getString("supplytype");
                boolean isselected = entry.getBoolean("isselected");
                if (!isselected) continue;
                Map<String, String> supplydataMap = DPSSiteConst.getSupplyDataMap();
                ISupplyDataByMaterialID implClass = null;
                try {
                    implClass = (ISupplyDataByMaterialID)Class.forName(supplydataMap.get(supplytype)).newInstance();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
                if (implClass != null) {
                    resultList.addAll(implClass.getData(bo, materialid, basedataid, priority));
                }
                ++priority;
            }
        }
        return resultList;
    }
}

