/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dspsite.impl;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.mmc.mds.common.dspsite.AbstractDPSSiteCalcHandler;
import kd.mmc.mds.common.dspsite.DPSSiteMaterialBO;
import kd.mmc.mds.common.dspsite.DPSSiteSaleOrderBO;
import kd.mmc.mds.common.dspsite.DPSSiteSaleOrderDetailBO;
import kd.mmc.mds.common.dspsite.DPSSiteSupplyTypeEnum;

public class DPSSiteDummySiteGatherHandler
extends AbstractDPSSiteCalcHandler {
    @Override
    protected void handlerRequest(DPSSiteMaterialBO bo) {
        bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u6b63\u5728\u6bd4\u5bf9\u7f3a\u914d\u989d\u7ec4\u7ec7\u6570\u636e\u3002", (String)"DPSSiteDummySiteGatherHandler_0", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
        Long dummysiteid = bo.getDummysiteid();
        List<DPSSiteSaleOrderBO> boList = bo.getSaleorders();
        for (int n = 0; n < boList.size(); ++n) {
            DPSSiteSaleOrderBO saleorder = boList.get(n);
            BigDecimal unyetqty = saleorder.getUnyetqty();
            if (unyetqty.compareTo(BigDecimal.ZERO) <= 0) continue;
            saleorder.setDpssiteid(dummysiteid);
            saleorder.getDetials().add(this.createDetailData("DUMMYSITE", saleorder.getOrdertime(), saleorder.getUnyetqty()));
            saleorder.setUnyetqty(BigDecimal.ZERO);
        }
    }

    private DPSSiteSaleOrderDetailBO createDetailData(String supplytype, Long supplytime, BigDecimal matchqty) {
        DPSSiteSaleOrderDetailBO bo = new DPSSiteSaleOrderDetailBO();
        if ("IMV".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_WAREHOUSE);
        } else if ("WIP".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_WIP);
        } else if ("DPS".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_DPS);
        } else if ("CARGO".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_CARGO);
        } else if ("SR".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_SR);
        } else if ("DUMMYSITE".equals(supplytype)) {
            bo.setSupplytype(DPSSiteSupplyTypeEnum.CO_DUMMYSITE);
        }
        bo.setSupplytime(supplytime);
        bo.setMatchqty(matchqty);
        return bo;
    }
}

