/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dspsite.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.dspsite.AbstractDPSSiteCalcHandler;
import kd.mmc.mds.common.dspsite.DPSSiteMaterialBO;
import kd.mmc.mds.common.util.SliceUtil;

public class DPSSiteFNReleResultGatherHandler
extends AbstractDPSSiteCalcHandler {
    private Log logger = LogFactory.getLog(DPSSiteFNReleResultGatherHandler.class);

    @Override
    protected void handlerRequest(DPSSiteMaterialBO bo) {
        Long fnid = bo.getFnschemeid();
        Long schemeid = bo.getSiteschemeid();
        Long materialid = bo.getMaterialid();
        this.logger.info("\u8fdb\u5165\u51b2\u51cf\u5173\u8054DPS\u8fd0\u7b97\uff1a\u51b2\u51cf\u65b9\u6848ID" + fnid + ";DPS\u65b9\u6848ID:" + schemeid);
        bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u6b63\u5728\u6574\u7406\u51b2\u51cf\u548c\u65e5\u751f\u4ea7\u8ba1\u5212\u5bf9\u6bd4\u7ed3\u679c\u6570\u636e\u3002", (String)"DPSSiteFNReleResultGatherHandler_0", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
        if (fnid.compareTo(0L) > 0) {
            QFilter filter = new QFilter("setid.id", "=", (Object)fnid);
            filter.and("srcmaterialid.id", "=", (Object)materialid);
            DynamicObjectCollection fnColls = QueryServiceHelper.query((String)"mds_fnreport", (String)"sno,rowno,unitid.id,setoffqty,kqdate,salremainqty,isqtysetoff", (QFilter[])new QFilter[]{filter});
            filter = new QFilter("siteschemedef.id", "=", (Object)schemeid);
            filter.and(new QFilter("material.id", "=", (Object)materialid));
            DynamicObjectCollection dpsColls = QueryServiceHelper.query((String)"mds_dpsallocresult", (String)"number,orderseq,baseunit.id,mateqty,orgsite.id", (QFilter[])new QFilter[]{filter});
            this.createDPSFNResult(bo, dpsColls, fnColls);
        }
        bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u7ed3\u675f\u6574\u7406\u51b2\u51cf\u548c\u65e5\u751f\u4ea7\u8ba1\u5212\u5bf9\u6bd4\u7ed3\u679c\u6570\u636e\u3002", (String)"DPSSiteFNReleResultGatherHandler_1", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
    }

    private void createDPSFNResult(DPSSiteMaterialBO bo, DynamicObjectCollection dpsColls, DynamicObjectCollection fnColls) {
        JSONObject dpsobjAll = new JSONObject();
        HashSet<String> snoAllSet = new HashSet<String>();
        if (dpsColls != null) {
            for (DynamicObject dpsobj : dpsColls) {
                BigDecimal mateqty = dpsobj.getBigDecimal("mateqty");
                Long orgsiteid = dpsobj.getLong("orgsite.id");
                String billno = dpsobj.getString("number");
                String orderseq = dpsobj.getString("orderseq");
                Long baseunitid = dpsobj.getLong("baseunit.id");
                String key = billno + "#" + orderseq;
                snoAllSet.add(key);
                List value = (List)dpsobjAll.get((Object)key);
                JSONObject tmpObj = new JSONObject();
                tmpObj.put("BILLNO", (Object)billno);
                tmpObj.put("SEQ", (Object)orderseq);
                tmpObj.put("MATEQTY", (Object)mateqty);
                tmpObj.put("OLDMATEQTY", (Object)mateqty);
                tmpObj.put("ORGSITE", (Object)orgsiteid);
                tmpObj.put("BASEUNIT", (Object)baseunitid);
                if (value != null && value.size() > 0) {
                    value.add(tmpObj);
                    dpsobjAll.put(key, (Object)value);
                    continue;
                }
                ArrayList<JSONObject> array = new ArrayList<JSONObject>();
                array.add(tmpObj);
                dpsobjAll.put(key, array);
            }
        }
        JSONObject fnobjAll = new JSONObject();
        if (fnColls != null) {
            for (DynamicObject fnobj : fnColls) {
                BigDecimal setoffqty = fnobj.getBigDecimal("setoffqty");
                BigDecimal salremainqty = fnobj.getBigDecimal("salremainqty");
                Date kddateD = fnobj.getDate("kqdate");
                Long kddate = kddateD.getTime();
                String billno = fnobj.getString("sno");
                String orderseq = fnobj.getString("rowno");
                Long baseunit = fnobj.getLong("unitid.id");
                Object isqtysetoff = fnobj.get("isqtysetoff");
                String key = billno + "#" + orderseq;
                if (StringUtils.isEmpty((CharSequence)billno) && StringUtils.isEmpty((CharSequence)orderseq)) continue;
                snoAllSet.add(key);
                List value = (List)fnobjAll.get((Object)key);
                JSONObject tmpObj = new JSONObject();
                tmpObj.put("BILLNO", (Object)billno);
                tmpObj.put("SEQ", (Object)orderseq);
                tmpObj.put("SETOFFQTY", (Object)setoffqty);
                tmpObj.put("OLDSETOFFQTY", (Object)setoffqty);
                tmpObj.put("KQDATE", (Object)kddate);
                tmpObj.put("BASEUNIT", (Object)baseunit);
                tmpObj.put("SALREMAINQTY", (Object)salremainqty);
                tmpObj.put("ISQTYSETOFF", isqtysetoff);
                if (value != null && value.size() > 0) {
                    value.add(tmpObj);
                    fnobjAll.put(key, (Object)value);
                    continue;
                }
                ArrayList<JSONObject> array = new ArrayList<JSONObject>();
                array.add(tmpObj);
                fnobjAll.put(key, array);
            }
        }
        this.createDPSFNDetails(bo, snoAllSet, dpsobjAll, fnobjAll);
    }

    private void createDPSFNDetails(DPSSiteMaterialBO bo, Set<String> snoAllSet, JSONObject dpsobjAll, JSONObject fnobjAll) {
        ORM orm = ORM.create();
        ArrayList<DynamicObject> results = new ArrayList<DynamicObject>();
        for (String key : snoAllSet) {
            Long kqdate;
            BigDecimal fnqty;
            List dpsList = (List)dpsobjAll.get((Object)key);
            List fnList = (List)fnobjAll.get((Object)key);
            if (dpsList != null && dpsList.size() > 0) {
                SliceUtil.sortBigDecimal(dpsList, "MATEQTY");
            }
            if (fnList != null && fnList.size() > 0) {
                SliceUtil.sortComposeColl(fnList, "KQDATE", "SETOFFQTY");
            }
            if (dpsList == null && fnList != null) {
                for (JSONObject fnObj : fnList) {
                    fnqty = fnObj.getBigDecimal("SETOFFQTY");
                    kqdate = fnObj.getLong("KQDATE");
                    results.add(this.createDPSFNDetail(bo, orm, fnObj, fnObj, fnqty, 0L, kqdate));
                }
                continue;
            }
            if (dpsList != null && fnList == null) {
                for (JSONObject dpsObj : dpsList) {
                    BigDecimal meteqty = dpsObj.getBigDecimal("MATEQTY");
                    Long orgsiteid = dpsObj.getLong("ORGSITE");
                    results.add(this.createDPSFNDetail(bo, orm, dpsObj, null, meteqty, orgsiteid, 0L));
                }
                continue;
            }
            if (dpsList != null && dpsList.size() > 0) {
                for (JSONObject dpsobj : dpsList) {
                    BigDecimal mateqty = dpsobj.getBigDecimal("MATEQTY");
                    Long siteorgid = dpsobj.getLong("ORGSITE");
                    for (JSONObject fnobj : fnList) {
                        BigDecimal fnqty2 = fnobj.getBigDecimal("SETOFFQTY");
                        BigDecimal salremainqty = fnobj.getBigDecimal("SALREMAINQTY");
                        BigDecimal oldsetoffqty = fnobj.getBigDecimal("OLDSETOFFQTY");
                        if (oldsetoffqty.compareTo(BigDecimal.ZERO) == 0) {
                            fnqty2 = salremainqty;
                            fnobj.put("OLDSETOFFQTY", (Object)salremainqty);
                            fnobj.put("SETOFFQTY", (Object)salremainqty);
                            fnobj.put("issalremainqty", (Object)Boolean.TRUE);
                        }
                        if (fnqty2.compareTo(BigDecimal.ZERO) == 0) continue;
                        if (mateqty.compareTo(BigDecimal.ZERO) <= 0) break;
                        Long kqdate2 = fnobj.getLong("KQDATE");
                        if (mateqty.compareTo(fnqty2) >= 0) {
                            results.add(this.createDPSFNDetail(bo, orm, dpsobj, fnobj, fnqty2, siteorgid, kqdate2));
                            mateqty = mateqty.subtract(fnqty2);
                            fnobj.put("SETOFFQTY", (Object)BigDecimal.ZERO);
                            continue;
                        }
                        results.add(this.createDPSFNDetail(bo, orm, dpsobj, fnobj, mateqty, siteorgid, kqdate2));
                        fnqty2 = fnqty2.subtract(mateqty);
                        fnobj.put("SETOFFQTY", (Object)fnqty2);
                        mateqty = BigDecimal.ZERO;
                    }
                    dpsobj.put("MATEQTY", (Object)mateqty);
                    if (mateqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    results.add(this.createDPSFNDetail(bo, orm, dpsobj, null, mateqty, siteorgid, 0L));
                }
            }
            if (fnList == null || fnList.size() <= 0) continue;
            for (JSONObject fnobj : fnList) {
                fnqty = fnobj.getBigDecimal("SETOFFQTY");
                if (fnqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                kqdate = fnobj.getLong("KQDATE");
                for (JSONObject dpsobj : dpsList) {
                    BigDecimal mateqty = dpsobj.getBigDecimal("MATEQTY");
                    Long siteorgid = dpsobj.getLong("ORGSITE");
                    if (mateqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    if (mateqty.compareTo(fnqty) >= 0) {
                        results.add(this.createDPSFNDetail(bo, orm, dpsobj, fnobj, fnqty, siteorgid, kqdate));
                        mateqty = mateqty.subtract(fnqty);
                        fnqty = BigDecimal.ZERO;
                    } else {
                        results.add(this.createDPSFNDetail(bo, orm, dpsobj, fnobj, mateqty, siteorgid, kqdate));
                        fnqty = fnqty.subtract(mateqty);
                        mateqty = BigDecimal.ZERO;
                    }
                    dpsobj.put("MATEQTY", (Object)mateqty);
                }
                fnobj.put("SETOFFQTY", (Object)fnqty);
            }
        }
        SaveServiceHelper.save((DynamicObject[])results.toArray(new DynamicObject[0]));
    }

    private DynamicObject createDPSFNDetail(DPSSiteMaterialBO bo, ORM orm, JSONObject dpsobj, JSONObject fnObj, BigDecimal qty, Long siteorgid, Long kqdate) {
        DynamicObject dpsbill = orm.newDynamicObject("mds_dpsfnresult");
        dpsbill.set("number", (Object)dpsobj.getString("BILLNO"));
        String seqStr = dpsobj.getString("SEQ");
        if (StringUtils.isEmpty((CharSequence)seqStr)) {
            seqStr = "0";
        }
        dpsbill.set("orderseq", (Object)Integer.valueOf(seqStr));
        dpsbill.set("materiel", (Object)bo.getMaterialid());
        dpsbill.set("baseunit", (Object)dpsobj.getLong("BASEUNIT"));
        dpsbill.set("matchqty", (Object)qty);
        dpsbill.set("orgsite", (Object)siteorgid);
        if (kqdate == 0L) {
            dpsbill.set("fntime", null);
        } else {
            dpsbill.set("fntime", (Object)kqdate);
        }
        if (fnObj == null) {
            dpsbill.set("fnqty", (Object)0);
        } else {
            dpsbill.set("fnqty", (Object)fnObj.getDoubleValue("OLDSETOFFQTY"));
            dpsbill.set("isqtysetoff", fnObj.get((Object)"ISQTYSETOFF"));
            Object issalremainqty = fnObj.get((Object)"issalremainqty");
            if (issalremainqty == null) {
                dpsbill.set("issalremainqty", (Object)Boolean.FALSE);
            } else {
                dpsbill.set("issalremainqty", fnObj.get((Object)"issalremainqty"));
            }
        }
        dpsbill.set("mateqty", dpsobj.get((Object)"OLDMATEQTY"));
        dpsbill.set("dpsscheme", (Object)bo.getSiteschemeid());
        dpsbill.set("fndefineid", (Object)bo.getFnschemeid());
        dpsbill.set("status", (Object)"A");
        dpsbill.set("enable", (Object)1);
        return dpsbill;
    }
}

