/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dspsite.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.dspsite.AbstractDPSSiteCalcHandler;
import kd.mmc.mds.common.dspsite.DPSSiteMaterialBO;
import kd.mmc.mds.common.dspsite.DPSSiteSaleOrderBO;
import kd.mmc.mds.common.dspsite.DPSSiteSaleOrderDetailBO;

public class DPSSiteResultGatherHandler
extends AbstractDPSSiteCalcHandler {
    @Override
    protected void handlerRequest(DPSSiteMaterialBO obj) {
        List<DPSSiteSaleOrderBO> boList = obj.getSaleorders();
        ORM orm = ORM.create();
        ArrayList<DynamicObject> entitys = new ArrayList<DynamicObject>();
        for (DPSSiteSaleOrderBO bo : boList) {
            if (bo.getDetials().size() > 0) {
                entitys.add(this.getResultObject(orm, bo, obj));
            }
            for (DPSSiteSaleOrderBO cargo : bo.getCargo()) {
                entitys.add(this.getResultObject(orm, cargo, obj));
            }
        }
        SaveServiceHelper.save((DynamicObject[])entitys.toArray(new DynamicObject[0]));
        obj.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u6b63\u5728\u6574\u7406\u5bf9\u6bd4\u7ed3\u679c\u6570\u636e\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"DPSSiteResultGatherHandler_0", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
    }

    private DynamicObject getResultObject(ORM orm, DPSSiteSaleOrderBO bo, DPSSiteMaterialBO obj) {
        DynamicObject dpsbill = orm.newDynamicObject("mds_dpsallocresult");
        dpsbill.set("creator", (Object)RequestContext.get().getCurrUserId());
        dpsbill.set("createtime", (Object)new Date());
        dpsbill.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dpsbill.set("modifytime", (Object)new Date());
        dpsbill.set("number", (Object)bo.getSaleordernumber());
        dpsbill.set("org", (Object)bo.getSaleorg());
        dpsbill.set("orderseq", (Object)bo.getSeq());
        dpsbill.set("material", (Object)bo.getMaterialid());
        dpsbill.set("baseunit", (Object)bo.getBaseunitid());
        dpsbill.set("qty", (Object)bo.getQty());
        dpsbill.set("accoutstockqty", (Object)bo.getAccoutstockqty());
        dpsbill.set("residueqty", (Object)bo.getUnyetqtyBak());
        dpsbill.set("orgsite", (Object)bo.getDpssiteid());
        dpsbill.set("enable", (Object)1);
        dpsbill.set("siteschemedef", (Object)obj.getSiteschemeid());
        dpsbill.set("enddate", (Object)System.currentTimeMillis());
        List<DPSSiteSaleOrderDetailBO> details = bo.getDetials();
        BigDecimal mateqty = BigDecimal.ZERO;
        int index = 0;
        for (DPSSiteSaleOrderDetailBO detail : details) {
            DynamicObject entry = dpsbill.getDynamicObjectCollection("entryentity").addNew();
            entry.set("supplytype", (Object)detail.getSupplytype().getValue());
            entry.set("matchqty", (Object)detail.getMatchqty());
            mateqty = mateqty.add(detail.getMatchqty());
            entry.set("supplytime", (Object)detail.getSupplytime());
            entry.set("matchseq", (Object)detail.getMatchreq());
            entry.set("billflag", (Object)detail.getBillflag());
            entry.set("seq", (Object)(++index));
        }
        dpsbill.set("mateqty", (Object)mateqty);
        return dpsbill;
    }
}

