/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dspsite.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.dspsite.DPSSiteCalcTaskV2;
import kd.mmc.mds.common.dspsite.DPSSiteMaterialBO;
import kd.mmc.mds.common.dspsite.ISupplyDataByMaterialID;
import kd.mmc.mds.common.util.MDSUtils;
import kd.mmc.mds.common.util.SliceUtil;

public class StorageSupplyDataImpl
implements ISupplyDataByMaterialID {
    private Long nocanuselong = new Long(99999L);
    private static final Log logger = LogFactory.getLog(DPSSiteCalcTaskV2.class);

    @Override
    public List<JSONObject> getData(DPSSiteMaterialBO bo, Long materialid, Long basedataid, Integer priority) {
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
        bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u67e5\u8be2\u5e93\u5b58\u6570\u636e\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"StorageSupplyDataImpl_0", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter[] filterstype = this.contructQFilterTypeAndStatus(bo.getSnapshotschemeid(), basedataid, materialid);
        QFilter[] filterStorage = this.contructQFilterStorage(bo.getSnapshotschemeid(), basedataid, materialid);
        filterList.addAll(Arrays.asList(filterstype));
        filterList.addAll(Arrays.asList(filterStorage));
        DataSet dataSet = MDSUtils.loadCacheDatas(bo.getSnapshotschemeid(), "im_inv_realbalance", "id,org,baseqty", filterList.toArray(new QFilter[0]));
        if (dataSet != null) {
            for (Row row : dataSet) {
                JSONObject jsonobj = new JSONObject();
                jsonobj.put("BASEQTY", (Object)row.getBigDecimal("BASEQTY"));
                jsonobj.put("treeentryentity.planendtime", (Object)SliceUtil.getDateLong(Calendar.getInstance().getTime()));
                jsonobj.put("ORG", row.get("org"));
                jsonobj.put("billno", row.get("id"));
                jsonobj.put("seq", row.get("id"));
                jsonobj.put("TYPE", (Object)"IMV");
                jsonobj.put("PRIORITY", (Object)priority);
                resultList.add(jsonobj);
            }
        } else {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"im_inv_realbalance", (String)"id,org,baseqty", (QFilter[])filterList.toArray(new QFilter[0]));
            for (DynamicObject obj : coll) {
                JSONObject jsonobj = new JSONObject();
                jsonobj.put("BASEQTY", (Object)obj.getBigDecimal("BASEQTY"));
                jsonobj.put("treeentryentity.planendtime", (Object)SliceUtil.getDateLong(Calendar.getInstance().getTime()));
                jsonobj.put("ORG", obj.get("org"));
                jsonobj.put("billno", obj.get("id"));
                jsonobj.put("seq", obj.get("id"));
                jsonobj.put("TYPE", (Object)"IMV");
                jsonobj.put("PRIORITY", (Object)priority);
                resultList.add(jsonobj);
            }
        }
        SliceUtil.sortComposeColl(resultList, "treeentryentity.planendtime", "BASEQTY");
        bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u67e5\u8be2\u5e93\u5b58\u6570\u636e\u5df2\u7ed3\u675f\u3002", (String)"StorageSupplyDataImpl_1", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
        return resultList;
    }

    private QFilter[] contructQFilterTypeAndStatus(Long snapshotschemeid, Long basedataid, Long materialid) {
        QFilter filter = new QFilter("material.id", "=", (Object)materialid);
        String sitebasedata = "stocksetup,entryentity.supplytype,entryentity.isselected,stockstypeentity.stocktype,stockstypeentity.stocktype.id,stockstypeentity.ismrp,stockstatusentity.stocktype1,stockstatusentity.stocktype1.id,stockstatusentity.ismrp1";
        QFilter sitefilter = new QFilter("entryentity.isselected", "=", (Object)Boolean.TRUE);
        sitefilter.and(new QFilter("id", "=", (Object)basedataid));
        QFilter[] filters = new QFilter[]{sitefilter};
        QFilter basedataFilter = new QFilter("id", "=", (Object)basedataid);
        DataSet dataSet = MDSUtils.loadCacheDatas(snapshotschemeid, "mds_sitebasedata", sitebasedata, new QFilter[]{basedataFilter});
        if (dataSet != null) {
            Iterator iter = dataSet.iterator();
            filter.and(new QFilter("baseqty", ">", (Object)BigDecimal.ZERO));
            HashSet<Long> stocktypeSet = new HashSet<Long>();
            HashSet<Long> stockstatusentitySet = new HashSet<Long>();
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                Boolean ismrp = row.getBoolean("stockstypeentity.ismrp");
                Boolean ismrp1 = row.getBoolean("stockstatusentity.ismrp1");
                if (ismrp.booleanValue()) {
                    stocktypeSet.add(row.getLong("stockstypeentity.stocktype.id"));
                }
                if (!ismrp1.booleanValue()) continue;
                stockstatusentitySet.add(row.getLong("stockstatusentity.stocktype1.id"));
            }
            if (stocktypeSet.size() > 0) {
                filter.and(new QFilter("invtype.id", "in", stocktypeSet));
            }
            if (stockstatusentitySet.size() > 0) {
                filter.and(new QFilter("invstatus.id", "in", stockstatusentitySet));
            }
        } else {
            DynamicObject basedataInfo = BusinessDataServiceHelper.loadSingle((String)"mds_sitebasedata", (String)sitebasedata, (QFilter[])filters);
            filter.and(new QFilter("baseqty", ">", (Object)BigDecimal.ZERO));
            HashSet<Long> stocktypeSet = new HashSet<Long>();
            DynamicObjectCollection stockstypeentity = basedataInfo.getDynamicObjectCollection("stockstypeentity");
            for (DynamicObject obj : stockstypeentity) {
                DynamicObject stocktype = obj.getDynamicObject("stocktype");
                Boolean ismrp = obj.getBoolean("ismrp");
                if (!ismrp.booleanValue() || stocktype == null) continue;
                stocktypeSet.add(stocktype.getLong("id"));
            }
            if (stocktypeSet.size() > 0) {
                filter.and(new QFilter("invtype.id", "in", stocktypeSet));
            }
            DynamicObjectCollection stockstatusentity = basedataInfo.getDynamicObjectCollection("stockstatusentity");
            HashSet<Long> stockstatusentitySet = new HashSet<Long>();
            for (DynamicObject obj : stockstatusentity) {
                DynamicObject stocktype = obj.getDynamicObject("stocktype1");
                Boolean ismrp = obj.getBoolean("ismrp1");
                if (!ismrp.booleanValue() || stocktype == null) continue;
                stockstatusentitySet.add(stocktype.getLong("id"));
            }
            if (stockstatusentitySet.size() > 0) {
                filter.and(new QFilter("invstatus.id", "in", stockstatusentitySet));
            }
        }
        logger.warn("\u7269\u6599\uff1a" + materialid + "\u67e5\u8be2\u5230\u7684\u5e93\u5b58\u7c7b\u578b\u548c\u72b6\u6001\u6761\u4ef6\u4e3a\uff1a" + filter.toString());
        return new QFilter[]{filter};
    }

    private QFilter[] contructQFilterStorage(Long snapshotschemeid, Long basedataid, Long materialid) {
        QFilter tmpfilter;
        DataSet dataSet;
        QFilter stocksetupentryMain = null;
        String stocksetup = null;
        int rowcount = 0;
        String sitebasedata = "stocksetupentry,stocksetupentry.stockorg,stocksetupentry.stockorg.id,stocksetupentry.stocknumber,stocksetupentry.stocknumber.id,stocksetupentry.stockindex,stocksetupentry.stockindex.id";
        QFilter sitefilter = new QFilter("entryentity.isselected", "=", (Object)Boolean.TRUE);
        sitefilter.and(new QFilter("id", "=", (Object)basedataid));
        QFilter[] filters = new QFilter[]{sitefilter};
        QFilter basedataFilter = new QFilter("id", "=", (Object)basedataid);
        DataSet dataSetHead = MDSUtils.loadCacheDatas(snapshotschemeid, "mds_sitebasedata", "stocksetup", new QFilter[]{basedataFilter});
        if (dataSetHead != null) {
            Iterator iter = dataSetHead.iterator();
            boolean i = false;
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                stocksetup = row.getString("stocksetup");
                if (i) continue;
                break;
            }
        }
        if ((dataSet = MDSUtils.loadCacheDatas(snapshotschemeid, "mds_sitebasedata", sitebasedata, new QFilter[]{basedataFilter})) != null) {
            Iterator iter = dataSet.iterator();
            int n = 0;
            while (iter.hasNext()) {
                Long stockindexid;
                Long stocknumberid;
                Row row = (Row)iter.next();
                tmpfilter = new QFilter("org.id", "is not null", (Object)"1=1");
                Long stockorgid = row.getLong("stocksetupentry.stockorg.id");
                if (stockorgid != null && stockorgid != 0L) {
                    tmpfilter.and(new QFilter("org.id", "=", (Object)stockorgid));
                }
                if ((stocknumberid = row.getLong("stocksetupentry.stocknumber.id")) != null && stocknumberid != 0L) {
                    tmpfilter.and(new QFilter("warehouse.id", "=", (Object)stocknumberid));
                }
                if ((stockindexid = row.getLong("stocksetupentry.stockindex.id")) != null && stockindexid != 0L) {
                    tmpfilter.and(new QFilter("location.id", "=", (Object)stockindexid));
                }
                if (stocksetupentryMain != null) {
                    stocksetupentryMain.or(tmpfilter);
                } else {
                    stocksetupentryMain = tmpfilter;
                }
                ++n;
            }
            rowcount = n;
        } else {
            sitebasedata = "stocksetup,entryentity.supplytype,entryentity.isselected,stockstypeentity.stocktype,stockstypeentity.ismrp,stockstatusentity.stocktype1,stockstatusentity.ismrp1,stocksetupentry,stocksetupentry.stockorg,stocksetupentry.stockorg.id,stocksetupentry.stocknumber,stocksetupentry.stocknumber.id,stocksetupentry.stockindex,stocksetupentry.stockindex.id";
            DynamicObject basedataInfo = BusinessDataServiceHelper.loadSingle((String)"mds_sitebasedata", (String)sitebasedata, (QFilter[])filters);
            DynamicObjectCollection stocksetupentry = basedataInfo.getDynamicObjectCollection("stocksetupentry");
            rowcount = stocksetupentry.size();
            stocksetup = basedataInfo.getString("stocksetup");
            for (int n = 0; n < stocksetupentry.size(); ++n) {
                DynamicObject stockindex;
                DynamicObject stocknumber;
                tmpfilter = new QFilter("org.id", "is not null", (Object)"1=1");
                DynamicObject obj = (DynamicObject)stocksetupentry.get(n);
                DynamicObject stockorg = obj.getDynamicObject("stockorg");
                if (stockorg != null) {
                    tmpfilter.and(new QFilter("org.id", "=", stockorg.getPkValue()));
                }
                if ((stocknumber = obj.getDynamicObject("stocknumber")) != null) {
                    tmpfilter.and(new QFilter("warehouse.id", "=", stocknumber.getPkValue()));
                }
                if ((stockindex = obj.getDynamicObject("stockindex")) != null) {
                    tmpfilter.and(new QFilter("location.id", "=", stockindex.getPkValue()));
                }
                if (stocksetupentryMain != null) {
                    stocksetupentryMain.or(tmpfilter);
                    continue;
                }
                stocksetupentryMain = tmpfilter;
            }
        }
        if (stocksetupentryMain != null) {
            stocksetupentryMain.and(new QFilter("material.id", "=", (Object)materialid));
        } else {
            stocksetupentryMain = new QFilter("material.id", "=", (Object)materialid);
        }
        if (!"1".equals(stocksetup)) {
            HashSet<Long> balanceId = new HashSet<Long>();
            DataSet balancedataSet = MDSUtils.loadCacheDatas(snapshotschemeid, "im_inv_realbalance", "id", new QFilter[]{stocksetupentryMain});
            if (balancedataSet != null) {
                for (Row row : balancedataSet) {
                    balanceId.add(row.getLong("id"));
                }
            } else {
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"im_inv_realbalance", (String)"id", (QFilter[])new QFilter[]{stocksetupentryMain});
                for (DynamicObject obj : coll) {
                    balanceId.add(obj.getLong("id"));
                }
            }
            stocksetupentryMain = new QFilter("org.id", "is not null", (Object)"1=1");
            if (rowcount > 0) {
                if ("2".equals(stocksetup)) {
                    stocksetupentryMain.and(new QFilter("id", "in", balanceId));
                } else if ("3".equals(stocksetup)) {
                    stocksetupentryMain.and(new QFilter("id", "not in", balanceId));
                }
            } else {
                stocksetupentryMain.and(new QFilter("material.id", "=", (Object)materialid));
                if ("2".equals(stocksetup)) {
                    stocksetupentryMain.and(new QFilter("id", "=", (Object)this.nocanuselong));
                } else if ("3".equals(stocksetup)) {
                    stocksetupentryMain.and(new QFilter("id", "!=", (Object)this.nocanuselong));
                }
            }
        }
        logger.warn("\u7269\u6599\uff1a" + materialid + "\u67e5\u8be2\u5230\u7684\u5e93\u5b58\u4ed3\u5e93\u6761\u4ef6\u4e3a\uff1a" + stocksetupentryMain == null ? "" : stocksetupentryMain.toString());
        return new QFilter[]{stocksetupentryMain};
    }
}

