/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dspsite.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.dspsite.DPSSiteMaterialBO;
import kd.mmc.mds.common.dspsite.ISupplyDataByMaterialID;
import kd.mmc.mds.common.util.MDSUtils;
import kd.mmc.mds.common.util.SliceUtil;

public class WIPSupplyDataImpl
implements ISupplyDataByMaterialID {
    @Override
    public List<JSONObject> getData(DPSSiteMaterialBO bo, Long materialid, Long basedataid, Integer priority) {
        HashSet<Long> transpks;
        String sitebasedata = "transactproduct.fbasedataid,stocksetup,entryentity.supplytype,entryentity.isselected,stockstypeentity.stocktype,stockstypeentity.ismrp,stockstatusentity.stocktype1,stockstatusentity.ismrp1,stocksetupentry.stockorg,stocksetupentry.stocknumber,stocksetupentry.stockindex,billstatuscheckbox";
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
        bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u6b63\u5728\u67e5\u8be2\u5de5\u5355\u6570\u636e\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"WIPSupplyDataImpl_0", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter basedataFilter = new QFilter("id", "=", (Object)basedataid);
        DataSet dataSet = MDSUtils.loadCacheDatas(bo.getSnapshotschemeid(), "mds_sitebasedata", sitebasedata, new QFilter[]{basedataFilter});
        if (dataSet != null) {
            Iterator iter = dataSet.iterator();
            transpks = new HashSet<Long>(100);
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                transpks.add(row.getLong("transactproduct.fbasedataid"));
            }
            qFilters.add(new QFilter("transactiontype", "in", transpks));
        } else {
            DynamicObjectCollection transactproducts = QueryServiceHelper.query((String)"mds_sitebasedata", (String)sitebasedata, (QFilter[])new QFilter[]{basedataFilter});
            if (transactproducts != null) {
                transpks = new HashSet(100);
                for (int n = 0; n < transactproducts.size(); ++n) {
                    transpks.add(((DynamicObject)transactproducts.get(n)).getLong("transactproduct.fbasedataid"));
                }
                qFilters.add(new QFilter("transactiontype", "in", transpks));
            }
        }
        qFilters.add(new QFilter("treeentryentity.material.masterid", "=", (Object)materialid));
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        DataSet mftdataSet = MDSUtils.loadCacheDatas(bo.getSnapshotschemeid(), "pom_mftorder", this.getMftoderSelections(), qFilters.toArray(new QFilter[0]));
        if (mftdataSet != null) {
            for (Row row : mftdataSet) {
                String billno = row.getString("billno");
                Integer seq = row.getInteger("treeentryentity.seq");
                BigDecimal qty = row.getBigDecimal("treeentryentity.qty");
                BigDecimal quainwaqty = row.getBigDecimal("treeentryentity.quainwaqty");
                BigDecimal unquainwaqty = row.getBigDecimal("treeentryentity.unquainwaqty");
                BigDecimal scrinwaqty = row.getBigDecimal("treeentryentity.scrinwaqty");
                BigDecimal makeqty = qty.subtract(quainwaqty).subtract(unquainwaqty).subtract(scrinwaqty);
                Long planendtime = SliceUtil.getDateLong(row.getDate("treeentryentity.planendtime"));
                Long org = row.getLong("org.id");
                JSONObject wipobj = new JSONObject();
                wipobj.put("BASEQTY", (Object)makeqty);
                wipobj.put("treeentryentity.planendtime", (Object)planendtime);
                wipobj.put("ORG", (Object)org);
                wipobj.put("billno", (Object)billno);
                wipobj.put("seq", (Object)seq);
                wipobj.put("TYPE", (Object)"WIP");
                wipobj.put("PRIORITY", (Object)priority);
                resultList.add(wipobj);
            }
        } else {
            DynamicObjectCollection queryList = QueryServiceHelper.query((String)"pom_mftorder", (String)this.getMftoderSelections(), (QFilter[])qFilters.toArray(new QFilter[0]), (String)"treeentryentity.planendtime");
            for (DynamicObject mftorder : queryList) {
                String billno = mftorder.getString("billno");
                Integer seq = mftorder.getInt("treeentryentity.seq");
                BigDecimal qty = mftorder.getBigDecimal("treeentryentity.qty");
                BigDecimal quainwaqty = mftorder.getBigDecimal("treeentryentity.quainwaqty");
                BigDecimal unquainwaqty = mftorder.getBigDecimal("treeentryentity.unquainwaqty");
                BigDecimal scrinwaqty = mftorder.getBigDecimal("treeentryentity.scrinwaqty");
                BigDecimal makeqty = qty.subtract(quainwaqty).subtract(unquainwaqty).subtract(scrinwaqty);
                Long planendtime = SliceUtil.getDateLong(mftorder.getDate("treeentryentity.planendtime"));
                Long org = mftorder.getLong("org.id");
                JSONObject wipobj = new JSONObject();
                wipobj.put("BASEQTY", (Object)makeqty);
                wipobj.put("treeentryentity.planendtime", (Object)planendtime);
                wipobj.put("ORG", (Object)org);
                wipobj.put("billno", (Object)billno);
                wipobj.put("seq", (Object)seq);
                wipobj.put("TYPE", (Object)"WIP");
                wipobj.put("PRIORITY", (Object)priority);
                resultList.add(wipobj);
            }
        }
        SliceUtil.sortComposeColl(resultList, "treeentryentity.planendtime", "BASEQTY");
        bo.getLogger().createStepLog(false, ResManager.loadKDString((String)"\u67e5\u8be2\u5de5\u5355\u6570\u636e\u5df2\u7ed3\u675f\u3002", (String)"WIPSupplyDataImpl_1", (String)"mmc-mds-common", (Object[])new Object[0]), "", "");
        return resultList;
    }

    private String getMftoderSelections() {
        return "billno,org.id,treeentryentity.planendtime,treeentryentity.seq,treeentryentity.qty,treeentryentity.quainwaqty,treeentryentity.unquainwaqty,treeentryentity.scrinwaqty";
    }
}

