/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.dspsite.mqmodel;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mmc.mds.common.dspsite.DPSSiteTaskResult;
import kd.mmc.mds.common.dspsite.mqmodel.DPSSiteCallable;
import kd.mmc.mds.common.util.MDSUtils;
import kd.mmc.mds.common.util.SliceUtil;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTaskEvent;

public class DPSSiteEvent
implements BatchTaskEvent {
    private static ExecutorService exec = ThreadPools.newCachedExecutorService((String)"MDS_DPS_SITE", (int)5, (int)10);

    public void execute(Map params) throws KDException {
        List materialIdSlices = (List)params.get("materialIdSlices");
        Long dpssiteexecid = (Long)params.get("dpssiteexecid");
        Long starttime = (Long)params.get("starttime");
        Long dpssiteschemeid = (Long)params.get("dpssiteschemeid");
        QFilter filter = new QFilter("id", "=", (Object)dpssiteschemeid);
        String selectFields = "dataversion.id,salorderst.id,sitebasedata.id,isquota,dummysite.id,materialgroup,setoffsetting.id";
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject def = BusinessDataServiceHelper.loadSingle((String)"mds_siteschemedef", (String)selectFields, (QFilter[])filters);
        int dpssiteworkers = Integer.parseInt(MDSUtils.getMdsSysConfig("dpssiteworkers", "3"));
        int slicesSize = this.getSlicesSize(materialIdSlices.size(), dpssiteworkers);
        List slices = SliceUtil.slice(new ArrayList(materialIdSlices), slicesSize);
        LinkedList<Future<DPSSiteTaskResult>> futures = new LinkedList<Future<DPSSiteTaskResult>>();
        for (List list : slices) {
            DPSSiteCallable dPSSiteCallable = new DPSSiteCallable(dpssiteexecid, starttime, def, list, RequestContext.get());
            Future<DPSSiteTaskResult> future = exec.submit(dPSSiteCallable);
            futures.add(future);
        }
        StringBuilder errMsg = new StringBuilder();
        for (Future future : futures) {
            try {
                DPSSiteTaskResult result = (DPSSiteTaskResult)future.get();
                if (result.isOK()) continue;
                errMsg.append(result.getMsg()).append("\r\n");
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u7ebf\u7a0b\u6267\u884c\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f:%s", (String)"DPSSiteEvent_1", (String)"mmc-mds-common", (Object[])new Object[0]), e.getMessage()));
            }
        }
        if (errMsg.length() > 0) {
            throw new KDBizException(errMsg.toString());
        }
    }

    private int getSlicesSize(int total, int dpssiteworkers) {
        if (dpssiteworkers <= 1) {
            return total;
        }
        if (total < dpssiteworkers) {
            return total;
        }
        if (total % dpssiteworkers == 0) {
            return total / dpssiteworkers;
        }
        return (total + dpssiteworkers) / dpssiteworkers;
    }
}

