/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.export;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;
import kd.mmc.mds.common.export.model.ExportField;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExportHelper {
    public static void writerSheet(Workbook wb, Sheet sheet, DataSet dataSet, List<ExportField> exportFields) {
        DataFormat dataFormat = wb.createDataFormat();
        HashMap<String, CellStyle> dataFormatMap = new HashMap<String, CellStyle>();
        int[] widthArr = new int[exportFields.size()];
        Row nameRow = sheet.createRow(0);
        int nameCellIndex = 0;
        CellStyle style = wb.createCellStyle();
        style.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        for (ExportField field : exportFields) {
            String v = field.getFieldShowName();
            int defColWidth = sheet.getColumnWidth(nameCellIndex);
            widthArr[nameCellIndex] = ExportHelper.calcColumnWidth(v, defColWidth);
            Cell c = nameRow.createCell(nameCellIndex);
            c.setCellStyle(style);
            c.setCellValue(v);
            ++nameCellIndex;
        }
        CellStyle textStyle = wb.createCellStyle();
        textStyle.setDataFormat(dataFormat.getFormat("@"));
        int rowIndex = 1;
        for (kd.bos.algo.Row row : dataSet) {
            Row cells = sheet.createRow(rowIndex);
            int cellIndex = 0;
            for (ExportField field : exportFields) {
                String type = field.getFieldType();
                String fieldName = field.getFieldName();
                String fieldFormat = field.getFieldFormat();
                Cell c = cells.createCell(cellIndex);
                String valueStr = "";
                if ("1".equals(type)) {
                    valueStr = row.getString(fieldName);
                    c.setCellValue(valueStr);
                    c.setCellStyle(textStyle);
                } else if ("2".equals(type)) {
                    SimpleDateFormat sdf = new SimpleDateFormat(fieldFormat);
                    Date date = row.getDate(fieldName);
                    String dateStr = "";
                    if (date != null) {
                        dateStr = sdf.format(date);
                    }
                    valueStr = dateStr;
                    c.setCellValue(dateStr);
                    c.setCellStyle(textStyle);
                } else if ("3".equals(type)) {
                    CellStyle qtyStyle;
                    String format = "#,##0.00";
                    if (StringUtils.isNotEmpty((CharSequence)fieldFormat)) {
                        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), fieldFormat)) {
                            Integer precision = row.getInteger(fieldFormat);
                            if (precision != null) {
                                format = format.replaceAll("\\.00", precision > 0 ? String.format(".%0" + precision + "d", 0) : "");
                            }
                        } else {
                            format = fieldFormat;
                        }
                    }
                    if ((qtyStyle = (CellStyle)dataFormatMap.get(format)) == null) {
                        qtyStyle = wb.createCellStyle();
                        short s = dataFormat.getFormat(format);
                        qtyStyle.setDataFormat(s);
                        dataFormatMap.put(format, qtyStyle);
                    }
                    double v = 0.0;
                    BigDecimal qty = row.getBigDecimal(fieldName);
                    if (qty != null) {
                        v = qty.doubleValue();
                        long lv = qty.longValue();
                        String str = String.valueOf(lv);
                        valueStr = str + format;
                    }
                    c.setCellValue(v);
                    c.setCellStyle(qtyStyle);
                } else if ("4".equals(type)) {
                    c.setCellValue(row.getBoolean(fieldName).booleanValue());
                    c.setCellStyle(textStyle);
                }
                int defColWidth = widthArr[cellIndex];
                widthArr[cellIndex] = ExportHelper.calcColumnWidth(valueStr, defColWidth);
                ++cellIndex;
            }
            ++rowIndex;
        }
        for (int i = 0; i < widthArr.length; ++i) {
            sheet.setColumnWidth(i, widthArr[i]);
        }
    }

    public static int calcColumnWidth(String caption, int defColWidth) {
        if (StringUtils.isEmpty((CharSequence)caption)) {
            return defColWidth;
        }
        int colWidth = 0;
        try {
            colWidth = 256 * (caption.getBytes("GBK").length + 12);
        }
        catch (UnsupportedEncodingException e) {
            colWidth = 256 * (caption.getBytes(StandardCharsets.UTF_8).length + 8);
        }
        colWidth = Math.max(defColWidth, colWidth);
        return Math.min(colWidth, 51200);
    }
}

