/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.impl;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.itf.IMDSExecuteLogRecorder;

public class KDCloudMdsLogRecorder
implements IMDSExecuteLogRecorder {
    private ORM orm;
    private DynamicObject runLog;
    private DynamicObject entryLogInfo;
    private ArrayList<DynamicObject> subs = new ArrayList();
    private static final Log logger = LogFactory.getLog(KDCloudMdsLogRecorder.class);

    public KDCloudMdsLogRecorder(ORM orm, DynamicObject runLog) {
        this.orm = orm;
        this.runLog = runLog;
    }

    @Override
    public void updateRunLog(String key, Object value) {
        this.runLog.set(key, value);
    }

    @Override
    public void createStepLog(int stepIdx, String stepDesc, long currenttime, DynamicObject obj, boolean issuccess) {
        long endtime = System.currentTimeMillis();
        BigDecimal seconds = BigDecimal.valueOf(endtime - currenttime).divide(BigDecimal.valueOf(1000L), new MathContext(12));
        this.entryLogInfo = this.orm.newDynamicObject("mds_planexec.execlogeentry");
        this.entryLogInfo.setParent((Object)this.runLog);
        this.entryLogInfo.set("seq", (Object)String.valueOf(stepIdx));
        this.entryLogInfo.set("entrystepseq", (Object)String.valueOf(stepIdx));
        this.entryLogInfo.set("entrystepname", (Object)stepDesc);
        this.entryLogInfo.set("entryresult", (Object)(issuccess ? ResManager.loadKDString((String)"\u6210\u529f", (String)"KDCloudMdsLogRecorder_0", (String)"mmc-mds-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9519\u8bef", (String)"KDCloudMdsLogRecorder_1", (String)"mmc-mds-common", (Object[])new Object[0])));
        if (!issuccess) {
            this.entryLogInfo.set("entrydetailmsg", obj.get("runninglog_tag"));
        }
        this.entryLogInfo.set("entryoperatmin", (Object)seconds);
        this.saveStepLog();
    }

    @Override
    public int getLogIdx() {
        return this.entryLogInfo.getInt("entrystepseq");
    }

    @Override
    public void saveStepLog() {
        DynamicObjectCollection collection = this.runLog.getDynamicObjectCollection("execlogeentry");
        if (collection == null) {
            collection = new DynamicObjectCollection(this.entryLogInfo.getDynamicObjectType(), (Object)this.runLog);
            this.runLog.set("entryentity", (Object)collection);
        }
        if (this.entryLogInfo != null) {
            collection.add((Object)this.entryLogInfo);
        }
        if (!this.subs.isEmpty()) {
            for (DynamicObject dynamicObject : this.subs) {
                collection.add((Object)dynamicObject);
            }
        }
        try {
            Throwable throwable = null;
            try (TXHandle h1 = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.runLog});
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        BaseDataServiceHelper.clearCache((DynamicObject)this.runLog);
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        String string = "mds_planexec" + this.runLog.getString("createorg");
        BaseDataCtrlCacheMrg.clearCache((String)type, (String)string);
        this.entryLogInfo = null;
        this.subs.clear();
    }

    @Override
    public void updateStepLog(String key, Object value) {
        this.entryLogInfo.set(key, value);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.runLog});
    }

    @Override
    public void createSubStepLog(int stepIdx, String stepDesc, int parentStepLevel) {
        DynamicObject logInfo = this.orm.newDynamicObject("mds_planexec.execlogeentry");
        logInfo.setParent((Object)this.runLog);
        logInfo.set("entrystepseq", (Object)(String.valueOf(parentStepLevel) + "-" + String.valueOf(stepIdx)));
        logInfo.set("entrystepname", (Object)stepDesc);
        logInfo.set("entryprocessdata", (Object)0);
        this.subs.add(logInfo);
    }

    @Override
    public void updateSubStepLog(int stepIdx, String key, Object value) {
        DynamicObject logInfo = this.subs.get(stepIdx);
        logInfo.set(key, value);
    }

    @Override
    public Date getLogStartDate() {
        return this.runLog.getDate("startdate");
    }

    @Override
    public String getLogEntryStatus() {
        return this.entryLogInfo.getString("entryresult");
    }

    @Override
    public void initMDSRunLog() {
        if (this.runLog.getString("id") == null) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.runLog});
        } else {
            this.runLog.getDynamicObjectCollection("execlogeentry").clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.runLog});
        }
    }
}

