/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.impl;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Calendar;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;

public class KDCloudMdsNewLogRecorder {
    private static final Log logger = LogFactory.getLog(KDCloudMdsNewLogRecorder.class);
    public static final DBRoute pur = new DBRoute("pur");
    public static final ORM orm = ORM.create();
    private Integer index = 1;
    private Long entryparentid = 0L;
    private Long parentid = null;
    private Long inittime = null;
    private Long pretime = 0L;
    private String addsql = "insert into t_mds_dpstreelogeentry(fid,fentryid,fseq,fparententryid,fentrytreeseq,fentrytreename,fentrytreeoperatmin,fentrytreeresult,fentrytreedetailmsg) values(?,?,?,?,?,?,?,?,?)";
    private String updatesql = "update t_mds_dpstreelogeentry set fentrytreeresult = ?,fentrytreeoperatmin = ?,fentrytreedetailmsg = ? where fid = ? and fentryid = ?";
    private String updateMainSql = "update t_mds_dpsplanexec set fenddate = ?,fsummin = ? where fid = ?";

    public KDCloudMdsNewLogRecorder(Long _parentid, Long _inittime) {
        this.parentid = _parentid;
        this.inittime = _inittime;
    }

    public Long genLong() {
        return orm.genLongId("mds_dpsplanexec");
    }

    public void initMDSRunLog(String descinfo) {
        try (TXHandle h1 = TX.requiresNew();){
            this.entryparentid = this.genLong();
            Object[] objs = new Object[]{this.parentid, this.entryparentid, 3, 0, 3, descinfo, 0, "", ""};
            DB.execute((DBRoute)pur, (String)this.addsql, (Object[])objs);
            this.pretime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            logger.error("\u521d\u59cb\u5316\u7269\u6599\u5f00\u59cb\u65f6\u95f4\u51fa\u9519" + ex.getMessage());
        }
    }

    public void initMDSRunLog(String descinfo, int seq) {
        try (TXHandle h1 = TX.requiresNew();){
            this.entryparentid = this.genLong();
            Object[] objs = new Object[]{this.parentid, this.entryparentid, seq, 0, seq, descinfo, 0, "", ""};
            DB.execute((DBRoute)pur, (String)this.addsql, (Object[])objs);
            this.pretime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            logger.error("\u521d\u59cb\u5316\u7269\u6599\u5f00\u59cb\u65f6\u95f4\u51fa\u9519" + ex.getMessage());
        }
    }

    public void initMDSRunLogWithErrorInfo(String descinfo, int seq, String errorInfo) {
        try (TXHandle h1 = TX.requiresNew();){
            this.entryparentid = this.genLong();
            Object[] objs = new Object[]{this.parentid, this.entryparentid, seq, 0, seq, descinfo, 0, "", errorInfo};
            DB.execute((DBRoute)pur, (String)this.addsql, (Object[])objs);
            this.pretime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            logger.error("\u521d\u59cb\u5316\u7269\u6599\u5f00\u59cb\u65f6\u95f4\u51fa\u9519" + ex.getMessage());
        }
    }

    public Integer getIndex() {
        Integer n = this.index;
        Integer n2 = this.index = Integer.valueOf(this.index + 1);
        return n;
    }

    public void updateResultLog(String result, String errorinfo) {
        try (TXHandle h1 = TX.requiresNew();){
            Long currtime = System.currentTimeMillis();
            BigDecimal suminterval = BigDecimal.valueOf(currtime - this.inittime).divide(BigDecimal.valueOf(1000L), new MathContext(12));
            BigDecimal stepinterval = BigDecimal.valueOf(currtime - this.pretime).divide(BigDecimal.valueOf(1000L), new MathContext(12));
            if (errorinfo == null) {
                errorinfo = ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"KDCloudMdsNewLogRecorder_0", (String)"mmc-mds-common", (Object[])new Object[0]);
            }
            Object[] objs = new Object[]{result, stepinterval, errorinfo, this.parentid, this.entryparentid};
            Object[] mainobjs = new Object[]{Calendar.getInstance().getTime(), suminterval, this.parentid};
            DB.execute((DBRoute)pur, (String)this.updatesql, (Object[])objs);
            DB.execute((DBRoute)pur, (String)this.updateMainSql, (Object[])mainobjs);
        }
        catch (Exception ex) {
            logger.error("\u66f4\u65b0\u7269\u6599\u5f00\u59cb\u65f6\u95f4\u51fa\u9519" + ex.getMessage());
        }
    }

    public void createStepLog(boolean isParentLog, String stepDesc, String resultinfo, String exceptionInfo) {
        BigDecimal interval = BigDecimal.valueOf(System.currentTimeMillis() - this.pretime).divide(BigDecimal.valueOf(1000L), new MathContext(12));
        try (TXHandle h1 = TX.requiresNew();){
            Object[] objs;
            if (isParentLog) {
                objs = new Object[]{this.parentid, this.genLong(), 1, this.entryparentid, this.getIndex(), stepDesc, interval, resultinfo, ""};
                DB.execute((DBRoute)pur, (String)this.addsql, (Object[])objs);
            } else {
                objs = new Object[]{this.parentid, this.genLong(), 1, this.entryparentid, this.getIndex(), stepDesc, interval, "", exceptionInfo};
                DB.execute((DBRoute)pur, (String)this.addsql, (Object[])objs);
            }
            this.pretime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            logger.error("\u521b\u5efa\u7269\u6599\u5f00\u59cb\u65f6\u95f4\u51fa\u9519" + ex.getMessage());
        }
    }
}

