/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.plandata.PlanDataFieldsSetter;
import kd.mmc.mds.common.tranplan.PlanDataToFcDataSyncResult;

public class PlanDataToFcDataSyncTask {
    private static final Log log = LogFactory.getLog(PlanDataToFcDataSyncTask.class);
    private static final DBRoute pur = new DBRoute("pur");
    private Long zeroL = 0L;
    private String verType = "0";

    public PlanDataToFcDataSyncResult handle(String version, String[] uniquekey, Set<Long> materialList) {
        log.info("\u540c\u6b65\u7248\u672c\uff1a" + version + "\u7269\u6599\uff1a" + materialList);
        QFilter filter = new QFilter("fcvrnnum.number", "=", (Object)version);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)this.getHeadSelectField(), (QFilter[])filters);
        if (obj != null) {
            this.verType = obj.getString("fcvrnnum.vertype");
        }
        if (materialList != null && !materialList.isEmpty()) {
            log.info("\u540c\u6b65\u7248\u672c\uff1a" + version + "queryPlanData\uff1a\u5f00\u59cb");
            Map<String, Map<String, Object>> sourceObject = this.queryPlanData(version, uniquekey, materialList);
            log.info("\u540c\u6b65\u7248\u672c\uff1a" + version + "queryPlanData\uff1a\u7ed3\u675f");
            log.info("\u540c\u6b65\u7248\u672c\uff1a" + version + "queryFcData\uff1a\u5f00\u59cb");
            Map<String, List<Map<String, Object>>> targetObject = this.queryFcData(version, uniquekey, materialList);
            log.info("\u540c\u6b65\u7248\u672c\uff1a" + version + "queryFcData\uff1a\u7ed3\u675f");
            log.info("\u540c\u6b65\u7248\u672c\uff1a" + version + "updateFcData\uff1a\u5f00\u59cb");
            this.updateFcData(sourceObject, targetObject);
            log.info("\u540c\u6b65\u7248\u672c\uff1a" + version + "updateFcData\uff1a\u7ed3\u675f");
        }
        return PlanDataToFcDataSyncResult.ok;
    }

    public String getHeadSelectField() {
        return "fcvrnnum.id,fcvrnnum.number,fcvrnnum.cytype,org.id,billstatus,invaldate,enablestatus";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Object>> queryPlanData(String version, String[] uniquekey, Set<Long> materialList) {
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
        QFilter filter = new QFilter("fcvrnnum.number", "=", (Object)version);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)this.getHeadSelectField(), (QFilter[])filters);
        HashMap<String, Object> sourcehead = new HashMap<String, Object>();
        sourcehead.put("CYTYPE", obj.getString("fcvrnnum.cytype"));
        sourcehead.put("ID", obj.getPkValue());
        resultMap.put("SOURCEHEAD", sourcehead);
        String queryDataSql = "select ffieldkey,ftargetdate from t_mds_dateentry where fid = ? and fdeliverycolumn = '0' ";
        DataSet datasetData = DB.queryDataSet((String)"queryPlanDateTab", (DBRoute)pur, (String)queryDataSql, (Object[])new Object[]{obj.getPkValue()});
        Iterator iterator = datasetData.iterator();
        HashMap<String, Date> fieldMap = new HashMap<String, Date>();
        List<String> deskFieldsAlias = PlanDataFieldsSetter.getSyncFieldsAlias(this.verType);
        ArrayList<String> allFieldsAlias = new ArrayList<String>(deskFieldsAlias);
        try {
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String fieldkey = row.getString("ffieldkey");
                Date targetdate = row.getDate("ftargetdate");
                fieldkey = "f" + fieldkey;
                allFieldsAlias.add(fieldkey);
                fieldMap.put(fieldkey, targetdate);
            }
        }
        finally {
            datasetData.close();
        }
        HashSet<String> materialStr = new HashSet<String>(100);
        Iterator<Long> iter = materialList.iterator();
        while (iter.hasNext()) {
            materialStr.add(String.valueOf(iter.next()));
        }
        StringBuilder queryMainSql = new StringBuilder();
        queryMainSql.append("select ").append(String.join((CharSequence)",", allFieldsAlias)).append(" from t_mds_fcdatatsentry where fid = '").append(obj.getPkValue()).append("' and fmaterialid in (").append(String.join((CharSequence)",", materialStr)).append(')');
        DataSet queryMainData = DB.queryDataSet((String)"queryPlanData", (DBRoute)pur, (String)queryMainSql.toString());
        GroupbyDataSet groupbyDataSet = queryMainData.groupBy(deskFieldsAlias.toArray(new String[0]));
        for (Map.Entry fieldKeyObj : fieldMap.entrySet()) {
            String fieldkey = (String)fieldKeyObj.getKey();
            groupbyDataSet = groupbyDataSet.sum(fieldkey);
        }
        queryMainData = groupbyDataSet.finish();
        Iterator iteratorMain = queryMainData.iterator();
        StringBuilder dimkey = new StringBuilder();
        try {
            while (iteratorMain.hasNext()) {
                Row row = (Row)iteratorMain.next();
                Iterator fieldkeyiter = fieldMap.entrySet().iterator();
                while (fieldkeyiter.hasNext()) {
                    dimkey.setLength(0);
                    HashMap<String, Object> values = new HashMap<String, Object>(16);
                    for (String key : uniquekey) {
                        if (key.equals("fdatenode")) continue;
                        Object value = row.get(key) == null ? this.zeroL : row.get(key);
                        dimkey.append(value).append('#');
                    }
                    Map.Entry fieldKeyObj = fieldkeyiter.next();
                    String fieldkey = (String)fieldKeyObj.getKey();
                    Long date = ((Date)fieldKeyObj.getValue()).getTime();
                    dimkey.append(date);
                    values.put("QTY", row.getBigDecimal(fieldkey) == null ? BigDecimal.ZERO : row.getBigDecimal(fieldkey));
                    values.put("DATENODE", fieldKeyObj.getValue());
                    for (String fieldsAlias : deskFieldsAlias) {
                        values.put(fieldsAlias.toUpperCase(), row.get(fieldsAlias));
                    }
                    resultMap.put(dimkey.toString(), values);
                }
            }
        }
        finally {
            queryMainData.close();
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Map<String, Object>>> queryFcData(String version, String[] uniquekey, Set<Long> materialList) {
        HashMap<String, List<Map<String, Object>>> resultMap = new HashMap<String, List<Map<String, Object>>>();
        QFilter filter = new QFilter("fcvrnnum.number", "=", (Object)version);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"mds_data", (String)this.getHeadSelectField(), (QFilter[])filters);
        String metadatakey = obj.getDynamicObject("fcvrnnum.group").getString("number");
        HashMap<String, Object> sourcehead = new HashMap<String, Object>();
        sourcehead.put("ID", obj.getPkValue());
        sourcehead.put("GROUP", metadatakey);
        ArrayList<HashMap<String, Object>> tmpobjlst = new ArrayList<HashMap<String, Object>>(10);
        tmpobjlst.add(sourcehead);
        resultMap.put("SOURCEHEAD", tmpobjlst);
        List<String> backFieldsAlias = PlanDataFieldsSetter.getSyncFieldsAlias(this.verType);
        ArrayList<String> allFieldsAlias = new ArrayList<String>(backFieldsAlias);
        allFieldsAlias.add("fid");
        allFieldsAlias.add("fentryid");
        allFieldsAlias.add("fseq");
        allFieldsAlias.add("fdatenode");
        allFieldsAlias.add("ffcqty");
        HashSet<String> materialStr = new HashSet<String>(100);
        Iterator<Long> iter = materialList.iterator();
        while (iter.hasNext()) {
            materialStr.add(String.valueOf(iter.next()));
        }
        StringBuilder queryMainSql = new StringBuilder();
        queryMainSql.append("select ").append(String.join((CharSequence)",", allFieldsAlias)).append(" from T_MDS_FCDATADTLENT where fid = '").append(obj.getPkValue()).append("' and fmaterialid in (").append(String.join((CharSequence)",", materialStr)).append(')');
        DataSet queryMainData = DB.queryDataSet((String)"queryFcData", (DBRoute)pur, (String)queryMainSql.toString());
        Iterator iteratorMain = queryMainData.iterator();
        StringBuilder dimkey = new StringBuilder();
        try {
            while (iteratorMain.hasNext()) {
                dimkey.setLength(0);
                HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
                Row row = (Row)iteratorMain.next();
                for (String key : uniquekey) {
                    Object value = null;
                    if (key.equals("fdatenode")) {
                        value = row.getDate(key) == null ? this.zeroL.longValue() : row.getDate(key).getTime();
                        dimkey.append(value);
                        continue;
                    }
                    value = row.get(key) == null ? this.zeroL : row.get(key);
                    dimkey.append(value).append('#');
                }
                for (String fieldsAlias : backFieldsAlias) {
                    valueMap.put(fieldsAlias.toUpperCase(), row.get(fieldsAlias));
                }
                valueMap.put("QTY", row.getBigDecimal("ffcqty"));
                valueMap.put("DATENODE", row.getDate("fdatenode"));
                valueMap.put("ENTRYID", row.getLong("fentryid"));
                if (resultMap.get(dimkey.toString()) != null) {
                    ((List)resultMap.get(dimkey.toString())).add(valueMap);
                    continue;
                }
                ArrayList<HashMap<String, Object>> listValues = new ArrayList<HashMap<String, Object>>(2);
                listValues.add(valueMap);
                resultMap.put(dimkey.toString(), listValues);
            }
        }
        finally {
            queryMainData.close();
        }
        return resultMap;
    }

    public void updateFcData(Map<String, Map<String, Object>> sourceobj, Map<String, List<Map<String, Object>>> targetobj) {
        ORM orm = ORM.create();
        HashSet<String> addset = new HashSet<String>();
        HashSet<String> updateset = new HashSet<String>();
        HashSet<String> delset = new HashSet<String>();
        Set<String> sourcepks = sourceobj.keySet();
        Set<String> targetpks = targetobj.keySet();
        for (String string : sourcepks) {
            if (targetpks.contains(string)) {
                updateset.add(string);
                continue;
            }
            addset.add(string);
        }
        for (String string : targetpks) {
            if (sourcepks.contains(string)) continue;
            delset.add(string);
        }
        ArrayList<Object[]> delparamsList = new ArrayList<Object[]>();
        for (String string : delset) {
            List<Map<String, Object>> valueList = targetobj.get(string);
            for (Map<String, Object> valueMap : valueList) {
                Object[] obj = new Object[]{valueMap.get("ENTRYID")};
                delparamsList.add(obj);
            }
        }
        if (delparamsList.size() > 0) {
            String string = "delete from T_MDS_FCDATADTLENT where fentryid = ? ";
            log.info("\u540c\u6b65\u7248\u672c\uff1adeletesql " + string + "delparamsList\uff1a" + delparamsList);
            DB.executeBatch((DBRoute)pur, (String)string, delparamsList);
            log.info("\u540c\u6b65\u7248\u672c\uff1adeletesql \u7ed3\u675f");
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1000);
        List<Map<String, Object>> list = targetobj.get("SOURCEHEAD");
        Map<String, Object> sourceHeadObj = sourceobj.get("SOURCEHEAD");
        long[] ids = orm.genLongIds("mds_data", addset.size());
        int index = 0;
        List<String> backFieldsAlias = PlanDataFieldsSetter.getSyncFieldsAlias(this.verType);
        ArrayList<String> allFieldsAlias = new ArrayList<String>(16);
        allFieldsAlias.add("fid");
        allFieldsAlias.add("fentryid");
        allFieldsAlias.add("fseq");
        allFieldsAlias.add("fcycletyped");
        allFieldsAlias.add("fdatenode");
        allFieldsAlias.add("ffcqty");
        allFieldsAlias.addAll(backFieldsAlias);
        for (String string : addset) {
            Map<String, Object> addMap = sourceobj.get(string);
            ArrayList<Object> paramList = new ArrayList<Object>(16);
            paramList.add(list.get(0).get("ID"));
            paramList.add(ids[index]);
            paramList.add(0);
            paramList.add(sourceHeadObj.get("CYTYPE"));
            paramList.add(addMap.get("DATENODE"));
            paramList.add(addMap.get("QTY"));
            for (String fieldsAlias : backFieldsAlias) {
                paramList.add(addMap.get(fieldsAlias.toUpperCase()));
            }
            Object[] param = paramList.toArray(new Object[0]);
            arrayList.add(param);
            ++index;
        }
        if (arrayList.size() > 0) {
            String addsql = this.buildAddSql(allFieldsAlias);
            log.info("\u540c\u6b65\u7248\u672c\uff1aaddsql " + addsql + "addParamsList\uff1a" + arrayList);
            DB.executeBatch((DBRoute)pur, (String)addsql, arrayList);
            log.info("\u540c\u6b65\u7248\u672c\uff1aaddsql \u7ed3\u675f");
        }
        ArrayList<Object[]> updateParamsList = new ArrayList<Object[]>(1000);
        for (String pk : updateset) {
            Map<String, Object> updateMap = sourceobj.get(pk);
            if (updateMap.get("QTY") == null) continue;
            ArrayList<Object[]> delparamsList2 = new ArrayList<Object[]>();
            List<Map<String, Object>> targetobjList = targetobj.get(pk);
            if (targetobjList != null && !targetobjList.isEmpty()) {
                for (int i = 0; i < targetobjList.size(); ++i) {
                    Map<String, Object> valuetarget = targetobj.get(pk).get(i);
                    if (i == 0) {
                        ArrayList<Object> paramList = new ArrayList<Object>(16);
                        paramList.add(list.get(0).get("ID"));
                        paramList.add(valuetarget.get("ENTRYID"));
                        paramList.add(0);
                        paramList.add(sourceHeadObj.get("CYTYPE"));
                        paramList.add(updateMap.get("DATENODE"));
                        paramList.add(updateMap.get("QTY"));
                        for (String fieldsAlias : backFieldsAlias) {
                            paramList.add(updateMap.get(fieldsAlias.toUpperCase()));
                        }
                        paramList.add(valuetarget.get("ENTRYID"));
                        Object[] obj = paramList.toArray(new Object[0]);
                        updateParamsList.add(obj);
                        continue;
                    }
                    Object[] obj = new Object[]{valuetarget.get("ENTRYID")};
                    delparamsList2.add(obj);
                }
            }
            if (delparamsList2.size() <= 0) continue;
            String deletesql = "delete from T_MDS_FCDATADTLENT where fentryid = ? ";
            log.info("\u540c\u6b65\u7248\u672c\uff1adeletesql " + deletesql + "delparamsList2\uff1a" + delparamsList2);
            this.executeBatch(pur, deletesql, delparamsList2);
            log.info("\u540c\u6b65\u7248\u672c\uff1adeletesql \u7ed3\u675f");
        }
        if (updateParamsList.size() > 0) {
            String string = this.buildUpdateSql(allFieldsAlias);
            log.info("\u540c\u6b65\u7248\u672c\uff1aupdatesql " + string + "updateParamsList\uff1a" + updateParamsList);
            DB.executeBatch((DBRoute)pur, (String)string, updateParamsList);
            log.info("\u540c\u6b65\u7248\u672c\uff1aupdatesql \u7ed3\u675f");
        }
    }

    private String buildUpdateSql(List<String> allFieldsAliasForUpdate) {
        String updatesql = "update T_MDS_FCDATADTLENT set %s where fentryid = ? ";
        String sql = String.format(updatesql, allFieldsAliasForUpdate.stream().map(o -> o + "=?").collect(Collectors.joining(", ")));
        return sql;
    }

    private String buildAddSql(List<String> allFieldsAlias) {
        String addsql = "insert into t_mds_fcdatadtlent(%s)values(%s)";
        String sql = String.format(addsql, String.join((CharSequence)",", allFieldsAlias), allFieldsAlias.stream().map(o -> "?").collect(Collectors.joining(",")));
        return sql;
    }

    private void executeBatch(DBRoute pur, String deletesql, List<Object[]> delparamsList2) {
        DB.executeBatch((DBRoute)pur, (String)deletesql, delparamsList2);
    }
}

