/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.impl;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.mmc.mds.common.impl.PlanDataToFcDataSeqTask;
import kd.mmc.mds.common.impl.PlanDataToFcDataSyncTask;
import kd.mmc.mds.common.util.PlanDataToFcDataTranUtil;
import kd.mmc.mds.common.util.SliceUtil;

public class PlanDataToFcDataTask
implements Callable<String> {
    private static Log log = LogFactory.getLog(PlanDataToFcDataTranUtil.class);
    private static ExecutorService exec = ThreadPools.newCachedExecutorService((String)("MDS_TRAN_" + UUID.randomUUID()), (int)5, (int)10);
    private String version = null;
    private Object logid = null;
    private RequestContext recon = null;

    public PlanDataToFcDataTask(String _version, Object _logid, RequestContext _recon) {
        this.version = _version;
        this.logid = _logid;
        this.recon = _recon;
    }

    @Override
    public String call() throws Exception {
        this.process();
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean process() {
        boolean isSuccessed;
        block18: {
            log.info("\u8ba1\u5212\u540c\u6b65\u5904\u7406:PlanDataToFcDataTask  call");
            RequestContext.set((RequestContext)this.recon);
            log.info("\u8ba1\u5212\u540c\u6b65\u5904\u7406:RequestContext.set(recon)");
            isSuccessed = true;
            DynamicObject logobj = BusinessDataServiceHelper.loadSingle((Object)this.logid, (String)"mds_syncplanlog");
            String[] uniquekey = PlanDataToFcDataTranUtil.getUniqueKeyByVersionInfo(this.version);
            PlanDataToFcDataTranUtil.updateFCDataHeadInfo(this.version);
            Set<Long> materialSet = PlanDataToFcDataTranUtil.queryAllMaterialInfo(this.version);
            List<Set<Long>> resultList = SliceUtil.slice(materialSet, 100);
            for (Set<Long> materialList : resultList) {
                PlanDataToFcDataSyncTask task = new PlanDataToFcDataSyncTask();
                task.handle(this.version, uniquekey, materialList);
            }
            try {
                log.info("\u8ba1\u5212\u540c\u6b65\u5904\u7406(75):\u5f00\u59cbfinally");
                log.info("\u8ba1\u5212\u540c\u6b65\u5904\u7406(77):terminate\u5b8c\u6210");
                if (isSuccessed) {
                    logobj.set("syncresult", (Object)"A");
                }
                log.info("\u8ba1\u5212\u540c\u6b65\u5904\u7406(81):\u65e5\u5fd7\u4fdd\u5b58\u5f00\u59cb");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logobj});
                log.info("\u8ba1\u5212\u540c\u6b65\u5904\u7406(81):\u65e5\u5fd7\u4fdd\u5b58\u7ed3\u675f");
            }
            catch (Exception e) {
                String errorMessge = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                if (errorMessge != null && errorMessge.length() >= 1000) {
                    errorMessge = errorMessge.substring(0, 999);
                }
                log.error("\u8ba1\u5212\u540c\u6b65\u5904\u7406(82):" + e.getMessage());
                logobj.set("errorinfo", (Object)errorMessge);
                logobj.set("syncresult", (Object)"B");
            }
            break block18;
            catch (Exception e1) {
                String errorMessge;
                try {
                    errorMessge = ExceptionUtils.getExceptionStackTraceMessage((Exception)e1);
                    if (errorMessge != null && errorMessge.length() >= 1000) {
                        errorMessge = errorMessge.substring(0, 999);
                    }
                    log.error("\u8ba1\u5212\u540c\u6b65\u5904\u7406(63):" + errorMessge);
                    logobj.set("errorinfo", (Object)errorMessge);
                    logobj.set("syncresult", (Object)"B");
                    isSuccessed = false;
                }
                catch (Throwable throwable) {
                    try {
                        log.info("\u8ba1\u5212\u540c\u6b65\u5904\u7406(75):\u5f00\u59cbfinally");
                        log.info("\u8ba1\u5212\u540c\u6b65\u5904\u7406(77):terminate\u5b8c\u6210");
                        if (isSuccessed) {
                            logobj.set("syncresult", (Object)"A");
                        }
                        log.info("\u8ba1\u5212\u540c\u6b65\u5904\u7406(81):\u65e5\u5fd7\u4fdd\u5b58\u5f00\u59cb");
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logobj});
                        log.info("\u8ba1\u5212\u540c\u6b65\u5904\u7406(81):\u65e5\u5fd7\u4fdd\u5b58\u7ed3\u675f");
                    }
                    catch (Exception e) {
                        String errorMessge2 = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                        if (errorMessge2 != null && errorMessge2.length() >= 1000) {
                            errorMessge2 = errorMessge2.substring(0, 999);
                        }
                        log.error("\u8ba1\u5212\u540c\u6b65\u5904\u7406(82):" + e.getMessage());
                        logobj.set("errorinfo", (Object)errorMessge2);
                        logobj.set("syncresult", (Object)"B");
                    }
                    throw throwable;
                }
                try {
                    log.info("\u8ba1\u5212\u540c\u6b65\u5904\u7406(75):\u5f00\u59cbfinally");
                    log.info("\u8ba1\u5212\u540c\u6b65\u5904\u7406(77):terminate\u5b8c\u6210");
                    if (isSuccessed) {
                        logobj.set("syncresult", (Object)"A");
                    }
                    log.info("\u8ba1\u5212\u540c\u6b65\u5904\u7406(81):\u65e5\u5fd7\u4fdd\u5b58\u5f00\u59cb");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logobj});
                    log.info("\u8ba1\u5212\u540c\u6b65\u5904\u7406(81):\u65e5\u5fd7\u4fdd\u5b58\u7ed3\u675f");
                }
                catch (Exception e) {
                    errorMessge = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    if (errorMessge != null && errorMessge.length() >= 1000) {
                        errorMessge = errorMessge.substring(0, 999);
                    }
                    log.error("\u8ba1\u5212\u540c\u6b65\u5904\u7406(82):" + e.getMessage());
                    logobj.set("errorinfo", (Object)errorMessge);
                    logobj.set("syncresult", (Object)"B");
                }
            }
        }
        return isSuccessed;
    }

    private void updateFcDataSeq() {
        FutureTask<String> ft = new FutureTask<String>(new PlanDataToFcDataSeqTask(this.version, this.recon));
        exec.submit(ft);
    }
}

