/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.orderpool.task;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.setoff.FormulaExec;
import kd.mmc.mds.common.setoff.SetOffCommonUtil;
import kd.mmc.mds.common.util.MDSGetBillFieldChangeData;

public class OrderPoolDataOp {
    private final String BILLFIELDTRANSFER = "id,filter_tag,destbill.id,srcbill.id,entryentity.destfieldflag,entryentity.sourcefieldflag,entryentity.converttype,entryentity.calculateexc,entryentity.calculatetext";
    private final String SOURCEDATACONFIG = "id,billfieldtransfer,filter_tag";
    private static final Log logger = LogFactory.getLog(OrderPoolDataOp.class);

    public void start(Long dataConfId, List<Long> orderIds, Set<Long> successIds, Map<Long, String> errors) {
        this.convertDataToSiteRecord(dataConfId, orderIds, successIds, errors);
    }

    private void convertDataToSiteRecord(Long dataConfId, List<Long> orderIds, Set<Long> successIds, Map<Long, String> errors) {
        QFilter qfiltersor = new QFilter("id", "=", (Object)dataConfId);
        DynamicObject sourfield = QueryServiceHelper.queryOne((String)"mrp_resource_dataconf_rgt", (String)"id,billfieldtransfer,filter_tag", (QFilter[])new QFilter[]{qfiltersor});
        if (sourfield == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u914d\u7f6e\u3002", (String)"OrderPoolDataOp_1", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        QFilter qfilter = new QFilter("id", "=", (Object)sourfield.getLong("billfieldtransfer"));
        DynamicObjectCollection billfieldentrys = QueryServiceHelper.query((String)"mrp_billfieldtransfer", (String)"id,filter_tag,destbill.id,srcbill.id,entryentity.destfieldflag,entryentity.sourcefieldflag,entryentity.converttype,entryentity.calculateexc,entryentity.calculatetext", (QFilter[])new QFilter[]{qfilter});
        if (billfieldentrys == null || billfieldentrys.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6570\u636e\u6e90\u914d\u7f6e\u5bf9\u5e94\u7684\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u3002", (String)"OrderPoolDataOp_2", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        String destbill = ((DynamicObject)billfieldentrys.get(0)).getString("destbill.id");
        boolean degbugerr = true;
        HashMap<Long, Object> dynMap = new HashMap<Long, DynamicObject>();
        MDSGetBillFieldChangeData bfcd = new MDSGetBillFieldChangeData();
        StringBuilder selectfeild = new StringBuilder();
        for (DynamicObject billfieldentry : billfieldentrys) {
            if (StringUtils.isNotBlank((CharSequence)selectfeild)) {
                selectfeild.append(',');
            }
            selectfeild.append(billfieldentry.getString("entryentity.destfieldflag"));
        }
        try (DataSet ds = bfcd.getEntityFieldMappingData(sourfield, orderIds);){
            if (ds != null) {
                DataSet sortedDs = ds.orderBy(new String[]{"billno"});
                String lastBillNo = null;
                while (sortedDs.hasNext()) {
                    Row dataitem = sortedDs.next();
                    String currentBillNo = dataitem.getString("billno");
                    if (!currentBillNo.equals(lastBillNo)) {
                        lastBillNo = currentBillNo;
                        if (dynMap.size() > 10000) {
                            this.insertData(dynMap, successIds, errors, selectfeild);
                            dynMap = new HashMap(10005);
                        }
                    }
                    this.dealField(dataitem, destbill, billfieldentrys, dynMap, degbugerr, successIds, errors);
                }
                sortedDs.close();
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        if (!dynMap.isEmpty()) {
            this.insertData(dynMap, successIds, errors, selectfeild);
        }
    }

    private void dealField(Row dataitem, String destbill, DynamicObjectCollection billfieldentry, Map<Long, DynamicObject> dynMap, boolean degbugerr, Set<Long> successIds, Map<Long, String> errors) {
        DynamicObject recordData = this.getNewDynamicObject(destbill);
        Long orderEntyId = dataitem.getLong("billentry.id");
        recordData.set("billstatus", (Object)"A");
        SimpleDateFormat systemDataSdf = new SimpleDateFormat("yyyyMMdd");
        String now = systemDataSdf.format(new Date());
        recordData.set("billno", (Object)(dataitem.getString("billno") + now));
        DynamicObjectType recordDataType = recordData.getDynamicObjectType();
        for (DynamicObject item : billfieldentry) {
            String contype = item.getString("entryentity.converttype");
            String exestr = item.getString("entryentity.calculateexc");
            try {
                if ("0".equals(contype)) {
                    recordData.set(item.getString("entryentity.destfieldflag"), dataitem.get(item.getString("entryentity.sourcefieldflag").trim()));
                    continue;
                }
                if ("4".equals(contype)) {
                    recordData.set(item.getString("entryentity.destfieldflag"), dataitem.get(item.getString("entryentity.calculateexc").trim()));
                    continue;
                }
                if ("3".equals(contype)) {
                    DynamicProperty property = recordDataType.getProperty(item.getString("entryentity.destfieldflag"));
                    if (property == null) continue;
                    if (property instanceof BasedataProp) {
                        recordData.set(item.getString("entryentity.destfieldflag"), (Object)Long.valueOf(exestr));
                        continue;
                    }
                    if (!(property instanceof TextProp)) continue;
                    recordData.set(item.getString("entryentity.destfieldflag"), (Object)exestr);
                    continue;
                }
                if (FormulaExec.IsexecMode(exestr)) {
                    Object execval = FormulaExec.exec(exestr, dataitem);
                    if (execval == null) continue;
                    recordData.set(item.getString("entryentity.destfieldflag"), execval);
                    continue;
                }
                String dstag = item.getString("entryentity.destfieldflag");
                if (StringUtils.isBlank((CharSequence)exestr)) {
                    recordData.set(dstag, (Object)exestr);
                    continue;
                }
                String execfiledName = SetOffCommonUtil.getExecfiledName(exestr, dstag);
                recordData.set(dstag, dataitem.get(execfiledName));
            }
            catch (Exception e) {
                if (!degbugerr) continue;
                logger.warn("MDS Dps Site getdata:" + e);
            }
        }
        if (recordData.getLong("material") <= 0L || recordData.getBigDecimal("reqqty").compareTo(new BigDecimal(0)) < 0) {
            return;
        }
        dynMap.put(orderEntyId, recordData);
    }

    private DynamicObject getNewDynamicObject(String entityNumber) {
        return ORM.create().newDynamicObject(entityNumber);
    }

    private void insertData(Map<Long, DynamicObject> dynMap, Set<Long> successIds, Map<Long, String> errors, StringBuilder selectfeild) {
        HashSet<Long> orderIds = new HashSet<Long>(dynMap.size());
        for (Map.Entry<Long, DynamicObject> orderEntry : dynMap.entrySet()) {
            DynamicObject value = orderEntry.getValue();
            orderIds.add(value.getLong("salbillid"));
            successIds.add(value.getLong("salbillid"));
            BigDecimal scheduledproqty = value.getBigDecimal("scheduledproqty");
            DynamicObject[] reqqty = value.getBigDecimal("reqqty");
            value.set("unscheduledproqty", (Object)reqqty.subtract(scheduledproqty));
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"mds_orderpooldata");
        selectfeild.append(',').append("scheduledproqty");
        DynamicObject[] orderpools = BusinessDataServiceHelper.load((String)"mds_orderpooldata", (String)selectfeild.toString(), (QFilter[])new QFilter[]{new QFilter("salbillid", "in", orderIds)});
        ArrayList<DynamicObject> updateOrderpools = new ArrayList<DynamicObject>(orderpools.length);
        ArrayList<Long> deleteOrderPoolIds = new ArrayList<Long>(orderpools.length);
        for (DynamicObject orderpool : orderpools) {
            String error;
            Long salbillentryid = orderpool.getLong("salbillentryid");
            Long salbillid = orderpool.getLong("salbillid");
            DynamicObject newOrderpool = dynMap.get(salbillentryid);
            Long orderpoolId = orderpool.getLong("id");
            if (newOrderpool == null) {
                deleteOrderPoolIds.add(orderpoolId);
                continue;
            }
            BigDecimal scheduledproqty = orderpool.getBigDecimal("scheduledproqty");
            BigDecimal reqqty = newOrderpool.getBigDecimal("reqqty");
            if (scheduledproqty != null && reqqty != null && scheduledproqty.compareTo(reqqty) > 0) {
                dynMap.remove(salbillentryid);
                error = ResManager.loadKDString((String)"\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u6392\u4ea7\u6570\u91cf\u3002", (String)"OrderPoolDataOp_3", (String)"mmc-mds-common", (Object[])new Object[0]);
                errors.put(salbillid, error);
                newOrderpool.set("id", (Object)orderpoolId);
                newOrderpool.set("reqqty", (Object)scheduledproqty);
                newOrderpool.set("unscheduledproqty", (Object)BigDecimal.ZERO);
                updateOrderpools.add(newOrderpool);
                continue;
            }
            if (reqqty == null) {
                dynMap.remove(salbillentryid);
                error = ResManager.loadKDString((String)"\u9700\u6c42\u6570\u91cf\u4e3a\u7a7a\u3002", (String)"OrderPoolDataOp_4", (String)"mmc-mds-common", (Object[])new Object[0]);
                errors.put(salbillid, error);
                successIds.remove(salbillid);
                continue;
            }
            newOrderpool.set("id", (Object)orderpoolId);
            newOrderpool.set("unscheduledproqty", (Object)reqqty.subtract(scheduledproqty));
            newOrderpool.set("expectedprodeliverydate", orderpool.get("expectedprodeliverydate"));
            newOrderpool.set("proorg", orderpool.get("proorg"));
            updateOrderpools.add(newOrderpool);
            dynMap.remove(salbillentryid);
        }
        ArrayList<DynamicObject> insertOrderpools = new ArrayList<DynamicObject>(dynMap.size());
        insertOrderpools.addAll(dynMap.values());
        for (DynamicObject insertOrderpool : insertOrderpools) {
            insertOrderpool.set("checkstatus", (Object)"A");
        }
        if (!deleteOrderPoolIds.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])deleteOrderPoolIds.toArray(new Long[0]));
        }
        if (!updateOrderpools.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateOrderpools.toArray(new DynamicObject[0]));
        }
        if (!insertOrderpools.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])insertOrderpools.toArray(new DynamicObject[0]));
        }
    }
}

