/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.orderpool.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.NetAddressUtils;

public class OrderPoolGetSettingUtils {
    private static final Logger logger = Logger.getLogger(OrderPoolGetSettingUtils.class.getName());
    public static final String BTNSAVE = "bar_save";
    public static final String C_END = "end";
    public static final String C_START = "start";
    public static final int CANCEL = 2;
    public static final String CO_BASENUMBER = "number";
    public static final String MDS_ORDERPOOLSETDATA = "mds_orderpoolsetdata";
    public static final String CO_STATUS = "status";
    public static final String CO_CYCLETYPED = "cycletyped";
    public static final String CO_DAYSOFMON = "daysofmon";
    public static final String CO_DAYSOFWEEK = "daysofweek";
    public static final String CO_EXE = "tasktype";
    public static final String CO_JOBID = "jobid";
    public static final String CO_LOSEDATE = "losedate";
    public static final String CO_PLANID = "planid";
    public static final String CO_PREDTIME = "predtime";
    public static final String CO_REPEAT = "repeat";
    public static final String CO_REPEATTYPE = "repeattype";
    public static final String CO_RUNNINGTYPE = "runningtype";
    public static final String CO_RUNSTATUS = "runstatus";
    public static final String CO_PLAN = "plan";
    public static final int HMS = 60;
    public static final String LOCALIP = "127.0.0.1";
    public static final String OP = "op";
    public static final String RTIMD = "0";
    public static final String RWEEK = "0";
    public static final int SAVE = 0;

    public static String getSelectProperties() {
        StringBuilder selectProperties = new StringBuilder();
        selectProperties.append(CO_RUNNINGTYPE);
        selectProperties.append(',').append(CO_PREDTIME);
        selectProperties.append(',').append(CO_LOSEDATE);
        selectProperties.append(',').append(CO_REPEATTYPE);
        selectProperties.append(',').append(CO_REPEAT);
        selectProperties.append(',').append("dataconf");
        selectProperties.append(',').append(CO_DAYSOFWEEK);
        selectProperties.append(',').append(CO_DAYSOFMON);
        selectProperties.append(',').append(CO_DAYSOFMON);
        selectProperties.append(',').append(CO_DAYSOFWEEK);
        selectProperties.append(',').append(CO_PLANID);
        selectProperties.append(',').append(CO_JOBID);
        selectProperties.append(',').append(CO_STATUS);
        return selectProperties.toString();
    }

    public static void runImediatly(IFormView fv) {
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)MDS_ORDERPOOLSETDATA, (String)"id,dataconf,enable", (QFilter[])new QFilter[]{new QFilter(CO_STATUS, "=", (Object)"C")});
        SimpleDateFormat systemDataSdf = new SimpleDateFormat("yyyyMMddhhmmss");
        String now = systemDataSdf.format(new Date());
        if (datas == null || datas.length == 0) {
            fv.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u201c\u83b7\u53d6\u8bbe\u7f6e\u201d\u4e2d\u8bbe\u7f6e\u6570\u636e\u6e90\u3002", (String)"OrderPoolGetSettingUtils_2", (String)"mmc-mds-common", (Object[])new Object[0]));
            return;
        }
        DynamicObject data = datas[0];
        Long dataSouceid = data.getLong("dataconf.id");
        QFilter qfiltersor = new QFilter("id", "=", (Object)dataSouceid);
        DynamicObject sourfield = QueryServiceHelper.queryOne((String)"mrp_resource_dataconf_rgt", (String)"id,enable", (QFilter[])new QFilter[]{qfiltersor});
        if (sourfield == null) {
            fv.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u201c\u83b7\u53d6\u8bbe\u7f6e\u201d\u4e2d\u8bbe\u7f6e\u6570\u636e\u6e90\u3002", (String)"OrderPoolGetSettingUtils_2", (String)"mmc-mds-common", (Object[])new Object[0]));
            return;
        }
        boolean enable = sourfield.getBoolean("enable");
        if (!enable) {
            fv.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u5df2\u7981\u7528\uff0c\u8bf7\u5148\u5728\u201c\u83b7\u53d6\u8bbe\u7f6e\u201d\u4e2d\u542f\u7528\u6570\u636e\u6e90\u3002", (String)"OrderPoolGetSettingUtils_3", (String)"mmc-mds-common", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Long> params = new HashMap<String, Long>();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setId("GetOrderPool" + now);
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u6c60\u83b7\u53d6\u8bbe\u7f6e%1$s\u3002", (String)"OrderPoolGetSettingUtils_0", (String)"mmc-mds-common", (Object[])new Object[0]), now));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("mds");
        boolean connc = true;
        jobInfo.setRunConcurrently(connc);
        jobInfo.setTaskClassname("kd.mmc.mds.common.orderpool.task.OrderPoolDataTask");
        jobInfo.setTaskClassname("kd.mmc.mds.common.orderpool.task.OrderPoolDataTask");
        String className = OrderPoolGetSettingUtils.getTaskId("OrderPoolDataTask");
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        Long dataConfId = data.getDynamicObject("dataconf").getLong("id");
        params.put("dataconf", dataConfId);
        jobInfo.setParams(params);
        JobClient.dispatch((JobInfo)jobInfo);
        if (fv != null) {
            fv.showMessage(ResManager.loadKDString((String)"\u83b7\u53d6\u4efb\u52a1\u5206\u53d1\u6210\u529f\uff0c\u8bf7\u5230\u5217\u8868\u754c\u9762\u67e5\u770b\u3002", (String)"OrderPoolGetSettingUtils_4", (String)"mmc-mds-common", (Object[])new Object[0]));
            fv.invokeOperation("refresh");
        }
    }

    public static String getTaskId(String className) {
        DynamicObject taskname = BusinessDataServiceHelper.loadSingle((String)"sch_taskdefine", (String)CO_BASENUMBER, (QFilter[])new QFilter[]{new QFilter(CO_BASENUMBER, "=", (Object)className)});
        if (taskname == null) {
            return null;
        }
        return String.valueOf(taskname.getPkValue());
    }

    public static void setLostdate(PlanInfo planInfo, Date lostdate) {
        Calendar lc = Calendar.getInstance();
        if (lostdate == null) {
            lc.set(1, 2099);
            lc.set(2, 11);
            lc.set(5, 31);
        } else {
            lc.setTime(lostdate);
            lc.add(5, 1);
        }
        planInfo.setEndTime(lc);
    }

    public static String runSgl(DynamicObject task) {
        String rt = task.getString(CO_RUNNINGTYPE);
        Date losedate = task.getDate(CO_LOSEDATE);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -1);
        if (losedate != null && OrderPoolGetSettingUtils.comp(c.getTime(), losedate)) {
            return ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u8bf7\u6c42\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"OrderPoolGetSettingUtils_5", (String)"mmc-mds-common", (Object[])new Object[0]);
        }
        JobDispatcherProxy jdp = new JobDispatcherProxy();
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        ScheduleDao sdao = ExecutorService.getInstance().getObjectFactory().getScheduleDao();
        TaskDao tdao = ExecutorService.getInstance().getObjectFactory().getTaskDao();
        String planId = task.getString(CO_PLANID);
        String jobId = task.getString(CO_JOBID);
        if (!planId.isEmpty()) {
            sdao.disableSchedule(planId);
            jdp.deleteJob(jobId);
            jdp.deletePlan(planId);
            tdao.deleteTaskByScheduleId(planId);
        }
        JobInfo jobInfo = OrderPoolGetSettingUtils.initJobInfo(task);
        jobId = jdp.createJob(jobInfo);
        task.set(CO_JOBID, (Object)jobId);
        PlanInfo planInfo = OrderPoolGetSettingUtils.initPlanInfo(jobInfo, task);
        planId = jdp.createPlan(planInfo);
        boolean isSuccess = sdao.existed(planId);
        for (int count = 0; !isSuccess && count <= 3; ++count) {
            planId = jdp.createPlan(planInfo);
            isSuccess = sdao.existed(planId);
        }
        if (!planId.isEmpty() && "2".equals(task.getString(CO_REPEATTYPE))) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)planId, (String)"sch_schedule");
            obj.set("repeatmode", (Object)"def");
            SaveServiceHelper.update((DynamicObject)obj);
        }
        task.set(CO_PLANID, (Object)planId);
        if ("0".equals(rt)) {
            JobClient.dispatch((JobInfo)jobInfo);
        } else {
            scheduleManager.enableSchedule(planId);
            scheduleManager.enableJob(jobId);
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{task});
        return "";
    }

    public static JobInfo initJobInfo(DynamicObject task) {
        SimpleDateFormat systemDataSdf = new SimpleDateFormat("yyyyMMddhhmmss");
        String now = systemDataSdf.format(new Date());
        JobInfo jobInfo = new JobInfo();
        HashMap<String, Long> params = new HashMap<String, Long>();
        jobInfo.setNumber("GetOrderPool" + now);
        jobInfo.setId("GetOrderPool" + now);
        jobInfo.setAppId("mds");
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u6c60\u83b7\u53d6\u8bbe\u7f6e%1$s\u3002", (String)"OrderPoolGetSettingUtils_0", (String)"mmc-mds-common", (Object[])new Object[0]), now));
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setRunConcurrently(true);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setTaskClassname("kd.mmc.mds.common.orderpool.task.OrderPoolDataTask");
        String className = OrderPoolGetSettingUtils.getTaskId("OrderPoolDataTask");
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        Long dataConfId = task.getLong("dataconf");
        params.put("dataconf", dataConfId);
        jobInfo.setParams(params);
        return jobInfo;
    }

    public static PlanInfo initPlanInfo(JobInfo jobInfo, DynamicObject task) {
        PlanInfo planInfo = new PlanInfo();
        SimpleDateFormat systemDataSdf = new SimpleDateFormat("yyyyMMddhhmmss");
        String now = systemDataSdf.format(new Date());
        String rt = task.getString(CO_RUNNINGTYPE);
        Date losd = task.getDate(CO_LOSEDATE);
        planInfo.setJobId(jobInfo.getId());
        planInfo.setNumber("GetOrderPool" + now);
        OrderPoolGetSettingUtils.setLostdate(planInfo, losd);
        Integer pred = task.getInt(CO_PREDTIME);
        Calendar starttime = OrderPoolGetSettingUtils.getStarttime(pred, rt);
        planInfo.setStartTime(starttime);
        planInfo.setName(jobInfo.getName());
        String repeattype = task.getString(CO_REPEATTYPE);
        if (!task.getBoolean(CO_REPEAT)) {
            planInfo.setRepeatMode(RepeatModeEnum.NONE);
            return planInfo;
        }
        if ("0".equals(repeattype)) {
            planInfo.setRepeatMode(RepeatModeEnum.ByWeeks);
            String daysExp = task.getString(CO_DAYSOFWEEK);
            planInfo.setWeekdaysExp(daysExp);
            planInfo.setPeriod(1);
        } else if ("1".equals(repeattype)) {
            planInfo.setRepeatMode(RepeatModeEnum.ByMonths);
            String daysExp = task.getString(CO_DAYSOFMON);
            planInfo.setDaysExp(daysExp);
            planInfo.setPeriod(1);
        }
        planInfo.setHost(OrderPoolGetSettingUtils.getHostIpAddress());
        return planInfo;
    }

    public static Calendar getStarttime(int pred, String rt) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        if (StringUtils.equals((CharSequence)"0", (CharSequence)rt)) {
            c.add(13, 60);
            return c;
        }
        int h = pred / 60 / 60;
        int m = pred / 60 % 60;
        int s = pred % 60;
        if (OrderPoolGetSettingUtils.beforeNow(h, m, s)) {
            c.add(5, 1);
            c.set(11, h);
            c.set(12, m);
            c.set(13, s);
            return c;
        }
        c.set(11, h);
        c.set(12, m);
        c.set(13, s);
        return c;
    }

    public static boolean beforeNow(int h, int m, int s) {
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(System.currentTimeMillis());
        Calendar pred = Calendar.getInstance();
        pred.set(1, now.get(1));
        pred.set(2, now.get(2));
        pred.set(5, now.get(5));
        pred.set(11, h);
        pred.set(12, m);
        pred.set(13, s);
        return pred.compareTo(now) > 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static String getHostIpAddress() {
        return NetAddressUtils.getLocalIpAddress();
    }

    public static void unrelease(DynamicObject obj) {
        String planId = obj.getString(CO_PLANID);
        String jobId = obj.getString(CO_JOBID);
        JobDispatcherProxy jdp = new JobDispatcherProxy();
        ScheduleDao sdao = ExecutorService.getInstance().getObjectFactory().getScheduleDao();
        TaskDao tdao = ExecutorService.getInstance().getObjectFactory().getTaskDao();
        if (!jobId.isEmpty()) {
            jdp.deleteJob(jobId);
        }
        if (!planId.isEmpty()) {
            jdp.deletePlan(planId);
            tdao.deleteTaskByScheduleId(planId);
            sdao.disableSchedule(planId);
        }
    }

    public static boolean comp(Date comp, Date now) {
        Calendar nCal = Calendar.getInstance();
        nCal.setTime(now);
        Calendar cCal = Calendar.getInstance();
        cCal.setTime(comp);
        if (cCal.get(1) > nCal.get(1)) {
            return true;
        }
        if (cCal.get(1) < nCal.get(1)) {
            return false;
        }
        if (cCal.get(2) > nCal.get(2)) {
            return true;
        }
        if (cCal.get(2) < nCal.get(2)) {
            return false;
        }
        return cCal.get(5) >= nCal.get(5);
    }
}

