/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.orderpool.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class OrderPoolUtil {
    private static final Log logger = LogFactory.getLog(OrderPoolUtil.class);
    private static final String _SPLIT_ = "&&";
    private static final String ID = "id";

    public static Map<String, Long> getMftInfoData(List<Long> materialIds, Long orgId, String selectFields, String entityNumber, QFilter qFilter) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgId);
        return OrderPoolUtil.getMftInfoData(materialIds, orgIds, selectFields, entityNumber, qFilter);
    }

    public static Map<String, Long> getMftInfoData(List<Long> materialIds, List<Long> orgIds, String selectFields, String entityNumber, QFilter qFilter) {
        HashMap<String, Long> basedatas = new HashMap<String, Long>(materialIds.size());
        QFilter qFilterMater = new QFilter("masterid", "in", materialIds);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityNumber, orgIds, (boolean)true);
        selectFields = selectFields + ",createorg";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilterMater);
        qFilters.add(qFilterStatus);
        qFilters.add(qFilterEnable);
        qFilters.add(qFilterOrg);
        if (qFilter != null) {
            qFilters.add(qFilter);
        }
        HashMap<Long, Map> materialCreateOrgBaseDatas = new HashMap<Long, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)OrderPoolUtil.class.getName(), (String)entityNumber, (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long id = row.getLong(0);
                Long createorgid = row.getLong("createorg");
                Long materialId = row.getLong(1);
                Map baseData = materialCreateOrgBaseDatas.computeIfAbsent(materialId, k -> new HashMap(16));
                Long baseDataId = (Long)baseData.get(createorgid);
                if (baseDataId == null) {
                    baseData.put(createorgid, id);
                    continue;
                }
                if (id <= baseDataId) {
                    baseData.put(createorgid, id);
                    continue;
                }
                baseData.put(createorgid, baseDataId);
            }
            dataset.close();
        }
        for (Map.Entry materialCreateOrgBaseData : materialCreateOrgBaseDatas.entrySet()) {
            Long materialId = (Long)materialCreateOrgBaseData.getKey();
            Map createOrgBaseData = (Map)materialCreateOrgBaseData.getValue();
            for (Long orgId : orgIds) {
                Long baseDataId = (Long)createOrgBaseData.get(orgId);
                if (baseDataId == null || baseDataId == 0L) {
                    for (Long id : createOrgBaseData.values()) {
                        if (id == null || id == 0L) continue;
                        baseDataId = id;
                        break;
                    }
                }
                basedatas.put(orgId + _SPLIT_ + materialId, baseDataId);
            }
        }
        return basedatas;
    }

    public static Map<String, Long> getBaseData(List<Long> materialIds, List<Long> orgIds, String selectFields, String entityNumber, QFilter qFilter) {
        HashMap<String, Long> basedatas = new HashMap<String, Long>(materialIds.size());
        QFilter qFilterMater = new QFilter("material", "in", materialIds);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityNumber, orgIds, (boolean)true);
        selectFields = selectFields + ",createorg";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilterMater);
        qFilters.add(qFilterStatus);
        qFilters.add(qFilterEnable);
        qFilters.add(qFilterOrg);
        if (qFilter != null) {
            qFilters.add(qFilter);
        }
        HashMap<Long, Map> materialCreateOrgBaseDatas = new HashMap<Long, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)OrderPoolUtil.class.getName(), (String)entityNumber, (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long id = row.getLong(0);
                Long createorgid = row.getLong("createorg");
                Long materialId = row.getLong(1);
                Map baseData = materialCreateOrgBaseDatas.computeIfAbsent(materialId, k -> new HashMap(16));
                Long baseDataId = (Long)baseData.get(createorgid);
                if (baseDataId == null) {
                    baseData.put(createorgid, id);
                    continue;
                }
                if (id <= baseDataId) {
                    baseData.put(createorgid, id);
                    continue;
                }
                baseData.put(createorgid, baseDataId);
            }
            dataset.close();
        }
        for (Map.Entry materialCreateOrgBaseData : materialCreateOrgBaseDatas.entrySet()) {
            Long materialId = (Long)materialCreateOrgBaseData.getKey();
            Map createOrgBaseData = (Map)materialCreateOrgBaseData.getValue();
            for (Long orgId : orgIds) {
                Long baseDataId = (Long)createOrgBaseData.get(orgId);
                if (baseDataId == null || baseDataId == 0L) {
                    for (Long id : createOrgBaseData.values()) {
                        if (id == null || id == 0L) continue;
                        baseDataId = id;
                        break;
                    }
                }
                basedatas.put(orgId + _SPLIT_ + materialId, baseDataId);
            }
        }
        return basedatas;
    }

    public static Map<String, Long> getBaseData(List<Long> materialIds, Long orgId, String selectFields, String entityNumber, QFilter qFilter) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgId);
        return OrderPoolUtil.getBaseData(materialIds, orgIds, selectFields, entityNumber, qFilter);
    }

    public static String getSelectFields() {
        StringBuilder fields = new StringBuilder();
        fields.append(ID).append(',');
        fields.append("salorg").append(',');
        fields.append("operator").append(',');
        fields.append("customer").append(',');
        fields.append("salbillid").append(',');
        fields.append("salbillno").append(',');
        fields.append("salbillseq").append(',');
        fields.append("salbillentryid").append(',');
        fields.append("billtype").append(',');
        fields.append("billstatus").append(',');
        fields.append("material").append(',');
        fields.append("configuredcode").append(',');
        fields.append("baseunit").append(',');
        fields.append("reqqty").append(',');
        fields.append("deliverydate").append(',');
        fields.append("tracknumber").append(',');
        fields.append("closestatus").append(',');
        fields.append("rowclosestatus").append(',');
        fields.append("proorg").append(',');
        fields.append("prearrangedstatus").append(',');
        fields.append("preorder").append(',');
        fields.append("scheduledprostatus").append(',');
        fields.append("scheduledproqty").append(',');
        fields.append("plannedonlinedate").append(',');
        fields.append("plannedenddate").append(',');
        fields.append("invalidstatus");
        return fields.toString();
    }

    public static Date getFormDate(Date date, String formStr) {
        SimpleDateFormat sim = new SimpleDateFormat(formStr);
        Date formDate = null;
        try {
            String forms = sim.format(date);
            formDate = sim.parse(forms);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return formDate;
    }

    public static Date getFormDate(String dateStr, String formStr) {
        SimpleDateFormat sim = new SimpleDateFormat(formStr);
        Date formDate = null;
        try {
            formDate = sim.parse(dateStr);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return formDate;
    }

    public static String getPermOrgViewSchemeByOrgField(MainEntityType dataEntityType, String orgFieldKey) {
        String ORGFUNCID_BIZUNIT = "15";
        OrgProp orgProp = null;
        DynamicProperty property = dataEntityType.getProperty(orgFieldKey);
        if (property instanceof OrgProp) {
            orgProp = (OrgProp)dataEntityType.getProperty(orgFieldKey);
        }
        if (property != null && orgProp != null) {
            String orgFunc;
            OrgViewSchemeProp orgViewScheme = orgProp.getOrgViewScheme();
            if (orgViewScheme != null && StringUtils.isNotEmpty((CharSequence)(orgFunc = orgViewScheme.getNumber()))) {
                return orgFunc;
            }
            orgFunc = orgProp.getOrgFunc();
            return StringUtils.isEmpty((CharSequence)orgFunc) ? ORGFUNCID_BIZUNIT : orgFunc;
        }
        return ORGFUNCID_BIZUNIT;
    }
}

