/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.orderpool.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.mds.common.orderpool.entity.OrgMaterialConfiguredcode;
import kd.mmc.mds.common.orderpool.util.OrderPoolUtil;

public class ResourceCheckUtil {
    private static final Log log = LogFactory.getLog(ResourceCheckUtil.class);
    private static final String _SPLIT_ = "&&";
    private static final String PROP_ID = "id";

    public static Map<OrgMaterialConfiguredcode, Map<Long, Set<String>>> resourceCheck(Set<String> materialConfiguredcodeorgs, List<String> arrayList) {
        List confs;
        Long proorgId;
        Long configuredcodeId;
        Object split;
        HashMap<OrgMaterialConfiguredcode, Map<Long, Set<String>>> results = new HashMap<OrgMaterialConfiguredcode, Map<Long, Set<String>>>();
        HashMap<String, Long> materialPlanInfoMap = new HashMap<String, Long>(materialConfiguredcodeorgs.size());
        HashMap<String, Long> materialRoutesMap = new HashMap<String, Long>(materialConfiguredcodeorgs.size());
        HashMap<OrgMaterialConfiguredcode, Long> bomMap = new HashMap<OrgMaterialConfiguredcode, Long>(materialConfiguredcodeorgs.size());
        HashMap materialattrMap = new HashMap(materialConfiguredcodeorgs.size());
        HashSet<Long> materialids = new HashSet<Long>(16);
        HashSet<Long> orgids = new HashSet<Long>(16);
        HashMap<Long, List> orgConfs = new HashMap<Long, List>(16);
        HashMap entrymaterialFullconfigMap = new HashMap(100);
        HashMap<String, Map> orgMaterialMap = new HashMap<String, Map>(16);
        boolean isNoCheckBom = false;
        boolean isNoCheckRoute = false;
        boolean isNoCheckMaterialplan = false;
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string;
            switch (string = iterator.next()) {
                case "mpdm_materialplan": {
                    isNoCheckMaterialplan = true;
                    break;
                }
                case "pdm_route": {
                    isNoCheckRoute = true;
                    break;
                }
                case "pdm_mftbom": {
                    isNoCheckBom = true;
                    break;
                }
            }
        }
        for (String string : materialConfiguredcodeorgs) {
            split = string.split(_SPLIT_);
            Long materialId = Long.valueOf(split[0]);
            configuredcodeId = Long.valueOf(split[1]);
            proorgId = Long.valueOf(split[2]);
            materialids.add(materialId);
            orgids.add(proorgId);
            String fullconfig = (String)entrymaterialFullconfigMap.get(materialId);
            if (fullconfig != null && "Y".equals(fullconfig)) {
                confs = orgConfs.computeIfAbsent(proorgId, k -> new ArrayList(16));
                confs.add(configuredcodeId);
                Map orgMaterial = orgMaterialMap.computeIfAbsent(fullconfig, k -> new HashMap(16));
                List list = orgMaterial.computeIfAbsent(proorgId, k -> new ArrayList(16));
                list.add(materialId);
                continue;
            }
            Map orgMaterial = orgMaterialMap.computeIfAbsent("N", k -> new HashMap(16));
            List matIds = orgMaterial.computeIfAbsent(proorgId, k -> new ArrayList(16));
            matIds.add(materialId);
        }
        if (!isNoCheckBom) {
            Iterator<String> matBOMVers = ResourceCheckUtil.getMarerialBOMVersion(materialids, orgids);
            TraceSpan traceSpan = Tracer.create((String)"kd.mmc.mds.opplugin.orderpool.OrderPoolRresourceCheckOp.checkDataBom.getProConfigListMaterial", (String)"getProConfigListMaterial");
            split = null;
            try {
                bomMap.putAll(ResourceCheckUtil.getProConfigListMaterial(materialConfiguredcodeorgs, results, matBOMVers, isNoCheckRoute));
            }
            catch (Throwable materialId) {
                split = materialId;
                throw materialId;
            }
            finally {
                if (traceSpan != null) {
                    if (split != null) {
                        try {
                            traceSpan.close();
                        }
                        catch (Throwable materialId) {
                            ((Throwable)split).addSuppressed(materialId);
                        }
                    } else {
                        traceSpan.close();
                    }
                }
            }
        }
        for (Map.Entry entry : orgMaterialMap.entrySet()) {
            String key = (String)entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                QFilter qFilter = null;
                Long orgId = (Long)entry2.getKey();
                if ("Y".equals(key)) {
                    confs = (List)orgConfs.get(orgId);
                    qFilter = new QFilter("configcode", "in", (Object)confs);
                }
                List materialIds = (List)entry2.getValue();
                if (!isNoCheckMaterialplan) {
                    Map<String, Long> materialPlanInfo = OrderPoolUtil.getMftInfoData((List<Long>)materialIds, orgId, "id,masterid", "mpdm_materialplan", null);
                    materialPlanInfoMap.putAll(materialPlanInfo);
                }
                if (isNoCheckRoute) continue;
                Map<String, Long> routes = ResourceCheckUtil.getRoutes(materialIds, orgId, "id,material,materialgroup", "pdm_route", qFilter);
                materialRoutesMap.putAll(routes);
            }
        }
        for (String string : materialConfiguredcodeorgs) {
            split = string.split(_SPLIT_);
            Long materialId = Long.valueOf((String)split[0]);
            configuredcodeId = Long.valueOf((String)split[1]);
            proorgId = Long.valueOf((String)split[2]);
            OrgMaterialConfiguredcode omc_ = new OrgMaterialConfiguredcode(proorgId, materialId, configuredcodeId);
            Map materialErrors = results.computeIfAbsent(omc_, k -> new HashMap());
            Map materialattr = (Map)materialattrMap.get(proorgId);
            Set set = materialErrors.computeIfAbsent(materialId, k -> new HashSet());
            String materialKey = proorgId + _SPLIT_ + materialId;
            Long materialPlanId = (Long)materialPlanInfoMap.get(materialKey);
            if (!isNoCheckMaterialplan && materialPlanId == null) {
                String errorInfo = ResManager.loadKDString((String)"\u6574\u673a\u7269\u6599%s \u4e0d\u5b58\u5728\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"ResourceCheckUtil_0", (String)"mmc-mds-common", (Object[])new Object[0]);
                set.add(errorInfo);
            }
            if (materialattr != null && "10040".equals(materialattr.get(materialId))) continue;
            Long bomId = (Long)bomMap.get(omc_);
            if (!isNoCheckBom && (bomId == null || bomId.equals(0L))) {
                String errorInfo = ResManager.loadKDString((String)"\u6574\u673a\u7269\u6599%s \u4e0d\u5b58\u5728BOM\u4fe1\u606f\u3002", (String)"ResourceCheckUtil_1", (String)"mmc-mds-common", (Object[])new Object[0]);
                set.add(errorInfo);
            }
            Long routeId = (Long)materialRoutesMap.get(materialKey);
            if (isNoCheckRoute || routeId != null) continue;
            String errorInfo = ResManager.loadKDString((String)"\u6574\u673a\u7269\u6599%s \u4e0d\u5b58\u5728\u5de5\u827a\u8def\u7ebf\u3002", (String)"ResourceCheckUtil_2", (String)"mmc-mds-common", (Object[])new Object[0]);
            set.add(errorInfo);
        }
        HashMap<OrgMaterialConfiguredcode, Map<Long, Set<String>>> omcErrorMap = new HashMap<OrgMaterialConfiguredcode, Map<Long, Set<String>>>();
        HashSet hashSet = new HashSet(100);
        for (Map materialIdErrors : results.values()) {
            hashSet.addAll(materialIdErrors.keySet());
        }
        Map materials = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "in", hashSet)});
        for (Map.Entry resourceCheck : results.entrySet()) {
            OrgMaterialConfiguredcode omc = (OrgMaterialConfiguredcode)resourceCheck.getKey();
            Map value = (Map)resourceCheck.getValue();
            HashMap errorMaps = new HashMap(100);
            for (Map.Entry entry : value.entrySet()) {
                HashSet<String> errors = new HashSet<String>(100);
                Long materialId = (Long)entry.getKey();
                Set errorvalues = (Set)entry.getValue();
                DynamicObject material = (DynamicObject)materials.get(materialId);
                for (String error : errorvalues) {
                    if (error.split("%s").length == 2 && material != null && material.getLocaleString("name").getLocaleValue() != null) {
                        if (error.length() > 450) {
                            error = error.substring(0, 450);
                        }
                        String materiInfoStr = String.format("%s %s", material.getString("number"), material.getLocaleString("name").getLocaleValue());
                        error = String.format(error, materiInfoStr);
                    }
                    if (error.indexOf("%s") != -1) continue;
                    errors.add(error);
                    errorMaps.put(materialId, errors);
                }
            }
            Map computeIfAbsent = omcErrorMap.computeIfAbsent(omc, k -> new HashMap());
            if (errorMaps == null || errorMaps.isEmpty()) continue;
            computeIfAbsent.putAll(errorMaps);
        }
        return omcErrorMap;
    }

    public static Map<OrgMaterialConfiguredcode, Map<Long, Set<String>>> resourceCheck(Set<String> materialConfiguredcodeorgs) {
        return ResourceCheckUtil.resourceCheck(materialConfiguredcodeorgs, new ArrayList<String>());
    }

    private static Map<Long, Long> getMarerialBOMVersion(Set<Long> materialids, Set<Long> orgids) {
        if (materialids == null || materialids.isEmpty()) {
            return new HashMap<Long, Long>(0);
        }
        HashMap<Long, Long> matBOMVers = new HashMap<Long, Long>(materialids.size());
        HashMap<Long, Date> matDates = new HashMap<Long, Date>(materialids.size());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter("material", "in", materialids));
        DataSet bomdataSet = QueryServiceHelper.queryDataSet((String)ResourceCheckUtil.class.getName(), (String)"pdm_mftbom", (String)"id,material.masterid,version", (QFilter[])qFilters.toArray(new QFilter[1]), null);
        DataSet bomversionDataSet = QueryServiceHelper.queryDataSet((String)ResourceCheckUtil.class.getName(), (String)"bd_bomversion_new", (String)"id versionid,material,effectdate", (QFilter[])qFilters.toArray(new QFilter[3]), null);
        try (DataSet dataSet = bomdataSet.join(bomversionDataSet, JoinType.LEFT).on("material.masterid", "material").on("version", "versionid").select(bomdataSet.getRowMeta().getFieldNames(), bomversionDataSet.getRowMeta().getFieldNames()).finish();){
            for (Row row : dataSet) {
                Date effectdate;
                Long materialId = row.getLong("material");
                if (materialId == null || (effectdate = row.getDate("effectdate")) == null) continue;
                long bomVerId = row.getLong(PROP_ID);
                Date lastDate = matDates.getOrDefault(materialId, effectdate);
                long lastomVerId = matBOMVers.getOrDefault(materialId, bomVerId);
                if (effectdate.compareTo(lastDate) > 0) {
                    matDates.put(materialId, effectdate);
                    matBOMVers.put(materialId, bomVerId);
                    continue;
                }
                matDates.put(materialId, lastDate);
                matBOMVers.put(materialId, lastomVerId);
            }
            dataSet.close();
        }
        return matBOMVers;
    }

    private static Map<OrgMaterialConfiguredcode, Long> getProConfigListMaterial(Set<String> materialConfiguredcodeorgs, Map<OrgMaterialConfiguredcode, Map<Long, Set<String>>> results, Map<Long, Long> matBOMVers, boolean isNoCheckRoute) {
        Long orgId;
        HashMap<OrgMaterialConfiguredcode, Long> bomMap = new HashMap<OrgMaterialConfiguredcode, Long>(16);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
        JSONArray jsonArr = new JSONArray();
        for (String arr : materialConfiguredcodeorgs) {
            String[] split = arr.split(_SPLIT_);
            JSONObject param = new JSONObject();
            param.put("searchDate", (Object)new Date());
            Long materialid = Long.valueOf(split[0]);
            param.put("materialid", (Object)materialid);
            param.put("expandConfig", (Object)1637711947497568256L);
            Long versionId = matBOMVers.get(materialid);
            if (versionId != null) {
                param.put("version", (Object)versionId);
            }
            param.put("org", (Object)Long.valueOf(split[2]));
            param.put("showtype", (Object)"A");
            param.put("purchaseexpand", (Object)false);
            param.put("num", (Object)1);
            jsonArr.add((Object)param);
        }
        String key = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"BOMSearchService", (String)"bomExpandForMulType", (Object[])new Object[]{jsonArr.toString()});
        JSONArray rs = JSONObject.parseArray((String)key);
        Iterator<String> it = materialConfiguredcodeorgs.iterator();
        int x = 0;
        HashMap<OrgMaterialConfiguredcode, ArrayList<Long>> omcMaterials = new HashMap<OrgMaterialConfiguredcode, ArrayList<Long>>(materialConfiguredcodeorgs.size());
        while (it.hasNext()) {
            JSONObject obj;
            HashMap<Long, Set<String>> map = new HashMap<Long, Set<String>>(16);
            String next = it.next();
            String[] split = next.split(_SPLIT_);
            OrgMaterialConfiguredcode orgMaterialConfiguredcode = new OrgMaterialConfiguredcode(Long.valueOf((String)split[2]), Long.valueOf((String)split[0]), Long.valueOf((String)split[1]));
            if (!(obj = rs.getJSONObject(x++)).getBoolean("success").booleanValue()) {
                log.warn(obj.getString("msg"));
                String errorInfo = ResManager.loadKDString((String)"\u7269\u6599%s BOM\u5c55\u5f00\u4e3a\u7a7a\u3002", (String)"ResourceCheckUtil_3", (String)"mmc-mds-common", (Object[])new Object[0]);
                Set errors = map.computeIfAbsent(Long.valueOf((String)split[0]), k -> new HashSet());
                errors.add(errorInfo);
                ResourceCheckUtil.updateResult(orgMaterialConfiguredcode, map, results);
                continue;
            }
            JSONArray json = ResourceCheckUtil.getJsonResult(cache, obj);
            if (json.isEmpty()) {
                log.warn("\u7269\u6599:" + Long.valueOf((String)split[0]) + ",\u914d\u7f6e\u53f7:" + Long.valueOf((String)split[1]) + ",BOM\u5c55\u5f00\u4e3a\u7a7a");
                String errorInfo = ResManager.loadKDString((String)"\u7269\u6599%s BOM\u5c55\u5f00\u4e3a\u7a7a\u3002", (String)"ResourceCheckUtil_3", (String)"mmc-mds-common", (Object[])new Object[0]);
                Set errors = map.computeIfAbsent(Long.valueOf((String)split[0]), k -> new HashSet());
                errors.add(errorInfo);
                ResourceCheckUtil.updateResult(orgMaterialConfiguredcode, map, results);
                continue;
            }
            Long topMaterialId = 0L;
            HashMap<Long, List<JSONObject>> pidDatas = new HashMap<Long, List<JSONObject>>(json.size());
            HashMap<String, JSONObject> idDatas = new HashMap<String, JSONObject>(json.size());
            HashSet<Long> entrymaterialIds = new HashSet<Long>(json.size());
            for (int i = 0; i < json.size(); ++i) {
                JSONObject treeentryentity = (JSONObject)json.get(i);
                Long materialId = treeentryentity.getLong("materialId");
                Long entrymaterialId = treeentryentity.getLong("entrymaterialId");
                String level = treeentryentity.getString("level");
                List datas = pidDatas.computeIfAbsent(materialId, k -> new ArrayList());
                idDatas.put(entrymaterialId + _SPLIT_ + materialId, treeentryentity);
                datas.add(treeentryentity);
                if ("1".equals(level)) {
                    topMaterialId = treeentryentity.getLong("materialId");
                }
                entrymaterialIds.add(entrymaterialId);
            }
            HashMap<Long, String> entrymaterialCaseMap = new HashMap<Long, String>(json.size());
            List datas = (List)pidDatas.get(topMaterialId);
            ArrayList<String> nodeids = new ArrayList<String>(idDatas.size());
            if (datas == null || datas.size() == 0) continue;
            HashSet<Long> materialIdSets = new HashSet<Long>(100);
            for (JSONObject data : datas) {
                String materialId = data.getString("materialId");
                String entrymaterialId = data.getString("entrymaterialId");
                nodeids.add(entrymaterialId + _SPLIT_ + materialId);
                String superbomid = data.getString(PROP_ID);
                bomMap.put(orgMaterialConfiguredcode, Long.valueOf(superbomid));
            }
            ResourceCheckUtil.checkBomEntryData(pidDatas, idDatas, nodeids, map, materialIdSets, entrymaterialCaseMap);
            ArrayList<Long> materialIds = new ArrayList<Long>(materialIdSets);
            omcMaterials.put(orgMaterialConfiguredcode, materialIds);
            ResourceCheckUtil.updateResult(orgMaterialConfiguredcode, map, results);
        }
        HashMap<Long, Set> orgmaterialIdMaps = new HashMap<Long, Set>(100);
        HashSet materialSets = new HashSet(100);
        for (Map.Entry entry : omcMaterials.entrySet()) {
            List materials = (List)entry.getValue();
            OrgMaterialConfiguredcode omc = (OrgMaterialConfiguredcode)entry.getKey();
            orgId = omc.getOrgId();
            Set materialIds = orgmaterialIdMaps.computeIfAbsent(orgId, k -> new HashSet());
            materialIds.addAll(materials);
            materialSets.addAll(materials);
        }
        ArrayList<Long> materialIds = new ArrayList<Long>(materialSets);
        if (materialSets.isEmpty()) {
            return bomMap;
        }
        if (isNoCheckRoute) {
            return bomMap;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>(100);
        for (Map.Entry orgmaterialId : orgmaterialIdMaps.entrySet()) {
            orgId = (Long)orgmaterialId.getKey();
            Map<String, Long> orgRoutes = ResourceCheckUtil.getRoutes(materialIds, orgId, "id,material,materialgroup", "pdm_route", null);
            hashMap.putAll(orgRoutes);
        }
        for (Map.Entry omcMaterial : omcMaterials.entrySet()) {
            List materialIdLists = (List)omcMaterial.getValue();
            OrgMaterialConfiguredcode omc = (OrgMaterialConfiguredcode)omcMaterial.getKey();
            Long orgId2 = omc.getOrgId();
            HashMap<Long, Set<String>> errormap = new HashMap<Long, Set<String>>(16);
            for (Long materialkey : materialIdLists) {
                Long routeId = (Long)hashMap.get(orgId2 + _SPLIT_ + materialkey);
                if (routeId != null) continue;
                String errorInfo = ResManager.loadKDString((String)"\u7ec4\u4ef6\u7269\u6599%s \u4e0d\u5b58\u5728\u5de5\u827a\u8def\u7ebf\u3002", (String)"ResourceCheckUtil_4", (String)"mmc-mds-common", (Object[])new Object[0]);
                Set errors = errormap.computeIfAbsent(materialkey, k -> new HashSet());
                errors.add(errorInfo);
            }
            ResourceCheckUtil.updateResult(omc, errormap, results);
        }
        return bomMap;
    }

    public static Map<String, Long> getRoutes(List<Long> materialIds, Long orgId, String selectFields, String entityNumber, QFilter qFilter) {
        HashMap<String, Long> basedatas = new HashMap<String, Long>(materialIds.size());
        QFilter qFilterMater = new QFilter("material", "in", materialIds).and("processtype", "=", (Object)"A");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityNumber, (Long)orgId);
        if (!selectFields.contains("createorg")) {
            selectFields = selectFields + ",createorg";
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        ArrayList<QFilter> qFilterMats = new ArrayList<QFilter>(5);
        ArrayList<QFilter> qFilterRoutes = new ArrayList<QFilter>(5);
        ArrayList<QFilter> qFilterRoute2s = new ArrayList<QFilter>(6);
        ArrayList<QFilter> qFilterRoute1s = new ArrayList<QFilter>(6);
        qFilters.add(qFilterStatus);
        qFilters.add(qFilterEnable);
        qFilterMats.addAll(qFilters);
        qFilterMats.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)orgId));
        qFilterMats.add(new QFilter("masterid", "in", materialIds));
        DataSet mftInfoDataSet = QueryServiceHelper.queryDataSet((String)OrderPoolUtil.class.getName(), (String)"bd_materialmftinfo", (String)"id mftid,masterid, mftcontrolentry.materialcontrol", (QFilter[])qFilterMats.toArray(new QFilter[0]), null);
        qFilterRoutes.addAll(qFilters);
        qFilterRoutes.add(qFilterOrg);
        if (qFilter != null) {
            qFilterRoutes.add(qFilter);
        }
        qFilterRoute1s.addAll(qFilterRoutes);
        qFilterRoute1s.add(new QFilter("processtype", "=", (Object)"B"));
        qFilterRoute2s.addAll(qFilterRoutes);
        qFilterRoute2s.add(qFilterMater);
        DataSet routesData1Set = QueryServiceHelper.queryDataSet((String)OrderPoolUtil.class.getName(), (String)entityNumber, (String)selectFields, (QFilter[])qFilterRoute1s.toArray(new QFilter[0]), null);
        DataSet routesData2Set = QueryServiceHelper.queryDataSet((String)OrderPoolUtil.class.getName(), (String)entityNumber, (String)selectFields, (QFilter[])qFilterRoute2s.toArray(new QFilter[0]), null);
        HashMap<Long, Map> materialCreateOrgBaseDatas = new HashMap<Long, Map>();
        routesData1Set = routesData1Set.join(mftInfoDataSet, JoinType.INNER).on("materialgroup", "mftcontrolentry.materialcontrol").select(routesData1Set.getRowMeta().getFieldNames(), new String[]{"masterid materialId"}).finish();
        routesData1Set = routesData1Set.filter("materialgroup>0");
        routesData2Set = routesData2Set.addField("material", "materialId");
        try (DataSet dataSet = routesData1Set.union(routesData2Set);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong(0);
                Long createorgid = row.getLong("createorg");
                Long materialId = row.getLong("materialId");
                Map baseData = materialCreateOrgBaseDatas.computeIfAbsent(materialId, k -> new HashMap(16));
                Long baseDataId = (Long)baseData.get(createorgid);
                if (baseDataId == null) {
                    baseData.put(createorgid, id);
                    continue;
                }
                if (id <= baseDataId) {
                    baseData.put(createorgid, id);
                    continue;
                }
                baseData.put(createorgid, baseDataId);
            }
            dataSet.close();
            routesData1Set.close();
            routesData2Set.close();
            mftInfoDataSet.close();
        }
        for (Map.Entry materialCreateOrgBaseData : materialCreateOrgBaseDatas.entrySet()) {
            Long materialId = (Long)materialCreateOrgBaseData.getKey();
            Map createOrgBaseData = (Map)materialCreateOrgBaseData.getValue();
            Long baseDataId = (Long)createOrgBaseData.get(orgId);
            if (baseDataId == null || baseDataId == 0L) {
                for (Long id : createOrgBaseData.values()) {
                    if (id == null || id == 0L) continue;
                    baseDataId = id;
                    break;
                }
            }
            basedatas.put(orgId + _SPLIT_ + materialId, baseDataId);
        }
        return basedatas;
    }

    private static JSONArray getJsonResult(DistributeSessionlessCache cache, JSONObject obj) {
        String string = (String)cache.get(obj.getString("dataKey"));
        JSONArray json = JSONObject.parseArray((String)string);
        cache.remove(obj.getString("dataKey"));
        return json;
    }

    private static void checkBomEntryData(Map<Long, List<JSONObject>> pidDatas, Map<String, JSONObject> idDatas, List<String> nodeids, Map<Long, Set<String>> map, Set<Long> materialIds, Map<Long, String> entrymaterialCaseMap) {
        if (nodeids == null || nodeids.size() == 0) {
            return;
        }
        ArrayList<String> childnodeids = new ArrayList<String>(nodeids.size());
        for (String nodeid : nodeids) {
            JSONObject idData = idDatas.get(nodeid);
            String materialattr = idData.getString("entrymaterialattr");
            if ("10040".equals(materialattr)) continue;
            String entrymaterialIdStr = idData.getString("entrymaterialId");
            Long entrymaterialId = Long.valueOf(entrymaterialIdStr);
            String entrytype = idData.getString("entrytype");
            String materialCase = entrymaterialCaseMap.get(entrymaterialId);
            if ("10030".equals(materialattr)) {
                materialIds.add(entrymaterialId);
            }
            if ("B".equals(entrytype) && (StringUtils.isBlank((CharSequence)materialCase) || "N".equals(materialCase))) continue;
            Set errors = map.computeIfAbsent(entrymaterialId, k -> new HashSet());
            List<JSONObject> pidData = pidDatas.get(entrymaterialId);
            if (pidData == null || pidData.isEmpty()) {
                String errorInfo = ResManager.loadKDString((String)"\u7ec4\u4ef6\u7269\u6599%s \u4e0d\u5b58\u5728BOM\u4fe1\u606f\u3002", (String)"ResourceCheckUtil_5", (String)"mmc-mds-common", (Object[])new Object[0]);
                errors.add(errorInfo);
                continue;
            }
            for (JSONObject data : pidData) {
                String entryentrymaterialId = data.getString("entrymaterialId");
                String attr = data.getString("entrymaterialattr");
                if ("10040".equals(attr)) continue;
                childnodeids.add(entryentrymaterialId + _SPLIT_ + entrymaterialId);
            }
        }
        ResourceCheckUtil.checkBomEntryData(pidDatas, idDatas, childnodeids, map, materialIds, entrymaterialCaseMap);
    }

    private static void updateResult(OrgMaterialConfiguredcode omc, Map<Long, Set<String>> map, Map<OrgMaterialConfiguredcode, Map<Long, Set<String>>> results) {
        Map errorMap = results.computeIfAbsent(omc, k -> new HashMap(16));
        for (Map.Entry<Long, Set<String>> errorentry : map.entrySet()) {
            Long key = errorentry.getKey();
            Set<String> errors = errorentry.getValue();
            Set errorSet = errorMap.computeIfAbsent(key, k -> new HashSet());
            errorSet.addAll(errors);
        }
    }

    private static Map<Long, String> getMaterialMftInfo(List<Long> materialIds, Long orgId, String entityNumber) {
        HashMap<Long, String> materialMftInfo = new HashMap<Long, String>(materialIds.size());
        HashMap<Long, Map> materialInfoMap = new HashMap<Long, Map>(materialIds.size());
        QFilter qFilterMater = new QFilter("masterid", "in", materialIds);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityNumber, (Long)orgId);
        Object qFilterAttr = null;
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)OrderPoolUtil.class.getName(), (String)entityNumber, (String)"id,masterid,createorg,materialattr", (QFilter[])new QFilter[]{qFilterMater, qFilterStatus, qFilterOrg, qFilterEnable, qFilterAttr}, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong("createorg");
                Long materialId = row.getLong("masterid");
                String materialattr = row.getString("materialattr");
                Map materialattrMap = materialInfoMap.computeIfAbsent(materialId, k -> new HashMap(16));
                materialattrMap.put(createorgid, materialattr);
            }
            dataset.close();
        }
        for (Map.Entry materialattrMap : materialInfoMap.entrySet()) {
            Long materialId = (Long)materialattrMap.getKey();
            Map materialattrs = (Map)materialattrMap.getValue();
            String materialattr = (String)materialattrs.get(orgId);
            if (StringUtils.isBlank((CharSequence)materialattr) && materialattrs.size() > 0) {
                for (Map.Entry entry : materialattrs.entrySet()) {
                    materialattr = (String)entry.getValue();
                }
            }
            materialMftInfo.put(materialId, materialattr);
        }
        return materialMftInfo;
    }
}

