/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.plancalc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.Grouper;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.plancalc.ext.MdsDataRelFnFieldExt;
import kd.mmc.mds.common.plancalc.ext.MdsDataRelFnFieldExtDefaultImpl;
import kd.mmc.mds.common.plancalc.quota.QuotaDataHandler;
import kd.mmc.mds.common.plancalc.source.SourceDataSetBuilder;
import kd.mmc.mds.common.plandata.PlanDataFieldsSetter;
import kd.mmc.mds.mservice.algox.AddEntryidMapFunction;
import kd.mmc.mds.mservice.algox.MonthTransformMapFunction;
import kd.mmc.mds.mservice.algox.WeekTransformMapFunction;

public class CalculateDataSetHandler {
    private static final Log log = LogFactory.getLog(CalculateDataSetHandler.class);
    private static final DBRoute pur = new DBRoute("pur");
    private static final String[] selectFields = new String[]{"id", "materialid", "datenode", "fcqty", "prodorg", "baseunit", "precisionaccount", "precision"};

    public static void calculate(Object id, String entityName, String changeWay, boolean isquota) {
        String dayofweek;
        log.info("CalculateDataSetHandler-AlgoX\u8ba1\u7b97\u5f00\u59cb");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityName);
        JobSession session = AlgoX.createSession((String)"MdsCalculateJobSession", (String)"MdsCalculateJobSessionTitle");
        log.info("CalculateDataSetHandler-AlgoX\u6765\u6e90\u6570\u636e\u67e5\u8be2");
        String verType = "0";
        if ("mds_rplancal".equals(entityName)) {
            verType = "1";
        }
        Map<String, String> backFieldRelAlias = PlanDataFieldsSetter.getBackFieldRelAlias(verType);
        List<String> calcFields = PlanDataFieldsSetter.getCalcFields(verType);
        List<String> selectFieldsList = Arrays.asList(selectFields);
        DynamicObject setDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityName);
        String sourcetype = setDynamicObject.getString("sourcetype");
        List<String> addFields = calcFields.stream().filter(f -> !selectFieldsList.contains(f)).collect(Collectors.toList());
        if ("mds_setoffsetting".equals(sourcetype)) {
            CalculateDataSetHandler.setoffFieldSetting(verType, addFields);
        }
        List<String> extFields = backFieldRelAlias.entrySet().stream().filter(f -> addFields.contains(f.getKey())).map(o -> " detailentity.".concat((String)o.getKey()).concat(" as ").concat((String)o.getValue())).collect(Collectors.toList());
        List<String> extAlias = backFieldRelAlias.entrySet().stream().filter(f -> addFields.contains(f.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        DataSetX dataSetX = SourceDataSetBuilder.load(session, id, entityName, extFields, extAlias);
        DynamicObject fcvrnnum = dynamicObject.getDynamicObject("predversion");
        DynamicObject mdsData = QueryServiceHelper.queryOne((String)"mds_data", (String)"id", (QFilter[])new QFilter[]{new QFilter("fcvrnnum", "=", fcvrnnum.getPkValue())});
        if (mdsData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u7248\u672c\u5bf9\u5e94\u6570\u636e\u4e3a\u7a7a\u3002", (String)"CalculateDataSetHandler_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        String cycletype = fcvrnnum.getString("cytype");
        if ("1".equals(cycletype)) {
            dayofweek = fcvrnnum.getString("dayofweek");
            log.info("CalculateDataSetHandler-AlgoX\u5468\u6c47\u805a");
            dataSetX = dataSetX.map((MapFunction)new WeekTransformMapFunction(dataSetX.getRowMeta(), "fdatenode", dayofweek));
        } else if ("3".equals(cycletype)) {
            dayofweek = fcvrnnum.getString("dayofweek");
            log.info("CalculateDataSetHandler-AlgoX\u6708\u6c47\u805a");
            dataSetX = dataSetX.map((MapFunction)new MonthTransformMapFunction(dataSetX.getRowMeta(), "fdatenode", dayofweek));
        }
        if (isquota) {
            log.info("CalculateDataSetHandler-AlgoX\u914d\u989d");
            List<String> fixedQuotaField = Arrays.asList("fmaterialid", "fbaseunitid", "fprecision", "fprecisionaccount", "fdatenode");
            ArrayList<String> quotaFields = new ArrayList<String>(16);
            quotaFields.addAll(fixedQuotaField);
            quotaFields.addAll(extAlias);
            Grouper grouper = dataSetX.groupBy(quotaFields.toArray(new String[0]));
            dataSetX = grouper.sum("ffcqty").max("id");
            dataSetX = dataSetX.addFields(new Field[]{new Field("fprodorg", (DataType)DataType.LongType)}, new Object[]{0L});
            DataSetX quoDataSetX = QuotaDataHandler.loadMaterialQuotaDataSetX(session);
            dataSetX = QuotaDataHandler.calculateQuotaData(dataSetX, quoDataSetX, dynamicObject, extAlias);
        } else {
            List<String> fixedField = Arrays.asList("id", "fmaterialid", "fbaseunitid", "fdatenode", "ffcqty", "fprodorg");
            ArrayList<String> listField = new ArrayList<String>(16);
            listField.addAll(fixedField);
            listField.addAll(extAlias);
            dataSetX = dataSetX.select(listField.toArray(new String[0]));
        }
        if ("1".equals(changeWay)) {
            log.info("CalculateDataSetHandler-AlgoX\u4ec5\u66f4\u65b0\u589e\u52a0");
            dataSetX = CalculateDataSetHandler.getPredversionDataSetX(session, dataSetX, dynamicObject, extFields);
        }
        CalculateDataSetHandler.writeToPreVersion(session, dataSetX, mdsData.getLong("id"), extAlias);
        log.info("CalculateDataSetHandler-AlgoX\u8ba1\u7b97\u7ed3\u675f");
    }

    private static void setoffFieldSetting(String verType, List<String> addFields) {
        addFields.clear();
        HashMap mdsDataRelFn = new HashMap(16);
        PluginProxy pluginProxy = PluginProxy.create((Object)new MdsDataRelFnFieldExtDefaultImpl(), MdsDataRelFnFieldExt.class, (String)"MDS_PLANCALC_MDSDATARELFN_EXT", null);
        List results = pluginProxy.callReplaceIfPresent(MdsDataRelFnFieldExt::getMdsDataRelFnExtMap);
        if (results != null && !results.isEmpty()) {
            for (Map map : results) {
                if (map == null) continue;
                mdsDataRelFn.putAll(map);
            }
        }
        Map<String, String> fieldRelAliasFields = PlanDataFieldsSetter.getBackFieldRelAlias(verType);
        Map<String, String> extAliasRelFields = fieldRelAliasFields.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        for (String alias : mdsDataRelFn.keySet()) {
            String field = extAliasRelFields.get(alias);
            if (!StringUtils.isNotEmpty((CharSequence)field)) continue;
            addFields.add(field);
        }
    }

    public static void writeToPreVersion(JobSession session, DataSetX dataSetX, Long preVersionDataId, List<String> extAlias) {
        log.info("CalculateDataSetHandler-AlgoX\u5165\u5e93\u5f00\u59cb");
        List<String> fixedField = Arrays.asList("fmaterialid", "fbaseunitid", "fprodorg", "fdatenode");
        ArrayList<String> writeFields = new ArrayList<String>(16);
        writeFields.addAll(fixedField);
        writeFields.addAll(extAlias);
        Grouper grouper = dataSetX.groupBy(writeFields.toArray(new String[0]));
        dataSetX = grouper.sum("ffcqty");
        Field[] fields = new Field[]{new Field("fid", (DataType)DataType.LongType), new Field("fentryid", (DataType)DataType.LongType)};
        Object[] objects = new Object[]{preVersionDataId, 0L};
        dataSetX = dataSetX.addFields(fields, objects);
        dataSetX = dataSetX.map((MapFunction)new AddEntryidMapFunction(dataSetX.getRowMeta(), "fentryid"));
        DataSetOutput output = new DataSetOutput(dataSetX.getRowMeta());
        String outputId = output.getId();
        dataSetX.output((Output)output);
        session.commit(30, TimeUnit.MINUTES);
        DataSet dataSet = session.readDataSet(outputId);
        int columnSize = dataSet.copy().count("fdatenode", true);
        if (columnSize > 150) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u65f6\u95f4\u8282\u70b9\u8d85\u8fc7150\u5217\u3002", (String)"CalculateDataSetHandler_1", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        String insertSql = CalculateDataSetHandler.buildInsertSql(dataSet.getRowMeta());
        try (TXHandle h1 = TX.required();){
            try {
                log.info("CalculateDataSetHandler-AlgoX\u5f00\u59cb\u6e05\u9664\u540e\u53f0\u8868\u6570\u636e");
                String clearSql = "delete from t_mds_fcdatadtlent where fid=?";
                DB.execute((DBRoute)pur, (String)clearSql, (Object[])new Object[]{preVersionDataId});
                log.info("CalculateDataSetHandler-AlgoX\u6e05\u9664\u540e\u53f0\u8868\u6570\u636e\u7ed3\u675f");
                log.info("CalculateDataSetHandler-AlgoX\u5f00\u59cb\u63d2\u5165\u540e\u53f0\u8868\u6570\u636e");
                CalculateDataSetHandler.insertToFcdatatsentry(dataSet, insertSql);
                log.info("CalculateDataSetHandler-AlgoX\u63d2\u5165\u540e\u53f0\u8868\u6570\u636e\u7ed3\u675f");
            }
            catch (Throwable e) {
                h1.markRollback();
                throw e;
            }
        }
    }

    public static DataSetX getPredversionDataSetX(JobSession session, DataSetX dataSetX, DynamicObject dynamicObject, List<String> extFields) {
        Object predversionId = dynamicObject.getDynamicObject("predversion").getPkValue();
        QFilter qFilterPre = new QFilter("fcvrnnum", "=", predversionId);
        qFilterPre.and(new QFilter("detailentity.materialid", "!=", (Object)0L));
        qFilterPre.and(new QFilter("detailentity.datenode", "is not null", null));
        String sql = "id,detailentity.materialid as fmaterialid,detailentity.baseunit as fbaseunitid,detailentity.datenode as fdatenode,detailentity.fcqty as ffcqty,detailentity.prodorg as fprodorg";
        if (extFields != null && !extFields.isEmpty()) {
            String extFieldSql = String.join((CharSequence)",", extFields);
            sql = sql.concat(",").concat(extFieldSql);
        }
        DataSet predversionDataSet = QueryServiceHelper.queryDataSet((String)"predversionData", (String)"mds_data", (String)sql, (QFilter[])new QFilter[]{qFilterPre}, null);
        DataSetInput dataSetInput = new DataSetInput(predversionDataSet, predversionDataSet.getRowMeta());
        DataSetX predversionDatasetx = session.fromInput((Input)dataSetInput);
        dataSetX = predversionDatasetx.union(dataSetX);
        return dataSetX;
    }

    private static String buildInsertSql(RowMeta rowMeta) {
        Field[] fields;
        String sql = "insert into t_mds_fcdatadtlent (%s) values (%s)";
        StringBuilder fieldSql = new StringBuilder();
        StringBuilder paramsSql = new StringBuilder();
        for (Field field : fields = rowMeta.getFields()) {
            if (fieldSql.length() > 0) {
                fieldSql.append(",");
                paramsSql.append(",");
            }
            fieldSql.append(field.getName());
            paramsSql.append("?");
        }
        return String.format(sql, fieldSql, paramsSql);
    }

    private static void insertToFcdatatsentry(DataSet dataSet, String insertSql) {
        RowMeta meta = dataSet.getRowMeta();
        Field[] fields = meta.getFields();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        for (Row row : dataSet) {
            ArrayList<Object> params = new ArrayList<Object>(16);
            for (Field field : fields) {
                params.add(row.get(field.getAlias()));
            }
            paramsList.add(params.toArray(new Object[0]));
            if (paramsList.size() < 10000) continue;
            CalculateDataSetHandler.dBexecuteBatch(pur, insertSql, paramsList);
            paramsList.clear();
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)pur, (String)insertSql, paramsList);
        }
    }

    private static void dBexecuteBatch(DBRoute pur, String insertSql, List<Object[]> paramsList) {
        DB.executeBatch((DBRoute)pur, (String)insertSql, paramsList);
    }
}

