/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.plancalc.algo;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Collector;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.mds.common.util.DateUtil;

public class PlanDataSplitReduceGroupFunction
extends ReduceGroupFunctionWithCollector {
    private RowMeta rowMeta;
    private String cytype;

    public PlanDataSplitReduceGroupFunction(RowMeta rowMeta, String cytype) {
        this.rowMeta = rowMeta;
        this.cytype = cytype;
    }

    public void reduce(Iterator<Row> iterator, Collector collector) {
        int dateIndex = this.rowMeta.getFieldIndex("fdatenode");
        int qtyIndex = this.rowMeta.getFieldIndex("ffcqty");
        Iterator<Row> it = iterator;
        while (it.hasNext()) {
            Row row = it.next();
            Date fdatenode = row.getDate("fdatenode");
            String curcytype = this.cytype;
            if (StringUtils.isEmpty((CharSequence)curcytype)) {
                curcytype = row.getString("curcytype");
            }
            List<Date> dateList = this.getDateList(fdatenode, curcytype);
            BigDecimal periods = BigDecimal.valueOf(dateList.size());
            BigDecimal qty = row.getBigDecimal("ffcqty");
            int precision = row.getInteger("fprecision");
            String precisionaccount = row.getString("fprecisionaccount");
            RoundingMode roundingMode = RoundingMode.HALF_UP;
            if ("2".equals(precisionaccount)) {
                roundingMode = RoundingMode.DOWN;
            } else if ("3".equals(precisionaccount)) {
                roundingMode = RoundingMode.UP;
            }
            BigDecimal newQty = qty.divide(periods, precision, roundingMode);
            BigDecimal balance = qty;
            for (int i = 0; i < dateList.size(); ++i) {
                if (BigDecimal.ZERO.compareTo(balance) > 0) {
                    newQty = BigDecimal.ZERO;
                } else if (newQty.compareTo(balance) > 0) {
                    newQty = balance;
                } else if (i == dateList.size() - 1) {
                    newQty = balance;
                }
                balance = balance.subtract(newQty);
                Object[] newRow = this.copyRow(row);
                newRow[dateIndex] = dateList.get(i);
                newRow[qtyIndex] = newQty;
                collector.collect(newRow);
            }
        }
    }

    private Object[] copyRow(Row row) {
        Object[] newRow = new Object[this.rowMeta.getFieldCount()];
        for (int i = 0; i < this.rowMeta.getFieldCount(); ++i) {
            newRow[i] = row.get(i);
        }
        return newRow;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private List<Date> getDateList(Date fdatenode, String cytype) {
        List<Date> dateList = new ArrayList<Date>(16);
        if ("1".equals(cytype)) {
            fdatenode = DateUtil.getTheWeekStart(fdatenode, 2);
            Calendar startc = Calendar.getInstance();
            startc.setTime(fdatenode);
            for (int i = 0; i < 5; ++i) {
                dateList.add(startc.getTime());
                startc.add(6, 1);
            }
        } else if ("3".equals(cytype)) {
            Date start = DateUtil.getMonthOffset(fdatenode, "Mbeg");
            Date end = DateUtil.getMonthOffset(fdatenode, "Mend");
            dateList = DateUtil.getBetweenDates(start, end);
            Calendar calendar = Calendar.getInstance();
            dateList = dateList.stream().filter(o -> {
                calendar.setTime((Date)o);
                int dayofweek = calendar.get(7);
                return dayofweek != 1 && dayofweek != 7;
            }).collect(Collectors.toList());
        } else {
            dateList.add(fdatenode);
        }
        return dateList;
    }
}

