/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.plancalc.quota;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.util.DateUtil;
import kd.mmc.mds.mservice.algox.QuotaMapFunction;
import kd.mmc.mds.mservice.algox.QuotaReduceGroupFunction;
import kd.mmc.mds.mservice.algox.QuotaResolveMapFunction;

public class QuotaDataHandler {
    public static DataSetX loadMaterialQuotaDataSetX(JobSession session) {
        QFilter qFilter = new QFilter("quotatype", "=", (Object)"bd_material");
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        String quotaSql = "id as quotaId,quotatype,material,effectdate,losedate,status,enable,entryentity,entryentity.allocateorg,entryentity.quotamod/100 as quotamod";
        DataSet quotaDataSet = QueryServiceHelper.queryDataSet((String)"quotaData", (String)"mds_quotadata", (String)quotaSql, (QFilter[])new QFilter[]{qFilter}, null);
        DataSetInput dataSetInput = new DataSetInput(quotaDataSet, quotaDataSet.getRowMeta());
        return session.fromInput((Input)dataSetInput);
    }

    public static DataSetX calculateQuotaData(DataSetX dataSetX, DataSetX quoDataSetX, DynamicObject dynamicObject, List<String> extAlias) {
        JoinDataSetX joinDataSetX;
        DynamicObject dummysite = dynamicObject.getDynamicObject("dummysite");
        int outlookperiod = dynamicObject.getInt("outlookperiod");
        Date outlookDate = DateUtil.dateAddDays(new Date(), outlookperiod);
        long defaultOrg = 0L;
        quoDataSetX = quoDataSetX.flatMap((FlatMapFunction)new QuotaResolveMapFunction(quoDataSetX.getRowMeta(), "effectdate", "losedate", outlookDate));
        if (dummysite == null) {
            joinDataSetX = dataSetX.join(quoDataSetX);
        } else {
            joinDataSetX = dataSetX.leftJoin(quoDataSetX);
            defaultOrg = dummysite.getLong("id");
        }
        if (joinDataSetX != null) {
            joinDataSetX = joinDataSetX.on("fmaterialid", "material");
            joinDataSetX = joinDataSetX.on("fdatenode", "effectdate");
            List<String> fixedField = Arrays.asList("quotaId", "effectdate", "losedate", "id", "fmaterialid", "fbaseunitid", "fdatenode", "ffcqty", "quotamod", "entryentity.allocateorg as fprodorg", "fprecision", "fprecisionaccount", "ffcqty as totalQty");
            ArrayList<String> listField = new ArrayList<String>(16);
            listField.addAll(fixedField);
            listField.addAll(extAlias);
            dataSetX = joinDataSetX.select(listField.toArray(new String[0]));
            dataSetX = dataSetX.filter(" ffcqty <> 0 or fprodorg <> null ");
            dataSetX = dataSetX.map((MapFunction)new QuotaMapFunction(dataSetX.getRowMeta(), "ffcqty", "quotamod", "fprodorg", "fprecision", "fprecisionaccount", Long.valueOf(defaultOrg)));
            ArrayList<String> asList = new ArrayList<String>(16);
            asList.add("fmaterialid");
            asList.add("fdatenode");
            asList.add("fbaseunitid");
            asList.addAll(extAlias);
            String[] groupBy = asList.toArray(new String[0]);
            dataSetX = dataSetX.groupBy(groupBy).reduceGroup((GroupReduceFunction)new QuotaReduceGroupFunction(dataSetX.getRowMeta(), extAlias));
        }
        return dataSetX;
    }
}

