/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.plancalc.source;

import java.util.Date;
import java.util.List;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.plancalc.source.loadhandler.LoadDataHandler;
import kd.mmc.mds.common.plancalc.source.loadhandler.impl.CorlLoadDataHandler;
import kd.mmc.mds.common.plancalc.source.loadhandler.impl.DeliveryQuerySetDataHandler;
import kd.mmc.mds.common.plancalc.source.loadhandler.impl.SetoffLoadDataHandler;
import kd.mmc.mds.common.plancalc.source.loadhandler.impl.VrdsLoadDataHandler;
import kd.mmc.mds.common.util.DateUtil;

public class SourceDataSetBuilder {
    public static DataSetX load(JobSession session, Object id, String entityName, List<String> extFields, List<String> extAlias) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityName);
        String sourcetype = dynamicObject.getString("sourcetype");
        LoadDataHandler load = null;
        int outlookperiod = dynamicObject.getInt("outlookperiod");
        Date outlookDate = DateUtil.dateAddDays(new Date(), outlookperiod);
        Object sourcenameId = 0L;
        boolean splitDay = dynamicObject.getBoolean("splitday");
        sourcenameId = "mds_rplancal".equals(entityName) ? dynamicObject.getDynamicObject("sourcename").getPkValue() : dynamicObject.getDynamicObject("forecast").getPkValue();
        if ("mds_vrds".equals(sourcetype)) {
            VrdsLoadDataHandler vrdsLoadDataHandler = new VrdsLoadDataHandler(sourcenameId, outlookDate, extFields);
            vrdsLoadDataHandler.setSplitDay(splitDay);
            load = vrdsLoadDataHandler;
        } else if ("mds_corl".equals(sourcetype)) {
            CorlLoadDataHandler corlLoadDataHandler = new CorlLoadDataHandler(sourcenameId, outlookDate, extFields, extAlias);
            corlLoadDataHandler.setSplitDay(splitDay);
            load = corlLoadDataHandler;
        } else if ("mds_setoffsetting".equals(sourcetype)) {
            load = new SetoffLoadDataHandler(dynamicObject, outlookDate);
        } else if ("mds_deliveryqueryset".equals(sourcetype)) {
            load = new DeliveryQuerySetDataHandler(id, entityName, outlookDate);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6765\u6e90\u6570\u636e\u5f02\u5e38\u3002", (String)"SourceDataSetBuilder_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        return load.loadData(session);
    }
}

