/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.plancalc.source.loadhandler.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.plancalc.algo.PlanDataSplitReduceGroupFunction;
import kd.mmc.mds.common.plancalc.source.loadhandler.LoadDataHandler;

public class CorlLoadDataHandler
implements LoadDataHandler {
    private final Object sourcenameId;
    private final Date outlookDate;
    private final List<String> extFields;
    private final List<String> extAlias;
    private boolean splitDay;

    public CorlLoadDataHandler(Object sourcenameId, Date outlookDate, List<String> extFields, List<String> extAlias) {
        this.sourcenameId = sourcenameId;
        this.outlookDate = outlookDate;
        this.extFields = extFields;
        this.extAlias = extAlias;
    }

    @Override
    public DataSetX loadData(JobSession session) {
        DynamicObject corl = BusinessDataServiceHelper.loadSingleFromCache((Object)this.sourcenameId, (String)"mds_corl", (String)"id,entryentity,entryentity.srcvrnnum");
        DynamicObjectCollection entryentity = corl.getDynamicObjectCollection("entryentity");
        Set vrdsSet = entryentity.stream().map(m -> m.getLong("srcvrnnum.id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "=", this.sourcenameId);
        String corlSql = "id as corID,entryentity,entryentity.srcvrnnum,entryentity.propt,entryentity.srcvrnnum.cytype as curcytype";
        DataSet corlDataSet = QueryServiceHelper.queryDataSet((String)"corlData", (String)"mds_corl", (String)corlSql, (QFilter[])new QFilter[]{qFilter}, null);
        QFilter vrdsIdFilter = new QFilter("fcvrnnum", "in", vrdsSet);
        vrdsIdFilter.and(new QFilter("detailentity.datenode", "<=", (Object)this.outlookDate));
        String sql = "id,fcvrnnum,detailentity.materialid,detailentity.baseunit,detailentity.datenode,detailentity.fcqty,detailentity.prodorg,detailentity.baseunit.precision,detailentity.baseunit.precisionaccount";
        if (this.extFields != null && !this.extFields.isEmpty()) {
            String extFieldSql = String.join((CharSequence)",", this.extFields);
            sql = sql.concat(",").concat(extFieldSql);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"sourceVrdsData", (String)"mds_data", (String)sql, (QFilter[])new QFilter[]{vrdsIdFilter}, null);
        JoinDataSet joinDataSet = dataSet.join(corlDataSet, JoinType.INNER);
        joinDataSet.on("fcvrnnum", "entryentity.srcvrnnum");
        ArrayList<String> listField = new ArrayList<String>(16);
        listField.add("id");
        listField.add("detailentity.materialid as fmaterialid");
        listField.add("detailentity.baseunit as fbaseunitid");
        listField.add("detailentity.datenode as fdatenode");
        listField.add("detailentity.fcqty*entryentity.propt/100 as ffcqty");
        listField.add("detailentity.prodorg as fprodorg");
        listField.add("detailentity.baseunit.precision as fprecision");
        listField.add("detailentity.baseunit.precisionaccount as fprecisionaccount");
        listField.add("curcytype");
        listField.addAll(this.extAlias);
        dataSet = joinDataSet.select(listField.toArray(new String[0])).finish();
        if (this.isSplitDay()) {
            RowMeta rowMeta = dataSet.getRowMeta();
            dataSet = dataSet.reduceGroup((ReduceGroupFunctionWithCollector)new PlanDataSplitReduceGroupFunction(rowMeta, null));
        }
        DataSetInput dataSetInput = new DataSetInput(dataSet);
        return session.fromInput((Input)dataSetInput);
    }

    public boolean isSplitDay() {
        return this.splitDay;
    }

    public void setSplitDay(boolean splitDay) {
        this.splitDay = splitDay;
    }
}

