/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.plancalc.source.loadhandler.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Collector;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Input;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.deliveryquery.DeliveryQueryManger;
import kd.mmc.mds.common.plancalc.source.loadhandler.LoadDataHandler;
import kd.mmc.mds.common.util.DateUtil;
import kd.mmc.mds.mservice.algox.DayTransformMapFunction;

public class DeliveryQuerySetDataHandler
implements LoadDataHandler {
    private Date outlookDate;
    private Object id;
    private String entityName;

    public DeliveryQuerySetDataHandler(Object id, String entityName, Date outlookDate) {
        this.id = id;
        this.entityName = entityName;
        this.outlookDate = outlookDate;
    }

    @Override
    public DataSetX loadData(JobSession session) {
        DynamicObject calcSet = BusinessDataServiceHelper.loadSingleFromCache((Object)this.id, (String)this.entityName);
        Object sourcenameId = 0L;
        sourcenameId = "mds_rplancal".equals(this.entityName) ? calcSet.getDynamicObject("sourcename").getPkValue() : calcSet.getDynamicObject("forecast").getPkValue();
        DeliveryQueryManger deliveryQueryManger = DeliveryQueryManger.create(sourcenameId);
        DataSet dataSet = deliveryQueryManger.queryDeliverySet(null);
        HashMap<String, String> mdsDataRelFn = new HashMap<String, String>(16);
        mdsDataRelFn.put("fmaterialid", "materiel");
        mdsDataRelFn.put("fbaseunitid", "unit");
        mdsDataRelFn.put("fdatenode", "deliverydate");
        mdsDataRelFn.put("ffcqty", "qty");
        String selectFields = mdsDataRelFn.entrySet().stream().map(o -> (String)o.getValue() + " as " + (String)o.getKey()).collect(Collectors.joining(","));
        dataSet = dataSet.select(selectFields).filter("fdatenode is not null");
        String processMode = calcSet.getString("processmode");
        if (this.outlookDate != null) {
            dataSet = dataSet.filter(new FilterFunction(){

                public boolean test(Row row) {
                    Date fdatenode = row.getDate("fdatenode");
                    return fdatenode != null && fdatenode.compareTo(DeliveryQuerySetDataHandler.this.outlookDate) <= 0;
                }
            });
        }
        Calendar c = Calendar.getInstance();
        if ("0".equals(processMode)) {
            dataSet = dataSet.updateField("fdatenode", "Date(" + c.get(1) + ",Month(fdatenode),Day(fdatenode))");
        } else if ("1".equals(processMode) || "3".equals(processMode)) {
            List<Object> dateList2 = new ArrayList(16);
            if ("1".equals(processMode)) {
                dateList2 = DeliveryQuerySetDataHandler.getDates(calcSet, c);
            } else if ("3".equals(processMode)) {
                Date enddate;
                DynamicObject hisevent = calcSet.getDynamicObject("hisevent");
                DynamicObject fcevent = calcSet.getDynamicObject("fcevent");
                if (hisevent == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5386\u53f2\u4e8b\u4ef6\u672a\u5b9a\u4e49\u3002", (String)"DeliveryQuerySetDataHandler_0", (String)"mmc-mds-common", (Object[])new Object[0]));
                }
                if (fcevent == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9884\u6d4b\u4e8b\u4ef6\u672a\u5b9a\u4e49\u3002", (String)"DeliveryQuerySetDataHandler_1", (String)"mmc-mds-common", (Object[])new Object[0]));
                }
                dataSet = DeliveryQuerySetDataHandler.filterHisData(dataSet, hisevent);
                Date startdate = (fcevent = BusinessDataServiceHelper.loadSingle((Object)fcevent.getPkValue(), (String)"mds_event")).getDate("startdate");
                dateList2 = DateUtil.getBetweenDates(startdate, enddate = fcevent.getDate("enddate"));
                if (dateList2.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9884\u6d4b\u65e5\u671f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u9884\u6d4b\u4e8b\u4ef6\u672a\u5b9a\u4e49\u3002", (String)"DeliveryQuerySetDataHandler_2", (String)"mmc-mds-common", (Object[])new Object[0]));
                }
            }
            final List<Object> dateList = dateList2;
            mdsDataRelFn.put("fmaterialid", "materiel");
            mdsDataRelFn.put("fbaseunitid", "unit");
            mdsDataRelFn.put("fdatenode", "deliverydate");
            mdsDataRelFn.put("ffcqty", "qty");
            dataSet = dataSet.groupBy(new String[]{"fmaterialid", "fbaseunitid"}).sum("ffcqty").max("fdatenode").finish();
            final RowMeta rowMeta = dataSet.getRowMeta();
            dataSet = dataSet.reduceGroup(new ReduceGroupFunctionWithCollector(){

                public void reduce(Iterator<Row> iterator, Collector collector) {
                    BigDecimal periods = BigDecimal.valueOf(dateList.size());
                    Iterator<Row> it = iterator;
                    while (it.hasNext()) {
                        Row row = it.next();
                        Long fmaterialid = row.getLong("fmaterialid");
                        Long fbaseunitid = row.getLong("fbaseunitid");
                        BigDecimal qty = row.getBigDecimal("ffcqty");
                        DynamicObject unit = BusinessDataServiceHelper.loadSingleFromCache((Object)fbaseunitid, (String)"bd_measureunits");
                        int precision = unit.getInt("precision");
                        String precisionaccount = unit.getString("precisionaccount");
                        RoundingMode roundingMode = RoundingMode.HALF_UP;
                        if ("2".equals(precisionaccount)) {
                            roundingMode = RoundingMode.DOWN;
                        } else if ("3".equals(precisionaccount)) {
                            roundingMode = RoundingMode.UP;
                        }
                        BigDecimal newQty = qty.divide(periods, precision, roundingMode);
                        BigDecimal balance = qty;
                        for (int i = 0; i < dateList.size(); ++i) {
                            if (BigDecimal.ZERO.compareTo(balance) > 0) {
                                newQty = BigDecimal.ZERO;
                            } else if (newQty.compareTo(balance) > 0) {
                                newQty = balance;
                            } else if (i == dateList.size() - 1) {
                                newQty = balance;
                            }
                            balance = balance.subtract(newQty);
                            collector.collect(new Object[]{fmaterialid, fbaseunitid, newQty, dateList.get(i)});
                        }
                    }
                }

                public RowMeta getResultRowMeta() {
                    return rowMeta;
                }
            });
        }
        DataSetInput dataSetInput = new DataSetInput(dataSet);
        DataSetX dataSetX = session.fromInput((Input)dataSetInput);
        dataSetX = dataSetX.map((MapFunction)new DayTransformMapFunction(dataSetX.getRowMeta(), "fdatenode"));
        dataSetX = dataSetX.addFields(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("fprodorg", (DataType)DataType.LongType), new Field("fconfigid", (DataType)DataType.LongType), new Field("fplanscope", (DataType)DataType.LongType), new Field("fauxpropertyid", (DataType)DataType.LongType), new Field("fprojectid", (DataType)DataType.LongType)}, new Object[]{0L, 0L, 0L, 0L, 0L, 0L});
        return dataSetX;
    }

    private static DataSet filterHisData(DataSet dataSet, DynamicObject hisevent) {
        hisevent = BusinessDataServiceHelper.loadSingle((Object)hisevent.getPkValue(), (String)"mds_event");
        Date hisstartdate = hisevent.getDate("startdate");
        Date hisenddate = hisevent.getDate("enddate");
        long hisstartTimeMillis = 0L;
        if (hisstartdate != null) {
            hisstartTimeMillis = hisstartdate.getTime();
        }
        long hisendTimeMillis = 0L;
        if (hisenddate != null) {
            hisendTimeMillis = hisenddate.getTime();
            hisendTimeMillis += 86400000L;
        }
        final long finalHisstartTimeMillis = hisstartTimeMillis;
        final long finalHisendTimeMillis = hisendTimeMillis;
        dataSet = dataSet.filter(new FilterFunction(){

            public boolean test(Row row) {
                Date fdatenode = row.getDate("fdatenode");
                if (fdatenode != null) {
                    long timeMillis = fdatenode.getTime();
                    return timeMillis >= finalHisstartTimeMillis && timeMillis < finalHisendTimeMillis;
                }
                return false;
            }
        });
        return dataSet;
    }

    private static List<Date> getDates(DynamicObject calcSet, Calendar c) {
        String cycle = calcSet.getString("cycle");
        int periods = calcSet.getInt("periods");
        Date fcstartdate = calcSet.getDate("fcstartdate");
        if (fcstartdate == null) {
            fcstartdate = c.getTime();
        }
        int calendarField = 3;
        if ("0".equals(cycle)) {
            fcstartdate = DateUtil.getTheWeekStart(fcstartdate, 2);
        } else if ("1".equals(cycle)) {
            fcstartdate = DateUtil.getMonthOffset(fcstartdate, "Mbeg");
            calendarField = 2;
        }
        Calendar startc = Calendar.getInstance();
        startc.setTime(fcstartdate);
        startc.set(11, 0);
        startc.set(12, 0);
        startc.set(13, 0);
        startc.set(14, 0);
        ArrayList<Date> dateList = new ArrayList<Date>(16);
        for (int i = 0; i < periods; ++i) {
            dateList.add(startc.getTime());
            startc.add(calendarField, 1);
        }
        return dateList;
    }
}

