/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.plancalc.source.loadhandler.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.plancalc.ext.MdsDataRelFnFieldExt;
import kd.mmc.mds.common.plancalc.ext.MdsDataRelFnFieldExtDefaultImpl;
import kd.mmc.mds.common.plancalc.source.loadhandler.LoadDataHandler;
import kd.mmc.mds.mservice.algox.DayTransformMapFunction;

public class SetoffLoadDataHandler
implements LoadDataHandler {
    private DynamicObject dynamicObject;
    private Date outlookDate;

    public SetoffLoadDataHandler(DynamicObject dynamicObject, Date outlookDate) {
        this.dynamicObject = dynamicObject;
        this.outlookDate = outlookDate;
    }

    @Override
    public DataSetX loadData(JobSession session) {
        Object sourcenameId = this.dynamicObject.getDynamicObject("sourcename").getPkValue();
        DynamicObject setoffverid = this.dynamicObject.getDynamicObject("setoffverid");
        QFilter qFilter = new QFilter("setid", "=", sourcenameId);
        qFilter.and(new QFilter("setoffqty", "=", (Object)0));
        qFilter.and(new QFilter("forecastqty", "!=", (Object)0));
        qFilter.and(new QFilter("fordate", "<=", (Object)this.outlookDate));
        if (setoffverid != null) {
            qFilter.and(new QFilter("setoffverid", "=", setoffverid.getPkValue()));
        }
        HashMap<String, String> mdsDataRelFn = new HashMap<String, String>(16);
        mdsDataRelFn.put("id", "id");
        mdsDataRelFn.put("fmaterialid", "materialid");
        mdsDataRelFn.put("fbaseunitid", "materialid.baseunit");
        mdsDataRelFn.put("fdatenode", "fordate");
        mdsDataRelFn.put("ffcqty", "execqty");
        mdsDataRelFn.put("fprecision", "materialid.baseunit.precision");
        mdsDataRelFn.put("fprecisionaccount", "materialid.baseunit.precisionaccount");
        PluginProxy pluginProxy = PluginProxy.create((Object)new MdsDataRelFnFieldExtDefaultImpl(), MdsDataRelFnFieldExt.class, (String)"MDS_PLANCALC_MDSDATARELFN_EXT", null);
        List results = pluginProxy.callReplaceIfPresent(MdsDataRelFnFieldExt::getMdsDataRelFnExtMap);
        if (results != null && !results.isEmpty()) {
            for (Map map : results) {
                if (map == null) continue;
                mdsDataRelFn.putAll(map);
            }
        }
        String selectFields = mdsDataRelFn.entrySet().stream().map(o -> (String)o.getValue() + " as " + (String)o.getKey()).collect(Collectors.joining(","));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"fnReport", (String)"mds_fnreport", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
        DataSetInput dataSetInput = new DataSetInput(dataSet);
        DataSetX dataSetX = session.fromInput((Input)dataSetInput);
        dataSetX = dataSetX.map((MapFunction)new DayTransformMapFunction(dataSetX.getRowMeta(), "fdatenode"));
        dataSetX = dataSetX.addFields(new Field[]{new Field("fprodorg", (DataType)DataType.LongType)}, new Object[]{0L});
        return dataSetX;
    }
}

